/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.redisplay;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.tool.user.redisplay.ERaster;

public class TransparentRaster
implements ERaster {
    final int[] layerBitMap;
    final int intsPerRow;

    TransparentRaster(int intsPerRow, int[] layerBitMap) {
        this.layerBitMap = layerBitMap;
        this.intsPerRow = intsPerRow;
    }

    public TransparentRaster(int numIntsPerRow, int height) {
        this.intsPerRow = numIntsPerRow;
        this.layerBitMap = new int[height * numIntsPerRow];
    }

    @Override
    public void fillBox(int lX, int hX, int lY, int hY) {
        int baseIndex = lY * this.intsPerRow;
        int lIndex = baseIndex + (lX >> 5);
        int hIndex = baseIndex + (hX >> 5);
        if (lIndex == hIndex) {
            int mask = (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
            for (int y = lY; y < hY; ++y) {
                int n = lIndex;
                this.layerBitMap[n] = this.layerBitMap[n] | mask;
                lIndex += this.intsPerRow;
            }
        } else {
            int lMask = -(1 << (lX & 0x1F));
            int hMask = (2 << (hX & 0x1F)) - 1;
            for (int y = lY; y <= hY; ++y) {
                int n = lIndex;
                this.layerBitMap[n] = this.layerBitMap[n] | lMask;
                for (int index = lIndex + 1; index < hIndex; ++index) {
                    this.layerBitMap[index] = -1;
                }
                int n2 = hIndex;
                this.layerBitMap[n2] = this.layerBitMap[n2] | hMask;
                lIndex += this.intsPerRow;
                hIndex += this.intsPerRow;
            }
        }
    }

    public void eraseBox(int lX, int hX, int lY, int hY) {
        int baseIndex = lY * this.intsPerRow;
        int lIndex = baseIndex + (lX >> 5);
        int hIndex = baseIndex + (hX >> 5);
        if (lIndex == hIndex) {
            int mask = (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
            mask ^= 0xFFFFFFFF;
            for (int y = lY; y < hY; ++y) {
                int n = lIndex;
                this.layerBitMap[n] = this.layerBitMap[n] & mask;
                lIndex += this.intsPerRow;
            }
        } else {
            int lMask = -(1 << (lX & 0x1F));
            int hMask = (2 << (hX & 0x1F)) - 1;
            lMask ^= 0xFFFFFFFF;
            hMask ^= 0xFFFFFFFF;
            for (int y = lY; y <= hY; ++y) {
                int n = lIndex;
                this.layerBitMap[n] = this.layerBitMap[n] & lMask;
                for (int index = lIndex + 1; index < hIndex; ++index) {
                    this.layerBitMap[index] = 0;
                }
                int n2 = hIndex;
                this.layerBitMap[n2] = this.layerBitMap[n2] & hMask;
                lIndex += this.intsPerRow;
                hIndex += this.intsPerRow;
            }
        }
    }

    public void eraseAll() {
        for (int i = 0; i < this.layerBitMap.length; ++i) {
            this.layerBitMap[i] = 0;
        }
    }

    @Override
    public void fillHorLine(int y, int lX, int hX) {
        int baseIndex = y * this.intsPerRow;
        int lIndex = baseIndex + (lX >> 5);
        int hIndex = baseIndex + (hX >> 5);
        if (lIndex == hIndex) {
            int n = lIndex;
            this.layerBitMap[n] = this.layerBitMap[n] | (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
        } else {
            int n = lIndex++;
            this.layerBitMap[n] = this.layerBitMap[n] | -(1 << (lX & 0x1F));
            while (lIndex < hIndex) {
                int n2 = lIndex++;
                this.layerBitMap[n2] = this.layerBitMap[n2] | 0xFFFFFFFF;
            }
            int n3 = hIndex;
            this.layerBitMap[n3] = this.layerBitMap[n3] | (2 << (hX & 0x1F)) - 1;
        }
    }

    @Override
    public void fillVerLine(int x, int lY, int hY) {
        int baseIndex = lY * this.intsPerRow + (x >> 5);
        int mask = 1 << (x & 0x1F);
        for (int y = lY; y <= hY; ++y) {
            int n = baseIndex;
            this.layerBitMap[n] = this.layerBitMap[n] | mask;
            baseIndex += this.intsPerRow;
        }
    }

    @Override
    public void fillPoint(int x, int y) {
        int n = y * this.intsPerRow + (x >> 5);
        this.layerBitMap[n] = this.layerBitMap[n] | 1 << (x & 0x1F);
    }

    @Override
    public void drawHorLine(int y, int lX, int hX) {
        int baseIndex = y * this.intsPerRow;
        int lIndex = baseIndex + (lX >> 5);
        int hIndex = baseIndex + (hX >> 5);
        if (lIndex == hIndex) {
            int n = lIndex;
            this.layerBitMap[n] = this.layerBitMap[n] | (2 << (hX & 0x1F)) - (1 << (lX & 0x1F));
        } else {
            int n = lIndex++;
            this.layerBitMap[n] = this.layerBitMap[n] | -(1 << (lX & 0x1F));
            while (lIndex < hIndex) {
                int n2 = lIndex++;
                this.layerBitMap[n2] = this.layerBitMap[n2] | 0xFFFFFFFF;
            }
            int n3 = hIndex;
            this.layerBitMap[n3] = this.layerBitMap[n3] | (2 << (hX & 0x1F)) - 1;
        }
    }

    @Override
    public void drawVerLine(int x, int lY, int hY) {
        int baseIndex = lY * this.intsPerRow + (x >> 5);
        int mask = 1 << (x & 0x1F);
        for (int y = lY; y <= hY; ++y) {
            int n = baseIndex;
            this.layerBitMap[n] = this.layerBitMap[n] | mask;
            baseIndex += this.intsPerRow;
        }
    }

    @Override
    public void drawPoint(int x, int y) {
        int n = y * this.intsPerRow + (x >> 5);
        this.layerBitMap[n] = this.layerBitMap[n] | 1 << (x & 0x1F);
    }

    @Override
    public EGraphics.Outline getOutline() {
        return null;
    }

    @Override
    public void copyBits(TransparentRaster src, int minSrcX, int maxSrcX, int minSrcY, int maxSrcY, int dx, int dy) {
        int[] srcLayerBitMap = src.layerBitMap;
        int minDestX = minSrcX + dx;
        int maxDestX = maxSrcX + dx;
        int minDestY = minSrcY + dy;
        int leftShift = dx & 0x1F;
        int rightShift = 32 - leftShift;
        int srcBaseIndex = minSrcY * src.intsPerRow + (minSrcX >> 5);
        int destBaseIndex = minDestY * this.intsPerRow + (minDestX >> 5);
        int numDestInts = (maxDestX >> 5) - (minDestX >> 5);
        if (numDestInts == 0) {
            int destMask = (2 << (maxDestX & 0x1F)) - (1 << (minDestX & 0x1F));
            if (minSrcX >> 5 != maxSrcX >> 5) {
                for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                    int s0 = srcLayerBitMap[srcBaseIndex];
                    int s1 = srcLayerBitMap[srcBaseIndex + 1];
                    int v = (s0 >>> rightShift | s1 << leftShift) & destMask;
                    if (v != 0) {
                        int n = destBaseIndex;
                        this.layerBitMap[n] = this.layerBitMap[n] | v;
                    }
                    srcBaseIndex += src.intsPerRow;
                    destBaseIndex += this.intsPerRow;
                }
            } else if ((minDestX & 0x1F) >= (minSrcX & 0x1F)) {
                for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                    int s2 = srcLayerBitMap[srcBaseIndex];
                    int v = s2 << leftShift & destMask;
                    if (v != 0) {
                        int n = destBaseIndex;
                        this.layerBitMap[n] = this.layerBitMap[n] | v;
                    }
                    srcBaseIndex += src.intsPerRow;
                    destBaseIndex += this.intsPerRow;
                }
            } else {
                for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                    int s3 = srcLayerBitMap[srcBaseIndex];
                    int v = s3 >>> rightShift & destMask;
                    if (v != 0) {
                        int n = destBaseIndex;
                        this.layerBitMap[n] = this.layerBitMap[n] | v;
                    }
                    srcBaseIndex += src.intsPerRow;
                    destBaseIndex += this.intsPerRow;
                }
            }
        } else {
            int minDestMask = -(1 << (minDestX & 0x1F));
            int maxDestMask = (2 << (maxDestX & 0x1F)) - 1;
            int srcIncr = src.intsPerRow - (maxSrcX >> 5) + (minSrcX >> 5) - 1;
            if (leftShift == 0) {
                for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                    int vf;
                    int v0;
                    assert (srcBaseIndex == srcY * src.intsPerRow + (minSrcX >> 5));
                    assert (destBaseIndex == (srcY + dy) * this.intsPerRow + (minDestX >> 5));
                    if ((v0 = srcLayerBitMap[srcBaseIndex++] & minDestMask) != 0) {
                        int n = destBaseIndex;
                        this.layerBitMap[n] = this.layerBitMap[n] | v0;
                    }
                    ++destBaseIndex;
                    for (int i = 1; i < numDestInts; ++i) {
                        int v;
                        if ((v = srcLayerBitMap[srcBaseIndex++]) != 0) {
                            int n = destBaseIndex;
                            this.layerBitMap[n] = this.layerBitMap[n] | v;
                        }
                        ++destBaseIndex;
                    }
                    if ((vf = srcLayerBitMap[srcBaseIndex++] & maxDestMask) != 0) {
                        int n = destBaseIndex;
                        this.layerBitMap[n] = this.layerBitMap[n] | vf;
                    }
                    srcBaseIndex += srcIncr;
                    destBaseIndex += this.intsPerRow - numDestInts;
                }
            } else if (numDestInts == 2 && minSrcX >> 5 == maxSrcX >> 5) {
                for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                    int vf;
                    assert (srcBaseIndex == srcY * src.intsPerRow + (minSrcX >> 5));
                    assert (destBaseIndex == (srcY + dy) * this.intsPerRow + (minDestX >> 5));
                    int s4 = srcLayerBitMap[srcBaseIndex];
                    int b0 = srcLayerBitMap[srcBaseIndex++];
                    int v0 = s4 << leftShift & minDestMask;
                    if (v0 != 0) {
                        int n = destBaseIndex;
                        this.layerBitMap[n] = this.layerBitMap[n] | v0;
                    }
                    if ((vf = s4 >>> rightShift & maxDestMask) != 0) {
                        int n = destBaseIndex + 1;
                        this.layerBitMap[n] = this.layerBitMap[n] | vf;
                    }
                    srcBaseIndex += src.intsPerRow;
                    destBaseIndex += this.intsPerRow;
                }
            } else {
                boolean minSrcPair = leftShift > (minDestX & 0x1F);
                boolean maxSrcPair = leftShift <= (maxDestX & 0x1F);
                for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                    int b0;
                    int v0;
                    assert (srcBaseIndex == srcY * src.intsPerRow + (minSrcX >> 5));
                    assert (destBaseIndex == (srcY + dy) * this.intsPerRow + (minDestX >> 5));
                    int s5 = minSrcPair ? srcLayerBitMap[srcBaseIndex++] : 0;
                    if ((v0 = (s5 >>> rightShift | (b0 = srcLayerBitMap[srcBaseIndex++]) << leftShift) & minDestMask) != 0) {
                        int n = destBaseIndex;
                        this.layerBitMap[n] = this.layerBitMap[n] | v0;
                    }
                    ++destBaseIndex;
                    s5 = b0;
                    for (int i = 1; i < numDestInts; ++i) {
                        int b;
                        int v;
                        if ((v = s5 >>> rightShift | (b = srcLayerBitMap[srcBaseIndex++]) << leftShift) != 0) {
                            int n = destBaseIndex;
                            this.layerBitMap[n] = this.layerBitMap[n] | v;
                        }
                        ++destBaseIndex;
                        s5 = b;
                    }
                    int bf = maxSrcPair ? srcLayerBitMap[srcBaseIndex++] : 0;
                    int vf = (s5 >>> rightShift | bf << leftShift) & maxDestMask;
                    if (vf != 0) {
                        int n = destBaseIndex;
                        this.layerBitMap[n] = this.layerBitMap[n] | vf;
                    }
                    srcBaseIndex += srcIncr;
                    destBaseIndex += this.intsPerRow - numDestInts;
                }
            }
        }
    }
}

