/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.ToolSettings;
import com.sun.electric.tool.UserInterfaceExec;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.output.IRSIM;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.simulation.Engine;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.als.ALS;
import com.sun.electric.tool.simulation.irsim.IRSIM;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SimulationTool
extends Tool {
    private static SimulationTool tool = new SimulationTool();
    public static final Variable.Key RISE_DELAY_KEY = Variable.newKey("SIM_rise_delay");
    public static final Variable.Key FALL_DELAY_KEY = Variable.newKey("SIM_fall_delay");
    public static final Variable.Key WEAK_NODE_KEY = Variable.newKey("SIM_weak_node");
    public static final Variable.Key M_FACTOR_KEY = Variable.newKey("ATTR_M");
    public static final int ALS_ENGINE = 0;
    public static final int IRSIM_ENGINE = 1;
    private static Pref cacheFastHenryUseSingleFrequency = Pref.makeBooleanPref("FastHenryUseSingleFrequency", SimulationTool.tool.prefs, false);
    private static Pref cacheFastHenryStartFrequency = Pref.makeDoublePref("FastHenryStartFrequency", SimulationTool.tool.prefs, 0.0);
    private static Pref cacheFastHenryEndFrequency = Pref.makeDoublePref("FastHenryEndFrequency", SimulationTool.tool.prefs, 0.0);
    private static Pref cacheFastHenryRunsPerDecade = Pref.makeIntPref("FastHenryRunsPerDecade", SimulationTool.tool.prefs, 1);
    private static Pref cacheFastHenryMultiPole = Pref.makeBooleanPref("FastHenryMultiPole", SimulationTool.tool.prefs, false);
    private static Pref cacheFastHenryNumPoles = Pref.makeIntPref("FastHenryNumPoles", SimulationTool.tool.prefs, 20);
    private static Pref cacheFastHenryDefThickness = Pref.makeDoublePref("FastHenryDefThickness", SimulationTool.tool.prefs, 2.0);
    private static Pref cacheFastHenryWidthSubdivisions = Pref.makeIntPref("FastHenryWidthSubdivisions", SimulationTool.tool.prefs, 1);
    private static Pref cacheFastHenryHeightSubdivisions = Pref.makeIntPref("FastHenryHeightSubdivisions", SimulationTool.tool.prefs, 1);
    private static Pref cacheFastHenryMaxSegLength = Pref.makeDoublePref("FastHenryMaxSegLength", SimulationTool.tool.prefs, 0.0);
    private static Pref cacheVerilogStopAtStandardCells = Pref.makeBooleanPref("VerilogStopAtStandardCells", SimulationTool.tool.prefs, false);
    private static Pref cacheVerilogNetlistNonstandardCells = Pref.makeBooleanPref("VerliogNetlistNonstandardCells", SimulationTool.tool.prefs, true);
    private static Pref cachePreserveVerilogFormating = Pref.makeBooleanPref("PreserveVerilogFormating", SimulationTool.tool.prefs, true);
    private static Pref cacheVerilogParameterizeModuleNames = Pref.makeBooleanPref("VerilogParamertizeModuleNames", SimulationTool.tool.prefs, false);
    private static Pref cacheVerilogWriteModuleForEachIcon = Pref.makeBooleanPref("VerilogWriteModuleForEachIcon", SimulationTool.tool.prefs, false);
    private static Pref cacheVerilogRunPlacementTool = Pref.makeBooleanPref("cacheVerilogRunPlacementTool", SimulationTool.tool.prefs, false);
    private static Pref cacheVerilogNoWriteEmptyModules = Pref.makeBooleanPref("VerilogNoWriteEmptyModules", SimulationTool.tool.prefs, false);
    private static Pref cacheCDLLibName = Pref.makeStringPref("CDLLibName", SimulationTool.tool.prefs, "");
    private static Pref cacheCDLLibPath = Pref.makeStringPref("CDLLibPath", SimulationTool.tool.prefs, "");
    private static Pref cacheCDLConvertBrackets = Pref.makeBooleanPref("CDLConvertBrackets", SimulationTool.tool.prefs, false);
    private static Pref cacheCDLIncludeFile = Pref.makeStringPref("CDLIncludeFile", SimulationTool.tool.prefs, "");
    private static Pref cacheBuiltInResimulateEach = Pref.makeBooleanPref("BuiltInResimulateEach", SimulationTool.tool.prefs, true);
    private static Pref cacheBuiltInAutoAdvance = Pref.makeBooleanPref("BuiltInAutoAdvance", SimulationTool.tool.prefs, false);
    private static Pref cacheWaveformDisplayMultiState = Pref.makeBooleanPref("WaveformDisplayMultiState", SimulationTool.tool.prefs, false);
    private static Pref cacheIRSIMShowsCommands = Pref.makeBooleanPref("IRSIMShowsCommands", SimulationTool.tool.prefs, false);
    private static Pref cacheIRSIMDebugging = Pref.makeIntPref("IRSIMDebugging", SimulationTool.tool.prefs, 0);
    private static Pref cacheIRSIMParameterFile = Pref.makeStringPref("IRSIMParameterFile", SimulationTool.tool.prefs, "scmos0.3.prm");
    private static Pref cacheIRSIMStepModel = Pref.makeStringPref("IRSIMStepModel", SimulationTool.tool.prefs, "RC");
    private static Pref cacheIRSIMDelayedX = Pref.makeBooleanPref("IRSIMDelayedX", SimulationTool.tool.prefs, true);
    private static Pref cacheSpiceEngine = Pref.makeIntPref("SpiceEngine", SimulationTool.tool.prefs, SpiceEngine.SPICE_ENGINE_H.code());
    private static Pref cacheSpiceLevel = Pref.makeStringPref("SpiceLevel", SimulationTool.tool.prefs, "1");
    private static Pref cacheSpiceShortResistors = Pref.makeIntPref("SpiceShortResistors", SimulationTool.tool.prefs, 0);
    public static final String spiceRunChoiceDontRun = "Don't Run";
    public static final String spiceRunChoiceRunIgnoreOutput = "Run, Ignore Output";
    public static final String spiceRunChoiceRunReportOutput = "Run, Report Output";
    private static final String[] spiceRunChoices = new String[]{"Don't Run", "Run, Ignore Output", "Run, Report Output"};
    private static Pref cacheSpiceRunChoice = Pref.makeIntPref("SpiceRunChoice", SimulationTool.tool.prefs, 0);
    private static Pref cacheSpiceRunDir = Pref.makeStringPref("SpiceRunDir", SimulationTool.tool.prefs, "");
    private static Pref cacheSpiceUseRunDir = Pref.makeBooleanPref("SpiceUseRunDir", SimulationTool.tool.prefs, false);
    private static Pref cacheSpiceOutputOverwrite = Pref.makeBooleanPref("SpiceOverwriteOutputFile", SimulationTool.tool.prefs, false);
    private static Pref cacheSpiceRunProbe = Pref.makeBooleanPref("SpiceRunProbe", SimulationTool.tool.prefs, false);
    private static Pref cacheSpiceRunProgram = Pref.makeStringPref("SpiceRunProgram", SimulationTool.tool.prefs, "");
    private static Pref cacheSpiceRunProgramArgs = Pref.makeStringPref("SpiceRunProgramArgs", SimulationTool.tool.prefs, "");
    private static Pref cacheSpiceMaxCharsPerLine = Pref.makeIntPref("SpiceMaxCharsPerLine", SimulationTool.tool.prefs, 512);
    private static Pref cacheSpicePartsLibrary = Pref.makeStringPref("SpicePartsLibrary", SimulationTool.tool.prefs, "spiceparts");
    private static Pref cacheSpiceHeaderCardInfo = Pref.makeStringPref("SpiceHeaderCardInfo", SimulationTool.tool.prefs, "");
    private static Pref cacheSpiceTrailerCardInfo = Pref.makeStringPref("SpiceTrailerCardInfo", SimulationTool.tool.prefs, "");
    private static Pref cacheSpiceParasiticsLevel = Pref.makeIntPref("SpiceParasiticsLevel", SimulationTool.tool.prefs, SpiceParasitics.SIMPLE.code());
    public static Pref cacheParasiticsUseVerboseNaming = Pref.makeBooleanPref("ParasiticsUseVerboseNaming", SimulationTool.tool.prefs, true);
    public static Pref cacheParasiticsBackAnnotateLayout = Pref.makeBooleanPref("ParasiticsBackAnnotateLayout", SimulationTool.tool.prefs, false);
    public static Pref cacheParasiticsExtractPowerGround = Pref.makeBooleanPref("ParasiticsExtractPowerGround", SimulationTool.tool.prefs, false);
    public static Pref cacheParasiticsUseExemptedNetsFile = Pref.makeBooleanPref("UseExemptedNetsFile", SimulationTool.tool.prefs, false);
    public static Pref cacheParasiticsIgnoreExemptedNets = Pref.makeBooleanPref("IgnoreExemptedNets", SimulationTool.tool.prefs, true);
    public static Pref cacheParasiticsExtractsR = Pref.makeBooleanPref("ParasiticsExtractsR", SimulationTool.tool.prefs, true);
    public static Pref cacheParasiticsExtractsC = Pref.makeBooleanPref("ParasiticsExtractsC", SimulationTool.tool.prefs, true);
    private static Pref cacheGlobalTreatment = Pref.makeIntPref("SpiceGlobalTreatment", SimulationTool.tool.prefs, SpiceGlobal.USEGLOBALBLOCK.getCode());
    private static Pref cacheSpiceWritePwrGndInTopCell = Pref.makeBooleanPref("cacheSpiceWritePwrGndInTopCell", SimulationTool.tool.prefs, true);
    private static Pref cacheSpiceUseCellParameters = Pref.makeBooleanPref("SpiceUseCellParameters", SimulationTool.tool.prefs, false);
    private static Pref cacheSpiceWriteTransSizeInLambda = Pref.makeBooleanPref("SpiceWriteTransSizeInLambda", SimulationTool.tool.prefs, false);
    private static Pref cacheSpiceWriteSubcktTopCell = Pref.makeBooleanPref("SpiceWriteSubcktTopCell", SimulationTool.tool.prefs, false);
    private static Pref cacheSpiceWriteTopCellInstance = Pref.makeBooleanPref("SpiceWriteTopCellInstance", SimulationTool.tool.prefs, true);
    private static Pref cacheSpiceWriteEmptySubckts = Pref.makeBooleanPref("SpiceWriteEmptySubckts", SimulationTool.tool.prefs, true);
    private static Pref cacheSpiceWriteFinalDotEnd = Pref.makeBooleanPref("SpiceWriteFinalDotEnd", SimulationTool.tool.prefs, true);
    private static Pref cachedSpiceIgnoreModelFiles = Pref.makeBooleanPref("SpiceIgnoreModelFiles", SimulationTool.tool.prefs, false);
    private static Pref cacheSpiceExtractedNetDelimiter = Pref.makeStringPref("SpiceExtractedNetDelimiter", SimulationTool.tool.prefs, ":");
    private static Pref cacheSpiceInputPlaces = Pref.makeBooleanPref("SpiceInputPlaces", SimulationTool.tool.prefs, true);
    private static Pref cacheCDLLash = Pref.makeBooleanPref("CDLLash", SimulationTool.tool.prefs, false);

    private SimulationTool() {
        super("simulation");
    }

    @Override
    public void init() {
    }

    public static SimulationTool getSimulationTool() {
        return tool;
    }

    public static void startSimulation(int engine, String deckFile, Cell prevCell, Engine prevEngine, boolean doNow) {
        Cell cell = null;
        VarContext context = null;
        String fileName = null;
        if (prevCell != null) {
            cell = prevCell;
        } else {
            UserInterface ui = Job.getUserInterface();
            if (deckFile != null) {
                if (deckFile.length() > 0) {
                    fileName = deckFile;
                } else {
                    fileName = OpenFile.chooseInputFile(FileType.IRSIM, "IRSIM deck to simulate", null);
                    if (fileName == null) {
                        return;
                    }
                }
                cell = ui.getCurrentCell();
            } else {
                cell = ui.needCurrentCell();
                if (cell == null) {
                    return;
                }
                EditWindow_ wnd = ui.getCurrentEditWindow_();
                if (wnd != null) {
                    context = wnd.getVarContext();
                }
            }
        }
        switch (engine) {
            case 0: {
                Cell originalCell = cell;
                boolean convert = false;
                boolean compile = false;
                if (cell.getView() != View.NETLISTALS) {
                    if (cell.isSchematic() || cell.getView() == View.LAYOUT) {
                        Cell vhdlCell = cell.otherView(View.VHDL);
                        if (vhdlCell != null && vhdlCell.getRevisionDate().after(cell.getRevisionDate())) {
                            cell = vhdlCell;
                        } else {
                            convert = true;
                            compile = true;
                        }
                    }
                    if (cell.getView() == View.VHDL || cell.getView() == View.VERILOG) {
                        Cell netListCell = cell.otherView(View.NETLISTQUISC);
                        if (netListCell != null && netListCell.getRevisionDate().after(cell.getRevisionDate())) {
                            cell = netListCell;
                        } else {
                            compile = true;
                        }
                    }
                }
                new ALS.DoALSActivity(cell, convert, compile, originalCell, prevEngine, tool, doNow);
                break;
            }
            case 1: {
                if (!IRSIM.hasIRSIM()) {
                    return;
                }
                new RunIRSIM(cell, context, fileName, doNow);
            }
        }
    }

    public static void update() {
        Engine engine = SimulationTool.findEngine();
        if (engine == null) {
            return;
        }
        engine.update();
    }

    public static void setSignalHigh() {
        Engine engine = SimulationTool.findEngine();
        if (engine == null) {
            return;
        }
        engine.setSignalHigh();
    }

    public static void setSignalLow() {
        Engine engine = SimulationTool.findEngine();
        if (engine == null) {
            return;
        }
        engine.setSignalLow();
    }

    public static void setSignalX() {
        Engine engine = SimulationTool.findEngine();
        if (engine == null) {
            return;
        }
        engine.setSignalX();
    }

    public static void setClock() {
        Engine engine = SimulationTool.findEngine();
        if (engine == null) {
            return;
        }
        double period = ClockSpec.getClockSpec();
        if (period <= 0.0) {
            return;
        }
        engine.setClock(period);
    }

    public static void showSignalInfo() {
        Engine engine = SimulationTool.findEngine();
        if (engine == null) {
            return;
        }
        engine.showSignalInfo();
    }

    public static void removeStimuliFromSignal() {
        Engine engine = SimulationTool.findEngine();
        if (engine == null) {
            return;
        }
        engine.removeStimuliFromSignal();
    }

    public static boolean removeSelectedStimuli() {
        Engine engine = SimulationTool.findEngine();
        if (engine == null) {
            return false;
        }
        return engine.removeSelectedStimuli();
    }

    public static void removeAllStimuli() {
        Engine engine = SimulationTool.findEngine();
        if (engine == null) {
            return;
        }
        engine.removeAllStimuli();
    }

    public static void saveStimuli() {
        Engine engine = SimulationTool.findEngine();
        if (engine == null) {
            return;
        }
        FileType fileType = engine.getVectorsFileType();
        String hintFileName = engine.getStimuli().getCell().getName() + "." + fileType.getFirstExtension();
        String stimuliFileName = OpenFile.chooseOutputFile(fileType, fileType.getName(), hintFileName);
        if (stimuliFileName == null) {
            return;
        }
        try {
            engine.saveStimuli(new File(stimuliFileName));
            System.out.println("Wrote " + stimuliFileName);
        }
        catch (IOException e) {
            System.out.println("Error writing " + stimuliFileName);
        }
    }

    public static void restoreStimuli(String fileName) {
        FileType fileType;
        Engine engine = SimulationTool.findEngine();
        if (engine == null) {
            return;
        }
        if (fileName == null && (fileName = OpenFile.chooseInputFile(fileType = engine.getVectorsFileType(), fileType.getName(), null)) == null) {
            return;
        }
        URL url = TextUtils.makeURLToFile(fileName);
        try {
            WaveformWindow ww;
            System.out.println("Reading " + fileName);
            engine.restoreStimuli(url);
            Stimuli sd = engine.getStimuli();
            if (sd != null && (ww = sd.getWaveformWindow()) != null) {
                ww.fillScreen();
            }
        }
        catch (IOException e) {
            System.out.println("Error reading " + fileName + "(" + e.getMessage() + ")");
        }
    }

    private static Engine findEngine() {
        Engine engine = null;
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WaveformWindow ww;
            Engine e;
            WindowFrame wf = it.next();
            if (!(wf.getContent() instanceof WaveformWindow) || (e = (ww = (WaveformWindow)wf.getContent()).getSimData().getEngine()) == null) continue;
            if (wf == WindowFrame.getCurrentWindowFrame()) {
                return e;
            }
            engine = e;
        }
        if (engine == null) {
            System.out.println("No simulator is ready to handle the command");
        }
        return engine;
    }

    public static void setSpiceModel() {
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        NodeInst ni = (NodeInst)wnd.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        new SetSpiceModel(ni);
    }

    public static void setVerilogWireCommand(int type) {
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        List<Geometric> list = wnd.getHighlightedEObjs(false, true);
        if (list.size() == 0) {
            System.out.println("Must select arcs before setting their type");
            return;
        }
        new SetWireType(list, type);
    }

    public static void setTransistorStrengthCommand(boolean weak) {
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        NodeInst ni = (NodeInst)wnd.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        new SetTransistorStrength(ni, weak);
    }

    public static boolean isFastHenryUseSingleFrequency() {
        return cacheFastHenryUseSingleFrequency.getBoolean();
    }

    public static void setFastHenryUseSingleFrequency(boolean s2) {
        cacheFastHenryUseSingleFrequency.setBoolean(s2);
    }

    public static boolean isFactoryFastHenryUseSingleFrequency() {
        return cacheFastHenryUseSingleFrequency.getBooleanFactoryValue();
    }

    public static double getFastHenryStartFrequency() {
        return cacheFastHenryStartFrequency.getDouble();
    }

    public static void setFastHenryStartFrequency(double s2) {
        cacheFastHenryStartFrequency.setDouble(s2);
    }

    public static double getFactoryFastHenryStartFrequency() {
        return cacheFastHenryStartFrequency.getDoubleFactoryValue();
    }

    public static double getFastHenryEndFrequency() {
        return cacheFastHenryEndFrequency.getDouble();
    }

    public static void setFastHenryEndFrequency(double e) {
        cacheFastHenryEndFrequency.setDouble(e);
    }

    public static double getFactoryFastHenryEndFrequency() {
        return cacheFastHenryEndFrequency.getDoubleFactoryValue();
    }

    public static int getFastHenryRunsPerDecade() {
        return cacheFastHenryRunsPerDecade.getInt();
    }

    public static void setFastHenryRunsPerDecade(int r) {
        cacheFastHenryRunsPerDecade.setInt(r);
    }

    public static int getFactoryFastHenryRunsPerDecade() {
        return cacheFastHenryRunsPerDecade.getIntFactoryValue();
    }

    public static boolean isFastHenryMultiPole() {
        return cacheFastHenryMultiPole.getBoolean();
    }

    public static void setFastHenryMultiPole(boolean mp) {
        cacheFastHenryMultiPole.setBoolean(mp);
    }

    public static boolean isFactoryFastHenryMultiPole() {
        return cacheFastHenryMultiPole.getBooleanFactoryValue();
    }

    public static int getFastHenryNumPoles() {
        return cacheFastHenryNumPoles.getInt();
    }

    public static void setFastHenryNumPoles(int p) {
        cacheFastHenryNumPoles.setInt(p);
    }

    public static int getFactoryFastHenryNumPoles() {
        return cacheFastHenryNumPoles.getIntFactoryValue();
    }

    public static double getFastHenryDefThickness() {
        return cacheFastHenryDefThickness.getDouble();
    }

    public static void setFastHenryDefThickness(double t) {
        cacheFastHenryDefThickness.setDouble(t);
    }

    public static double getFactoryFastHenryDefThickness() {
        return cacheFastHenryDefThickness.getDoubleFactoryValue();
    }

    public static int getFastHenryWidthSubdivisions() {
        return cacheFastHenryWidthSubdivisions.getInt();
    }

    public static void setFastHenryWidthSubdivisions(int w) {
        cacheFastHenryWidthSubdivisions.setInt(w);
    }

    public static int getFactoryFastHenryWidthSubdivisions() {
        return cacheFastHenryWidthSubdivisions.getIntFactoryValue();
    }

    public static int getFastHenryHeightSubdivisions() {
        return cacheFastHenryHeightSubdivisions.getInt();
    }

    public static void setFastHenryHeightSubdivisions(int h) {
        cacheFastHenryHeightSubdivisions.setInt(h);
    }

    public static int getFactoryFastHenryHeightSubdivisions() {
        return cacheFastHenryHeightSubdivisions.getIntFactoryValue();
    }

    public static double getFastHenryMaxSegLength() {
        return cacheFastHenryMaxSegLength.getDouble();
    }

    public static void setFastHenryMaxSegLength(double s2) {
        cacheFastHenryMaxSegLength.setDouble(s2);
    }

    public static double getFactoryFastHenryMaxSegLength() {
        return cacheFastHenryMaxSegLength.getDoubleFactoryValue();
    }

    public static boolean getVerilogUseAssign() {
        return SimulationTool.getVerilogUseAssignSetting().getBoolean();
    }

    public static Setting getVerilogUseAssignSetting() {
        return ToolSettings.getVerilogUseAssignSetting();
    }

    public static boolean getVerilogUseTrireg() {
        return SimulationTool.getVerilogUseTriregSetting().getBoolean();
    }

    public static Setting getVerilogUseTriregSetting() {
        return ToolSettings.getVerilogUseTriregSetting();
    }

    public static void setVerilogStopAtStandardCells(boolean b) {
        cacheVerilogStopAtStandardCells.setBoolean(b);
    }

    public static boolean getVerilogStopAtStandardCells() {
        return cacheVerilogStopAtStandardCells.getBoolean();
    }

    public static boolean getFactoryVerilogStopAtStandardCells() {
        return cacheVerilogStopAtStandardCells.getBooleanFactoryValue();
    }

    public static void setVerilogNetlistNonstandardCells(boolean b) {
        cacheVerilogNetlistNonstandardCells.setBoolean(b);
    }

    public static boolean getVerilogNetlistNonstandardCells() {
        return cacheVerilogNetlistNonstandardCells.getBoolean();
    }

    public static boolean getFactoryVerilogNetlistNonstandardCells() {
        return cacheVerilogNetlistNonstandardCells.getBooleanFactoryValue();
    }

    public static void setPreserveVerilogFormating(boolean b) {
        cachePreserveVerilogFormating.setBoolean(b);
    }

    public static boolean getPreserveVerilogFormating() {
        return cachePreserveVerilogFormating.getBoolean();
    }

    public static boolean getFactoryPreserveVerilogFormating() {
        return cachePreserveVerilogFormating.getBooleanFactoryValue();
    }

    public static void setVerilogParameterizeModuleNames(boolean b) {
        cacheVerilogParameterizeModuleNames.setBoolean(b);
    }

    public static boolean getVerilogParameterizeModuleNames() {
        return cacheVerilogParameterizeModuleNames.getBoolean();
    }

    public static boolean getFactoryVerilogParameterizeModuleNames() {
        return cacheVerilogParameterizeModuleNames.getBooleanFactoryValue();
    }

    public static void setVerilogWriteModuleForEachIcon(boolean b) {
        cacheVerilogWriteModuleForEachIcon.setBoolean(b);
    }

    public static boolean isVerilogWriteModuleForEachIcon() {
        return cacheVerilogWriteModuleForEachIcon.getBoolean();
    }

    public static boolean isFactoryVerilogWriteModuleForEachIcon() {
        return cacheVerilogWriteModuleForEachIcon.getBooleanFactoryValue();
    }

    public static void setVerilogRunPlacementTool(boolean b) {
        cacheVerilogRunPlacementTool.setBoolean(b);
    }

    public static boolean getVerilogRunPlacementTool() {
        return cacheVerilogRunPlacementTool.getBoolean();
    }

    public static boolean getFactoryVerilogRunPlacementTool() {
        return cacheVerilogRunPlacementTool.getBooleanFactoryValue();
    }

    public static void setVerilogNoWriteEmptyModules(boolean b) {
        cacheVerilogNoWriteEmptyModules.setBoolean(b);
    }

    public static boolean isVerilogNoWriteEmptyModules() {
        return cacheVerilogNoWriteEmptyModules.getBoolean();
    }

    public static boolean isFactoryVerilogNoWriteEmptyModules() {
        return cacheVerilogNoWriteEmptyModules.getBooleanFactoryValue();
    }

    public static String getCDLLibName() {
        return cacheCDLLibName.getString();
    }

    public static void setCDLLibName(String libName) {
        cacheCDLLibName.setString(libName);
    }

    public static String getFactoryCDLLibName() {
        return cacheCDLLibName.getStringFactoryValue();
    }

    public static String getCDLLibPath() {
        return cacheCDLLibPath.getString();
    }

    public static void setCDLLibPath(String libName) {
        cacheCDLLibPath.setString(libName);
    }

    public static String getFactoryCDLLibPath() {
        return cacheCDLLibPath.getStringFactoryValue();
    }

    public static boolean isCDLConvertBrackets() {
        return cacheCDLConvertBrackets.getBoolean();
    }

    public static void setCDLConvertBrackets(boolean c) {
        cacheCDLConvertBrackets.setBoolean(c);
    }

    public static boolean isFactoryCDLConvertBrackets() {
        return cacheCDLConvertBrackets.getBooleanFactoryValue();
    }

    public static String getCDLIncludeFile() {
        return cacheCDLIncludeFile.getString();
    }

    public static void setCDLIncludeFile(String file) {
        cacheCDLIncludeFile.setString(file);
    }

    public static String getFactoryCDLIncludeFile() {
        return cacheCDLIncludeFile.getStringFactoryValue();
    }

    public static boolean isBuiltInResimulateEach() {
        return cacheBuiltInResimulateEach.getBoolean();
    }

    public static void setBuiltInResimulateEach(boolean r) {
        cacheBuiltInResimulateEach.setBoolean(r);
    }

    public static boolean isFactoryBuiltInResimulateEach() {
        return cacheBuiltInResimulateEach.getBooleanFactoryValue();
    }

    public static boolean isBuiltInAutoAdvance() {
        return cacheBuiltInAutoAdvance.getBoolean();
    }

    public static void setBuiltInAutoAdvance(boolean r) {
        cacheBuiltInAutoAdvance.setBoolean(r);
    }

    public static boolean isFactoryBuiltInAutoAdvance() {
        return cacheBuiltInAutoAdvance.getBooleanFactoryValue();
    }

    public static boolean isWaveformDisplayMultiState() {
        return cacheWaveformDisplayMultiState.getBoolean();
    }

    public static void setWaveformDisplayMultiState(boolean m) {
        cacheWaveformDisplayMultiState.setBoolean(m);
    }

    public static boolean isFactoryWaveformDisplayMultiState() {
        return cacheWaveformDisplayMultiState.getBooleanFactoryValue();
    }

    public static boolean isIRSIMShowsCommands() {
        return cacheIRSIMShowsCommands.getBoolean();
    }

    public static void setIRSIMShowsCommands(boolean r) {
        cacheIRSIMShowsCommands.setBoolean(r);
    }

    public static boolean isFactoryIRSIMShowsCommands() {
        return cacheIRSIMShowsCommands.getBooleanFactoryValue();
    }

    public static int getIRSIMDebugging() {
        return cacheIRSIMDebugging.getInt();
    }

    public static void setIRSIMDebugging(int p) {
        cacheIRSIMDebugging.setInt(p);
    }

    public static int getFactoryIRSIMDebugging() {
        return cacheIRSIMDebugging.getIntFactoryValue();
    }

    public static String getIRSIMParameterFile() {
        return cacheIRSIMParameterFile.getString();
    }

    public static void setIRSIMParameterFile(String p) {
        cacheIRSIMParameterFile.setString(p);
    }

    public static String getFactoryIRSIMParameterFile() {
        return cacheIRSIMParameterFile.getStringFactoryValue();
    }

    public static String getIRSIMStepModel() {
        return cacheIRSIMStepModel.getString();
    }

    public static void setIRSIMStepModel(String m) {
        cacheIRSIMStepModel.setString(m);
    }

    public static String getFactoryIRSIMStepModel() {
        return cacheIRSIMStepModel.getStringFactoryValue();
    }

    public static boolean isIRSIMDelayedX() {
        return cacheIRSIMDelayedX.getBoolean();
    }

    public static void setIRSIMDelayedX(boolean b) {
        cacheIRSIMDelayedX.setBoolean(b);
    }

    public static boolean isFactoryIRSIMDelayedX() {
        return cacheIRSIMDelayedX.getBooleanFactoryValue();
    }

    public static SpiceEngine getSpiceEngine() {
        int cache = cacheSpiceEngine.getInt();
        for (SpiceEngine p : SpiceEngine.values()) {
            if (p.code() != cache) continue;
            return p;
        }
        return SpiceEngine.values()[0];
    }

    public static void setSpiceEngine(SpiceEngine engine) {
        cacheSpiceEngine.setInt(engine.code());
    }

    public static SpiceEngine getFactorySpiceEngine() {
        int cache = cacheSpiceEngine.getIntFactoryValue();
        for (SpiceEngine p : SpiceEngine.values()) {
            if (p.code() != cache) continue;
            return p;
        }
        return SpiceEngine.values()[0];
    }

    public static String getSpiceLevel() {
        return cacheSpiceLevel.getString();
    }

    public static void setSpiceLevel(String level) {
        cacheSpiceLevel.setString(level);
    }

    public static String getFactorySpiceLevel() {
        return cacheSpiceLevel.getStringFactoryValue();
    }

    public static int getSpiceShortResistors() {
        return cacheSpiceShortResistors.getInt();
    }

    public static void setSpiceShortResistors(int sr) {
        cacheSpiceShortResistors.setInt(sr);
    }

    public static int getFactorySpiceShortResistors() {
        return cacheSpiceShortResistors.getIntFactoryValue();
    }

    public static String[] getSpiceRunChoiceValues() {
        return spiceRunChoices;
    }

    public static String getSpiceRunChoice() {
        return spiceRunChoices[cacheSpiceRunChoice.getInt()];
    }

    public static void setSpiceRunChoice(String choice) {
        String[] values = SimulationTool.getSpiceRunChoiceValues();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(choice)) continue;
            cacheSpiceRunChoice.setInt(i);
            return;
        }
    }

    public static String getFactorySpiceRunChoice() {
        return spiceRunChoices[cacheSpiceRunChoice.getIntFactoryValue()];
    }

    public static String getSpiceRunDir() {
        return cacheSpiceRunDir.getString();
    }

    public static void setSpiceRunDir(String dir) {
        cacheSpiceRunDir.setString(dir);
    }

    public static String getFactorySpiceRunDir() {
        return cacheSpiceRunDir.getStringFactoryValue();
    }

    public static boolean getSpiceUseRunDir() {
        return cacheSpiceUseRunDir.getBoolean();
    }

    public static void setSpiceUseRunDir(boolean b) {
        cacheSpiceUseRunDir.setBoolean(b);
    }

    public static boolean getFactorySpiceUseRunDir() {
        return cacheSpiceUseRunDir.getBooleanFactoryValue();
    }

    public static boolean getSpiceOutputOverwrite() {
        return cacheSpiceOutputOverwrite.getBoolean();
    }

    public static void setSpiceOutputOverwrite(boolean b) {
        cacheSpiceOutputOverwrite.setBoolean(b);
    }

    public static boolean getFactorySpiceOutputOverwrite() {
        return cacheSpiceOutputOverwrite.getBooleanFactoryValue();
    }

    public static boolean getSpiceRunProbe() {
        return cacheSpiceRunProbe.getBoolean();
    }

    public static void setSpiceRunProbe(boolean b) {
        cacheSpiceRunProbe.setBoolean(b);
    }

    public static boolean getFactorySpiceRunProbe() {
        return cacheSpiceRunProbe.getBooleanFactoryValue();
    }

    public static String getSpiceRunProgram() {
        return cacheSpiceRunProgram.getString();
    }

    public static void setSpiceRunProgram(String c) {
        cacheSpiceRunProgram.setString(c);
    }

    public static String getFactorySpiceRunProgram() {
        return cacheSpiceRunProgram.getStringFactoryValue();
    }

    public static String getSpiceRunProgramArgs() {
        return cacheSpiceRunProgramArgs.getString();
    }

    public static void setSpiceRunProgramArgs(String c) {
        cacheSpiceRunProgramArgs.setString(c);
    }

    public static String getFactorySpiceRunProgramArgs() {
        return cacheSpiceRunProgramArgs.getStringFactoryValue();
    }

    public static int getSpiceMaxCharsPerLine() {
        return cacheSpiceMaxCharsPerLine.getInt();
    }

    public static void setSpiceMaxCharsPerLine(int c) {
        cacheSpiceMaxCharsPerLine.setInt(c);
    }

    public static int getFactorySpiceMaxCharsPerLine() {
        return cacheSpiceMaxCharsPerLine.getIntFactoryValue();
    }

    public static String getSpicePartsLibrary() {
        return cacheSpicePartsLibrary.getString();
    }

    public static void setSpicePartsLibrary(String c) {
        cacheSpicePartsLibrary.setString(c);
    }

    public static String getFactorySpicePartsLibrary() {
        return cacheSpicePartsLibrary.getStringFactoryValue();
    }

    public static String getSpiceHeaderCardInfo() {
        return cacheSpiceHeaderCardInfo.getString();
    }

    public static void setSpiceHeaderCardInfo(String spec) {
        cacheSpiceHeaderCardInfo.setString(spec);
    }

    public static String getFactorySpiceHeaderCardInfo() {
        return cacheSpiceHeaderCardInfo.getStringFactoryValue();
    }

    public static String getSpiceTrailerCardInfo() {
        return cacheSpiceTrailerCardInfo.getString();
    }

    public static void setSpiceTrailerCardInfo(String spec) {
        cacheSpiceTrailerCardInfo.setString(spec);
    }

    public static String getFactorySpiceTrailerCardInfo() {
        return cacheSpiceTrailerCardInfo.getStringFactoryValue();
    }

    public static SpiceParasitics getSpiceParasiticsLevel() {
        int curCode = cacheSpiceParasiticsLevel.getInt();
        for (SpiceParasitics p : SpiceParasitics.values()) {
            if (p.code() != curCode) continue;
            return p;
        }
        return null;
    }

    public static void setSpiceParasiticsLevel(SpiceParasitics p) {
        cacheSpiceParasiticsLevel.setInt(p.code);
    }

    public static SpiceParasitics getFactorySpiceParasiticsLevel() {
        int curCode = cacheSpiceParasiticsLevel.getIntFactoryValue();
        for (SpiceParasitics p : SpiceParasitics.values()) {
            if (p.code() != curCode) continue;
            return p;
        }
        return null;
    }

    public static boolean isParasiticsUseVerboseNaming() {
        return cacheParasiticsUseVerboseNaming.getBoolean();
    }

    public static void setParasiticsUseVerboseNaming(boolean b) {
        cacheParasiticsUseVerboseNaming.setBoolean(b);
    }

    public static boolean isFactoryParasiticsUseVerboseNaming() {
        return cacheParasiticsUseVerboseNaming.getBooleanFactoryValue();
    }

    public static boolean isParasiticsBackAnnotateLayout() {
        return cacheParasiticsBackAnnotateLayout.getBoolean();
    }

    public static void setParasiticsBackAnnotateLayout(boolean b) {
        cacheParasiticsBackAnnotateLayout.setBoolean(b);
    }

    public static boolean isFactoryParasiticsBackAnnotateLayout() {
        return cacheParasiticsBackAnnotateLayout.getBooleanFactoryValue();
    }

    public static boolean isParasiticsExtractPowerGround() {
        return cacheParasiticsExtractPowerGround.getBoolean();
    }

    public static void setParasiticsExtractPowerGround(boolean b) {
        cacheParasiticsExtractPowerGround.setBoolean(b);
    }

    public static boolean isFactoryParasiticsExtractPowerGround() {
        return cacheParasiticsExtractPowerGround.getBooleanFactoryValue();
    }

    public static boolean isParasiticsUseExemptedNetsFile() {
        return cacheParasiticsUseExemptedNetsFile.getBoolean();
    }

    public static void setParasiticsUseExemptedNetsFile(boolean b) {
        cacheParasiticsUseExemptedNetsFile.setBoolean(b);
    }

    public static boolean isFactoryParasiticsUseExemptedNetsFile() {
        return cacheParasiticsUseExemptedNetsFile.getBooleanFactoryValue();
    }

    public static boolean isParasiticsIgnoreExemptedNets() {
        return cacheParasiticsIgnoreExemptedNets.getBoolean();
    }

    public static void setParasiticsIgnoreExemptedNets(boolean b) {
        cacheParasiticsIgnoreExemptedNets.setBoolean(b);
    }

    public static boolean isFactoryParasiticsIgnoreExemptedNets() {
        return cacheParasiticsIgnoreExemptedNets.getBooleanFactoryValue();
    }

    public static boolean isParasiticsExtractsR() {
        return cacheParasiticsExtractsR.getBoolean();
    }

    public static void setParasiticsExtractsR(boolean b) {
        cacheParasiticsExtractsR.setBoolean(b);
    }

    public static boolean isFactoryParasiticsExtractsR() {
        return cacheParasiticsExtractsR.getBooleanFactoryValue();
    }

    public static boolean isParasiticsExtractsC() {
        return cacheParasiticsExtractsC.getBoolean();
    }

    public static void setParasiticsExtractsC(boolean b) {
        cacheParasiticsExtractsC.setBoolean(b);
    }

    public static boolean isFactoryParasiticsExtractsC() {
        return cacheParasiticsExtractsC.getBooleanFactoryValue();
    }

    public static SpiceGlobal getSpiceGlobalTreatment() {
        return SpiceGlobal.find(cacheGlobalTreatment.getInt());
    }

    public static void setSpiceGlobalTreatment(SpiceGlobal g) {
        cacheGlobalTreatment.setInt(g.getCode());
    }

    public static SpiceGlobal getFactorySpiceGlobalTreatment() {
        return SpiceGlobal.find(cacheGlobalTreatment.getIntFactoryValue());
    }

    public static boolean isSpiceWritePwrGndInTopCell() {
        return cacheSpiceWritePwrGndInTopCell.getBoolean();
    }

    public static void setSpiceWritePwrGndInTopCell(boolean g) {
        cacheSpiceWritePwrGndInTopCell.setBoolean(g);
    }

    public static boolean isFactorySpiceWritePwrGndInTopCell() {
        return cacheSpiceWritePwrGndInTopCell.getBooleanFactoryValue();
    }

    public static boolean isSpiceUseCellParameters() {
        return cacheSpiceUseCellParameters.getBoolean();
    }

    public static void setSpiceUseCellParameters(boolean p) {
        cacheSpiceUseCellParameters.setBoolean(p);
    }

    public static boolean isFactorySpiceUseCellParameters() {
        return cacheSpiceUseCellParameters.getBooleanFactoryValue();
    }

    public static boolean isSpiceWriteTransSizeInLambda() {
        return cacheSpiceWriteTransSizeInLambda.getBoolean();
    }

    public static void setSpiceWriteTransSizeInLambda(boolean l) {
        cacheSpiceWriteTransSizeInLambda.setBoolean(l);
    }

    public static boolean isFactorySpiceWriteTransSizeInLambda() {
        return cacheSpiceWriteTransSizeInLambda.getBooleanFactoryValue();
    }

    public static boolean isSpiceWriteSubcktTopCell() {
        return cacheSpiceWriteSubcktTopCell.getBoolean();
    }

    public static void setSpiceWriteSubcktTopCell(boolean b) {
        cacheSpiceWriteSubcktTopCell.setBoolean(b);
    }

    public static boolean isFactorySpiceWriteSubcktTopCell() {
        return cacheSpiceWriteSubcktTopCell.getBooleanFactoryValue();
    }

    public static boolean isSpiceWriteTopCellInstance() {
        return cacheSpiceWriteTopCellInstance.getBoolean();
    }

    public static void setSpiceWriteTopCellInstance(boolean b) {
        cacheSpiceWriteTopCellInstance.setBoolean(b);
    }

    public static boolean isSpiceWriteEmptySubckts() {
        return cacheSpiceWriteEmptySubckts.getBoolean();
    }

    public static void setSpiceWriteEmptySubckts(boolean b) {
        cacheSpiceWriteEmptySubckts.setBoolean(b);
    }

    public static boolean isFactorySpiceWriteEmptySubckts() {
        return cacheSpiceWriteEmptySubckts.getBooleanFactoryValue();
    }

    public static boolean isSpiceWriteFinalDotEnd() {
        return cacheSpiceWriteFinalDotEnd.getBoolean();
    }

    public static void setSpiceWriteFinalDotEnd(boolean b) {
        cacheSpiceWriteFinalDotEnd.setBoolean(b);
    }

    public static boolean isFactorySpiceWriteFinalDotEnd() {
        return cacheSpiceWriteFinalDotEnd.getBooleanFactoryValue();
    }

    public static boolean isSpiceIgnoreModelFiles() {
        return cachedSpiceIgnoreModelFiles.getBoolean();
    }

    public static void setSpiceIgnoreModelFiles(boolean b) {
        cachedSpiceIgnoreModelFiles.setBoolean(b);
    }

    public static boolean isFactorySpiceIgnoreModelFiles() {
        return cachedSpiceIgnoreModelFiles.getBooleanFactoryValue();
    }

    public static String getSpiceExtractedNetDelimiter() {
        return cacheSpiceExtractedNetDelimiter.getString();
    }

    public static void setSpiceExtractedNetDelimiter(String s2) {
        cacheSpiceExtractedNetDelimiter.setString(s2);
    }

    public static String getFactorySpiceExtractedNetDelimiter() {
        return cacheSpiceExtractedNetDelimiter.getStringFactoryValue();
    }

    public static boolean isSpiceInputPlaces() {
        return cacheSpiceInputPlaces.getBoolean();
    }

    public static void setSpiceInputPlaces(boolean b) {
        cacheSpiceInputPlaces.setBoolean(b);
    }

    public static boolean isFactorySpiceInputPlaces() {
        return cacheSpiceInputPlaces.getBooleanFactoryValue();
    }

    public static boolean isCDLLashOn() {
        return cacheCDLLash.getBoolean();
    }

    public static void setCDLLashOn(boolean b) {
        cacheCDLLash.setBoolean(b);
    }

    public static boolean isFactoryCDLLashOn() {
        return cacheCDLLash.getBooleanFactoryValue();
    }

    public static final class SpiceGlobal
    extends Enum<SpiceGlobal> {
        public static final /* enum */ SpiceGlobal NONE = new SpiceGlobal(0);
        public static final /* enum */ SpiceGlobal USEGLOBALBLOCK = new SpiceGlobal(1);
        public static final /* enum */ SpiceGlobal USESUBCKTPORTS = new SpiceGlobal(2);
        private int code;
        private static final /* synthetic */ SpiceGlobal[] $VALUES;

        public static SpiceGlobal[] values() {
            return (SpiceGlobal[])$VALUES.clone();
        }

        public static SpiceGlobal valueOf(String name) {
            return Enum.valueOf(SpiceGlobal.class, name);
        }

        private SpiceGlobal(int c) {
            this.code = c;
        }

        public int getCode() {
            return this.code;
        }

        public static SpiceGlobal find(int c) {
            for (SpiceGlobal s2 : SpiceGlobal.values()) {
                if (s2.code != c) continue;
                return s2;
            }
            assert (false);
            return null;
        }

        static {
            $VALUES = new SpiceGlobal[]{NONE, USEGLOBALBLOCK, USESUBCKTPORTS};
        }
    }

    public static enum SpiceParasitics {
        SIMPLE(0, "Trans area/perim only"),
        RC_CONSERVATIVE(1, "Conservative RC"),
        RC_PROXIMITY(2, "Proximity-based RC");

        private int code;
        private String name;

        private SpiceParasitics(int val, String name) {
            this.code = val;
            this.name = name;
        }

        public int code() {
            return this.code;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum SpiceEngine {
        SPICE_ENGINE_2(0, "Spice 2"),
        SPICE_ENGINE_3(1, "Spice 3"),
        SPICE_ENGINE_H(2, "HSpice"),
        SPICE_ENGINE_P(3, "PSpice"),
        SPICE_ENGINE_G(4, "Gnucap"),
        SPICE_ENGINE_S(5, "SmartSpice"),
        SPICE_ENGINE_H_ASSURA(6, "HSpice for Assura"),
        SPICE_ENGINE_H_CALIBRE(7, "HSpice for Calibre"),
        SPICE_ENGINE_XYCE(8, "Xyce"),
        SPICE_ENGINE_O(9, "Spice Opus");

        private int code;
        private String name;

        private SpiceEngine(int val, String name) {
            this.code = val;
            this.name = name;
        }

        public int code() {
            return this.code;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class ClockSpec
    extends EDialog {
        private double period = -1.0;
        private JRadioButton freqBut;
        private JRadioButton periodBut;
        private JTextField freqField;
        private JTextField periodField;

        public static double getClockSpec() {
            ClockSpec dialog = new ClockSpec((Frame)TopLevel.getCurrentJFrame(), true);
            dialog.setVisible(true);
            return dialog.period;
        }

        public ClockSpec(Frame parent, boolean modal) {
            super(parent, modal);
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Clock Specification");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    ClockSpec.this.closeDialog(evt);
                }
            });
            ButtonGroup fp = new ButtonGroup();
            this.freqBut = new JRadioButton("Frequency:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            this.getContentPane().add((Component)this.freqBut, gbc);
            fp.add(this.freqBut);
            this.freqField = new JTextField();
            this.freqField.setColumns(12);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.freqField, gbc);
            this.periodBut = new JRadioButton("Period:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            this.getContentPane().add((Component)this.periodBut, gbc);
            fp.add(this.periodBut);
            this.periodBut.setSelected(true);
            this.periodField = new JTextField();
            this.periodField.setColumns(12);
            this.periodField.setText("0.00000001");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.periodField, gbc);
            JButton cancel = new JButton("Cancel");
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ClockSpec.this.cancel(evt);
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            JButton ok = new JButton("OK");
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ClockSpec.this.ok(evt);
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            this.pack();
            this.getRootPane().setDefaultButton(ok);
            this.finishInitialization();
        }

        @Override
        protected void escapePressed() {
            this.cancel(null);
        }

        private void cancel(ActionEvent evt) {
            this.closeDialog(null);
        }

        private void ok(ActionEvent evt) {
            if (this.freqBut.isSelected()) {
                double freq = TextUtils.atof(this.freqField.getText());
                if (freq != 0.0) {
                    this.period = 1.0 / freq;
                }
            } else {
                this.period = TextUtils.atof(this.periodField.getText());
            }
            this.closeDialog(null);
        }

        private void closeDialog(WindowEvent evt) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private static class SetTransistorStrength
    extends Job {
        private NodeInst ni;
        private boolean weak;

        protected SetTransistorStrength(NodeInst ni, boolean weak) {
            super("Change Transistor Strength", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.weak = weak;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (this.weak) {
                this.ni.newDisplayVar(WEAK_NODE_KEY, "Weak", ep);
            } else if (this.ni.getVar(WEAK_NODE_KEY) != null) {
                this.ni.delVar(WEAK_NODE_KEY);
            }
            return true;
        }
    }

    private static class SetWireType
    extends Job {
        private List<Geometric> list;
        private int type;

        protected SetWireType(List<Geometric> list, int type) {
            super("Change Verilog Wire Types", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.list = list;
            this.type = type;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            for (Geometric geom : this.list) {
                ArcInst ai = (ArcInst)geom;
                switch (this.type) {
                    case 0: {
                        ai.newDisplayVar(Verilog.WIRE_TYPE_KEY, "wire", ep);
                        break;
                    }
                    case 1: {
                        ai.newDisplayVar(Verilog.WIRE_TYPE_KEY, "trireg", ep);
                        break;
                    }
                    case 2: {
                        if (ai.getVar(Verilog.WIRE_TYPE_KEY) == null) break;
                        ai.delVar(Verilog.WIRE_TYPE_KEY);
                    }
                }
            }
            return true;
        }
    }

    private static class SetSpiceModel
    extends Job {
        private NodeInst ni;

        protected SetSpiceModel(NodeInst ni) {
            super("Set Spice Model", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.ni.newDisplayVar(Spice.SPICE_MODEL_KEY, "SPICE-Model", this.getEditingPreferences());
            return true;
        }
    }

    private static class RunIRSIM
    extends Thread {
        private Cell cell;
        private VarContext context;
        private String fileName;
        private IRSIM.IRSIMPreferences ip;
        private final Environment launcherEnvironment;
        private final UserInterfaceExec userInterface;

        public RunIRSIM(Cell cell, VarContext context, String fileName, boolean doNow) {
            this.cell = cell;
            this.context = context;
            this.fileName = fileName;
            this.ip = new IRSIM.IRSIMPreferences(true);
            this.launcherEnvironment = Environment.getThreadEnvironment();
            this.userInterface = new UserInterfaceExec();
            if (fileName != null && !doNow) {
                this.start();
            } else {
                IRSIM.runIRSIM(cell, context, fileName, this.ip, doNow);
            }
        }

        @Override
        public void run() {
            if (Thread.currentThread() == this) {
                Environment.setThreadEnvironment(this.launcherEnvironment);
                Job.setUserInterface(this.userInterface);
            }
            IRSIM.runIRSIM(this.cell, this.context, this.fileName, this.ip, false);
        }
    }
}

