/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.model;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.grammar.IStateStack;
import org.eclipse.tm4e.core.internal.grammar.StateStack;
import org.eclipse.tm4e.core.internal.utils.MoreCollections;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.core.internal.utils.StringUtils;
import org.eclipse.tm4e.core.model.ITMModel;
import org.eclipse.tm4e.core.model.ModelTokensChangedEvent;
import org.eclipse.tm4e.core.model.Range;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.core.model.TMTokenizationSupport;
import org.eclipse.tm4e.core.model.TokenizationResult;

public abstract class TMModel
implements ITMModel {
    private static final System.Logger LOGGER = System.getLogger(TMModel.class.getName());
    private @Nullable IGrammar grammar;
    private final ModelTokensChangedEvent.Listeners listeners = new ModelTokensChangedEvent.Listeners();
    private volatile @Nullable TokenizerThread tokenizerThread;
    private volatile boolean tokenizerThreadHasWork;
    private TMTokenizationSupport tokenizer = (TMTokenizationSupport)NullSafetyHelper.lazyNonNull();
    final ArrayList<LineTokens> lines;
    final Object linesWriteLock;
    private final BlockingQueue<Edit> edits = new LinkedBlockingQueue<Edit>();
    private static final boolean DEBUG_LOGGING = LOGGER.isLoggable(System.Logger.Level.DEBUG);

    protected TMModel(int initialNumberOfLines) {
        this.linesWriteLock = this.lines = new ArrayList(Math.max(10, initialNumberOfLines));
        this.onLinesReplaced(0, 0, initialNumberOfLines);
    }

    private void logDebug(String msg, Object ... args) {
        if (!DEBUG_LOGGING) {
            return;
        }
        Thread t = Thread.currentThread();
        StackTraceElement caller = t.getStackTrace()[2];
        String threadName = t.getName().endsWith(TokenizerThread.class.getSimpleName()) ? "tknz" : t.getName();
        LOGGER.log(System.Logger.Level.DEBUG, "[" + threadName + "] " + caller.getMethodName() + String.format(msg, args));
    }

    private @Nullable LineTokens getLineTokensOrNull(int index) {
        return index > -1 && index < this.lines.size() ? this.lines.get(index) : null;
    }

    @Override
    public ITMModel.BackgroundTokenizationState getBackgroundTokenizationState() {
        return this.tokenizerThreadHasWork ? ITMModel.BackgroundTokenizationState.IN_PROGRESS : ITMModel.BackgroundTokenizationState.COMPLETED;
    }

    @Override
    public @Nullable IGrammar getGrammar() {
        return this.grammar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setGrammar(IGrammar grammar) {
        if (!Objects.equals(grammar, this.grammar)) {
            this.grammar = grammar;
            TMTokenizationSupport tokenizer = this.tokenizer = new TMTokenizationSupport(grammar);
            Object object = this.linesWriteLock;
            synchronized (object) {
                if (!this.lines.isEmpty()) {
                    this.lines.get((int)0).startState = tokenizer.getInitialState();
                }
                this.onLinesReplaced(0, 1, 1);
            }
            this.startTokenizerThread();
        }
    }

    public void onLinesReplaced(int lineIndex, int replacedLinesCount, int replacementLinesCount) {
        if (replacedLinesCount == 0 && replacementLinesCount == 0) {
            return;
        }
        if (DEBUG_LOGGING) {
            this.logDebug("(%d, -%d, +%d)", lineIndex + 1, replacedLinesCount, replacementLinesCount);
        }
        this.edits.add(new Edit(lineIndex, replacedLinesCount, replacementLinesCount));
    }

    @Override
    public synchronized boolean addModelTokensChangedListener(ModelTokensChangedEvent.Listener listener) {
        if (this.listeners.add(listener)) {
            this.startTokenizerThread();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeModelTokensChangedListener(ModelTokensChangedEvent.Listener listener) {
        if (this.listeners.remove(listener)) {
            if (this.listeners.isEmpty()) {
                this.stopTokenizerThread();
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        this.stopTokenizerThread();
    }

    private synchronized void startTokenizerThread() {
        TokenizerThread thread;
        if (this.grammar != null && this.listeners.isNotEmpty() && ((thread = this.tokenizerThread) == null || !thread.isAlive() || thread.isInterrupted())) {
            thread = this.tokenizerThread = new TokenizerThread();
            thread.start();
        }
    }

    private synchronized void stopTokenizerThread() {
        TokenizerThread thread = this.tokenizerThread;
        if (thread == null) {
            return;
        }
        thread.interrupt();
        this.tokenizerThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfLines() {
        Object object = this.linesWriteLock;
        synchronized (object) {
            return this.lines.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable List<TMToken> getLineTokens(int lineIndex) {
        Object object = this.linesWriteLock;
        synchronized (object) {
            LineTokens lineTokens = this.getLineTokensOrNull(lineIndex);
            return lineTokens == null ? null : lineTokens.tokens;
        }
    }

    public String toString() {
        return StringUtils.toString(this, sb -> {
            sb.append("grammar=").append(this.grammar);
            Object object = this.linesWriteLock;
            synchronized (object) {
                sb.append(", lines=").append(MoreCollections.toStringWithIndex(this.lines));
            }
        });
    }

    private static final class Edit {
        final int lineIndex;
        final int replacedCount;
        final int replacementCount;

        public Edit(int lineIndex, int replacedCount, int replacementCount) {
            this.lineIndex = lineIndex;
            this.replacedCount = replacedCount;
            this.replacementCount = replacementCount;
        }

        public String toString() {
            return "{lineNumber=" + (this.lineIndex + 1) + ", replacedCount=" + this.replacedCount + ", replacementCount=" + this.replacementCount + '}';
        }
    }

    static final class LineTokens {
        volatile IStateStack startState = StateStack.NULL;
        @Nullable IStateStack endState;
        volatile @Nullable List<TMToken> tokens;

        LineTokens() {
        }

        void reset() {
            this.startState = StateStack.NULL;
            this.endState = null;
            this.tokens = null;
        }

        public String toString() {
            return "{startState=" + this.startState + ", tokens=" + this.tokens + '}';
        }
    }

    private final class TokenizerThread
    extends Thread {
        private static final Duration MAX_TIME_PER_LINE_TOKENIZATION = Duration.ofSeconds(1L);
        private static final int MAX_TIME_PER_MULTI_LINE_VALIDATIONS = 200;
        private int firstLineToRevalidate;

        TokenizerThread() {
            super("tm4e." + TokenizerThread.class.getSimpleName());
            this.firstLineToRevalidate = -1;
            this.setPriority(1);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                try {
                    while (TMModel.this.tokenizerThread == this) {
                        boolean bl = TMModel.this.tokenizerThreadHasWork = !this.isAllTokensAreValid() || !TMModel.this.edits.isEmpty();
                        if (!TMModel.this.tokenizerThreadHasWork || !TMModel.this.edits.isEmpty()) {
                            Edit edit;
                            this.applyEdit(TMModel.this.edits.take());
                            while ((edit = NullSafetyHelper.castNullable(TMModel.this.edits.poll(50L, TimeUnit.MILLISECONDS))) != null) {
                                this.applyEdit(edit);
                            }
                        }
                        this.revalidateTokens();
                    }
                }
                catch (InterruptedException ex) {
                    this.interrupt();
                    TMModel.this.tokenizerThreadHasWork = false;
                }
            }
            finally {
                TMModel.this.tokenizerThreadHasWork = false;
            }
        }

        private boolean isAllTokensAreValid() {
            return this.firstLineToRevalidate == -1;
        }

        private void setAllTokensAreValid() {
            this.firstLineToRevalidate = -1;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private void revalidateTokens() throws InterruptedException {
            startLineIndex = this.firstLineToRevalidate;
            startLineNumber = startLineIndex + 1;
            if (TMModel.DEBUG_LOGGING) {
                TMModel.this.logDebug("(%d)", new Object[]{startLineNumber});
            }
            startTime = System.currentTimeMillis();
            changedRanges /* !! */  = new ArrayList<Range>();
            prevRange = null;
            prevLineTokens = TMModel.this.getLineTokensOrNull(startLineIndex - 1);
            linesCount = TMModel.this.lines.size();
            currLineIndex = -1;
            currLineIndex = startLineIndex;
            while (currLineIndex < linesCount) {
                if (this.isInterrupted() || !TMModel.this.edits.isEmpty()) break;
                currLineTokens = TMModel.this.lines.get(currLineIndex);
                if (currLineIndex == 0) {
                    currLineTokens.startState = TMModel.this.tokenizer.getInitialState();
                }
                currLineNumber = currLineIndex + 1;
                if (prevLineTokens == null) ** GOTO lbl27
                if (currLineTokens.tokens != null && currLineTokens.startState.equals(prevLineTokens.endState)) {
                    if (TMModel.DEBUG_LOGGING) {
                        TMModel.this.logDebug("(%d) >> DONE - tokens of line %d are up-to-date", new Object[]{startLineNumber, currLineNumber});
                    }
                    this.firstLineToRevalidate = currLineIndex + 1;
                    prevLineTokens = currLineTokens;
                } else {
                    if (prevLineTokens.endState != null) {
                        currLineTokens.startState = prevLineTokens.endState;
                    }
lbl27:
                    // 4 sources

                    if (TMModel.DEBUG_LOGGING) {
                        TMModel.this.logDebug("(%d) >> tokenizing line %d...", new Object[]{startLineNumber, currLineNumber});
                    }
                    try {
                        lineText = TMModel.this.getLineText(currLineIndex);
                        r = TMModel.this.tokenizer.tokenize(lineText, currLineTokens.startState, 0, TokenizerThread.MAX_TIME_PER_LINE_TOKENIZATION);
                    }
                    catch (Exception ex) {
                        TMModel.LOGGER.log(System.Logger.Level.ERROR, ex.toString());
                        r = new TokenizationResult(new ArrayList<TMToken>(1), 0, currLineTokens.startState, true);
                    }
                    if (r.stoppedEarly) {
                        r.tokens.add(new TMToken(r.actualStopOffset, ""));
                        r.endState = currLineTokens.startState;
                    }
                    currLineTokens.endState = r.endState;
                    currLineTokens.tokens = r.tokens;
                    prevLineTokens = currLineTokens;
                    this.firstLineToRevalidate = currLineIndex + 1;
                    if (prevRange != null && prevRange.toLineNumber == currLineNumber - 1) {
                        prevRange.toLineNumber = currLineNumber;
                    } else {
                        prevRange = new Range(currLineNumber);
                        changedRanges /* !! */ .add(prevRange);
                    }
                    if (System.currentTimeMillis() - startTime >= 200L) {
                        if (TMModel.DEBUG_LOGGING) {
                            TMModel.this.logDebug("(%d) >> changedRanges: %s", new Object[]{startLineNumber, changedRanges /* !! */ });
                        }
                        TMModel.this.listeners.dispatchEvent((List<Range>)changedRanges /* !! */ , TMModel.this);
                        changedRanges /* !! */  = new ArrayList<E>();
                        prevRange = null;
                        startTime = System.currentTimeMillis();
                    }
                }
                ++currLineIndex;
            }
            if (TMModel.DEBUG_LOGGING) {
                TMModel.this.logDebug("(%d) >> changedRanges: %s", new Object[]{startLineNumber, changedRanges /* !! */ });
            }
            TMModel.this.listeners.dispatchEvent((List<Range>)changedRanges /* !! */ , TMModel.this);
            this.setAllTokensAreValid();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyEdit(Edit edit) {
            if (DEBUG_LOGGING) {
                TMModel.this.logDebug("(%s)", edit);
            }
            int lineIndex = edit.lineIndex;
            if (this.isAllTokensAreValid() || lineIndex < this.firstLineToRevalidate) {
                this.firstLineToRevalidate = lineIndex;
            }
            if (edit.replacedCount == 1 && edit.replacementCount == 1) {
                LineTokens firstLineOfEdit = TMModel.this.getLineTokensOrNull(lineIndex);
                if (firstLineOfEdit == null) {
                    return;
                }
                firstLineOfEdit.reset();
                return;
            }
            int replacedCount = Math.min(edit.replacedCount, TMModel.this.lines.size() - lineIndex);
            int lineDiff = edit.replacementCount - edit.replacedCount;
            List<LineTokens> editRange = TMModel.this.lines.subList(lineIndex, lineIndex + replacedCount);
            if (lineDiff == 0) {
                editRange.forEach(LineTokens::reset);
                return;
            }
            if (lineDiff > 0) {
                editRange.forEach(LineTokens::reset);
                ArrayList<LineTokens> additionalLines = new ArrayList<LineTokens>(lineDiff);
                int i = 0;
                while (i < lineDiff) {
                    additionalLines.add(new LineTokens());
                    ++i;
                }
                Object object = TMModel.this.linesWriteLock;
                synchronized (object) {
                    editRange.addAll(additionalLines);
                }
                return;
            }
            Object object = TMModel.this.linesWriteLock;
            synchronized (object) {
                editRange.subList(0, -lineDiff).clear();
            }
            editRange.forEach(LineTokens::reset);
        }
    }
}

