/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.subsystems.SubSystemConfigurationProxyAdapter;
import org.eclipse.rse.internal.ui.view.SystemInheritablePropertyData;
import org.eclipse.rse.internal.ui.view.SystemInheritableTextPropertyDescriptor;
import org.eclipse.rse.internal.ui.view.SystemViewResources;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorPortInput;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class SystemViewSubSystemAdapter
extends AbstractSystemViewAdapter {
    protected String translatedType;
    private String original_portData;
    private SystemInheritablePropertyData original_userIdData = new SystemInheritablePropertyData();
    private TextPropertyDescriptor propertyPortDescriptor;
    private boolean changed_userId;
    private boolean changed_port;
    private boolean port_editable = true;
    private PropertyDescriptor[] propertyDescriptorArray = null;
    private SystemInheritablePropertyData userIdData = new SystemInheritablePropertyData();
    private SystemInheritableTextPropertyDescriptor userIdDescriptor = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        if (selection.size() == 1) {
            IAction[] actions;
            ISubSystemConfigurationAdapter adapter;
            Object element = selection.getFirstElement();
            ISubSystem ss = (ISubSystem)element;
            ISubSystemConfiguration ssFactory = ss.getSubSystemConfiguration();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ISubSystemConfigurationAdapter)ssFactory.getAdapter((Class)clazz)) == null) {
                IAdapterManager iAdapterManager = Platform.getAdapterManager();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iAdapterManager.loadAdapter((Object)ssFactory, clazz2.getName());
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                adapter = (ISubSystemConfigurationAdapter)ssFactory.getAdapter((Class)clazz3);
            }
            if (adapter != null && (actions = adapter.getSubSystemActions(menu, selection, shell, menuGroup, ssFactory, ss)) != null) {
                int idx = 0;
                while (idx < actions.length) {
                    IAction action = actions[idx];
                    menu.add(menuGroup, action);
                    ++idx;
                }
            }
        }
        menu.appendToGroup("group.new", (IContributionItem)new GroupMarker("group.new.noncascade"));
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        ISubSystem ss = (ISubSystem)element;
        ISubSystemConfiguration ssFactory = ss.getSubSystemConfiguration();
        if (ssFactory != null) {
            SubSystemConfigurationProxyAdapter proxyAdapter;
            ISubSystemConfigurationAdapter adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ISubSystemConfigurationAdapter)ssFactory.getAdapter((Class)clazz)) != null) {
                if (ss.isConnected()) {
                    return adapter.getLiveImage(ssFactory);
                }
                return adapter.getImage(ssFactory);
            }
            ISubSystemConfigurationProxy proxy = ssFactory.getSubSystemConfigurationProxy();
            IAdapterManager iAdapterManager = Platform.getAdapterManager();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.rse.internal.ui.subsystems.SubSystemConfigurationProxyAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((proxyAdapter = (SubSystemConfigurationProxyAdapter)iAdapterManager.getAdapter((Object)proxy, (Class)clazz2)) != null) {
                if (ss.isConnected()) {
                    return proxyAdapter.getLiveImageDescriptor();
                }
                return proxyAdapter.getImageDescriptor();
            }
            SystemBasePlugin.logWarning("Unexpected error: SubSystemConfiguration has no adapter and no proxyAdapter: " + ss.getName());
            return null;
        }
        SystemBasePlugin.logWarning("Unexpected error: SubSystemConfiguration is null for ss " + ss.getName());
        return null;
    }

    public String getText(Object element) {
        return ((ISubSystem)element).getName();
    }

    public String getName(Object element) {
        return ((ISubSystem)element).getName();
    }

    public String getAbsoluteName(Object element) {
        ISubSystem ss = (ISubSystem)element;
        String suffix = ss.getName();
        Class serviceType = ss.getServiceType();
        if (serviceType != null) {
            suffix = serviceType.toString();
        }
        return String.valueOf(ss.getSystemProfileName()) + "." + ss.getHostAliasName() + "." + suffix;
    }

    public String getType(Object element) {
        if (this.translatedType == null) {
            this.translatedType = SystemViewResources.RESID_PROPERTY_SUBSYSTEM_TYPE_VALUE;
        }
        return this.translatedType;
    }

    public Object getParent(Object element) {
        ISubSystem ss = (ISubSystem)element;
        return RSECorePlugin.getTheSystemRegistry().getHost(ss.getSystemProfile(), ss.getHostAliasName());
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        ISubSystem ss = (ISubSystem)element;
        Object[] children = ss.getChildren();
        return children;
    }

    public boolean hasChildren(IAdaptable element) {
        ISubSystem ss = (ISubSystem)element;
        return ss.hasChildren();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptorArray == null) {
            PropertyDescriptor[] defaultProperties = (PropertyDescriptor[])SystemViewSubSystemAdapter.getDefaultDescriptors();
            this.propertyDescriptorArray = new PropertyDescriptor[defaultProperties.length + 4];
            int idx = 0;
            idx = 0;
            while (idx < defaultProperties.length) {
                this.propertyDescriptorArray[idx] = defaultProperties[idx];
                ++idx;
            }
            this.userIdDescriptor = new SystemInheritableTextPropertyDescriptor("org.eclipse.rse.ui.userid", SystemViewResources.RESID_PROPERTY_USERID_LABEL);
            this.userIdDescriptor.setToggleButtonToolTipText(SystemResources.RESID_SUBSYSTEM_USERID_INHERITBUTTON_TIP);
            this.userIdDescriptor.setEntryFieldToolTipText(SystemResources.RESID_SUBSYSTEM_USERID_TIP);
            this.propertyDescriptorArray[idx] = this.userIdDescriptor;
            this.propertyDescriptorArray[idx].setDescription(SystemViewResources.RESID_PROPERTY_USERID_TOOLTIP);
            this.propertyPortDescriptor = new TextPropertyDescriptor((Object)"org.eclipse.rse.ui.port", SystemViewResources.RESID_PROPERTY_PORT_LABEL);
            this.propertyPortDescriptor.setDescription(SystemViewResources.RESID_PROPERTY_PORT_TOOLTIP);
            this.propertyPortDescriptor.setValidator((ICellEditorValidator)new ValidatorPortInput());
            this.propertyDescriptorArray[++idx] = this.propertyPortDescriptor;
            this.propertyDescriptorArray[++idx] = SystemViewSubSystemAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.connected", SystemViewResources.RESID_PROPERTY_CONNECTED_LABEL, SystemViewResources.RESID_PROPERTY_CONNECTED_TOOLTIP);
            this.propertyDescriptorArray[++idx] = SystemViewSubSystemAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.vrm", SystemViewResources.RESID_PROPERTY_VRM_LABEL, SystemViewResources.RESID_PROPERTY_VRM_TOOLTIP);
        }
        return this.propertyDescriptorArray;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        return null;
    }

    private SystemInheritablePropertyData setUserIdPropertyData(SystemInheritablePropertyData data, ISubSystem subsys) {
        String localUserId = subsys.getLocalUserId();
        data.setLocalValue(localUserId);
        String parentUserId = subsys.getHost().getDefaultUserId();
        data.setInheritedValue(parentUserId);
        data.setIsLocal(localUserId != null && localUserId.length() > 0);
        if (subsys.isConnected()) {
            String connectedId = subsys.getConnectorService().getUserId();
            if (data.getIsLocal() && connectedId != null && !connectedId.equals(localUserId)) {
                data.setLocalValue(connectedId);
                data.setIsLocal(true);
            } else if (connectedId != null && !connectedId.equals(parentUserId)) {
                data.setLocalValue(connectedId);
                data.setIsLocal(true);
            }
        }
        return data;
    }

    private String getPortString(ISubSystem ss) {
        boolean notApplicable;
        int iPort = ss.getConnectorService().getPort();
        ISubSystemConfiguration ssFactory = ss.getSubSystemConfiguration();
        boolean bl = notApplicable = !ssFactory.isPortEditable() && iPort <= 0;
        if (notApplicable) {
            return this.getTranslatedNotApplicable();
        }
        return Integer.toString(iPort);
    }

    public Object getPropertyValue(Object property) {
        String name = (String)property;
        ISubSystem ss = (ISubSystem)this.propertySourceInput;
        if (name.equals("org.eclipse.rse.ui.userid")) {
            return this.setUserIdPropertyData(this.userIdData, ss);
        }
        if (name.equals("org.eclipse.rse.ui.port")) {
            return this.getPortString(ss);
        }
        if (name.equals("org.eclipse.rse.ui.vrm")) {
            IConnectorService system = ss.getConnectorService();
            if (system != null) {
                String vrm = system.getVersionReleaseModification();
                if (vrm != null) {
                    return vrm;
                }
                return this.getTranslatedNotAvailable();
            }
            return this.getTranslatedNotAvailable();
        }
        if (name.equals("org.eclipse.rse.ui.connected")) {
            if (ss.getHost().isOffline()) {
                return SystemResources.RESID_OFFLINE_LABEL;
            }
            IConnectorService system = ss.getConnectorService();
            boolean connected = false;
            if (system == null) {
                System.out.println("SystemViewSubSystemAdapter: Error! system is null for subsystem " + ss.getClass().getName());
                SystemBasePlugin.logError("SystemViewSubSystemAdapter: Error! system is null for subsystem " + ss.getClass().getName(), null);
            } else {
                connected = system.isConnected();
            }
            return connected ? this.getTranslatedYes() : this.getTranslatedNo();
        }
        return super.getPropertyValue(name);
    }

    public ISubSystem getSubSystem(Object element) {
        if (element instanceof ISubSystem) {
            return (ISubSystem)element;
        }
        return null;
    }

    public Object internalGetPropertyValue(Object key) {
        return null;
    }

    public void setPropertySourceInput(Object propertySourceInput) {
        ISubSystemConfigurationAdapter adapter;
        if (this.propertySourceInput == propertySourceInput) {
            return;
        }
        super.setPropertySourceInput(propertySourceInput);
        ISubSystem ss = (ISubSystem)propertySourceInput;
        ISubSystemConfiguration ssFactory = ss.getSubSystemConfiguration();
        this.original_userIdData = this.setUserIdPropertyData(this.original_userIdData, ss);
        this.original_portData = this.getPortString(ss);
        this.changed_port = false;
        this.changed_userId = false;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISubSystemConfigurationAdapter)ssFactory.getAdapter((Class)clazz)) != null) {
            if (this.userIdDescriptor != null) {
                this.userIdDescriptor.setValidator(adapter.getUserIdValidator(ssFactory));
            }
            if (this.propertyPortDescriptor != null) {
                this.propertyPortDescriptor.setValidator((ICellEditorValidator)adapter.getPortValidator(ssFactory));
            }
        }
        ss.getConnectorService().getPort();
        this.port_editable = ssFactory.isPortEditable();
    }

    public boolean isPropertySet(Object propertyObject) {
        String property = (String)propertyObject;
        boolean changed = false;
        if (property.equals("org.eclipse.rse.ui.userid")) {
            changed = this.changed_userId;
        } else if (property.equals("org.eclipse.rse.ui.port")) {
            changed = this.changed_port && this.port_editable;
        }
        return changed;
    }

    private void updateUserId(ISubSystem subsys, SystemInheritablePropertyData data) {
        String userId = data.getLocalValue();
        ISubSystemConfiguration ssFactory = subsys.getSubSystemConfiguration();
        ssFactory.updateSubSystem(subsys, true, userId, false, subsys.getConnectorService().getPort());
    }

    private void updatePort(ISubSystem subsys, String data) {
        if (!this.port_editable) {
            return;
        }
        String port = data;
        Integer portInteger = null;
        if (port.length() > 0) {
            try {
                portInteger = new Integer(port);
            }
            catch (Exception exc) {
                return;
            }
        } else {
            portInteger = new Integer(0);
        }
        int portInt = portInteger;
        ISubSystemConfiguration ssFactory = subsys.getSubSystemConfiguration();
        ssFactory.updateSubSystem(subsys, false, subsys.getLocalUserId(), true, portInt);
        subsys.commit();
    }

    public void resetPropertyValue(Object propertyObject) {
        String property = (String)propertyObject;
        ISubSystem ss = (ISubSystem)this.propertySourceInput;
        ss.getSubSystemConfiguration();
        if (property.equals("org.eclipse.rse.ui.userid")) {
            this.updateUserId(ss, this.original_userIdData);
            this.changed_userId = false;
        } else if (property.equals("org.eclipse.rse.ui.port")) {
            this.updatePort(ss, this.original_portData);
            this.changed_port = false;
        }
    }

    public void setPropertyValue(Object property, Object value) {
        String name = (String)property;
        ISubSystem ss = (ISubSystem)this.propertySourceInput;
        ss.getSubSystemConfiguration();
        if (name.equals("org.eclipse.rse.ui.userid")) {
            this.updateUserId(ss, (SystemInheritablePropertyData)value);
            this.changed_userId = true;
        } else if (name.equals("org.eclipse.rse.ui.port")) {
            this.updatePort(ss, (String)value);
            this.changed_port = true;
        }
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof ISubSystem) {
            if (name.equalsIgnoreCase("serverLaunchPP")) {
                ISubSystem ss = (ISubSystem)target;
                boolean supports = ss.getSubSystemConfiguration().supportsServerLaunchProperties(ss.getHost());
                return supports ? value.equals("true") : value.equals("false");
            }
            if (name.equalsIgnoreCase("envVarPP")) {
                boolean supports = false;
                return supports ? value.equals("true") : value.equals("false");
            }
            if (name.equalsIgnoreCase("isConnectionError")) {
                ISubSystem ss = (ISubSystem)target;
                boolean error = ss.isConnectionError();
                return error ? value.equals("true") : value.equals("false");
            }
        }
        return super.testAttribute(target, name, value);
    }

    public boolean showDelete(Object element) {
        return this.canDelete(element);
    }

    public boolean canDelete(Object element) {
        ISubSystem ss = (ISubSystem)element;
        ISubSystemConfiguration ssFactory = ss.getSubSystemConfiguration();
        return ssFactory.isSubSystemsDeletable();
    }

    public boolean doDelete(Shell shell, Object element, IProgressMonitor monitor) {
        ISubSystem ss = (ISubSystem)element;
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.deleteSubSystem(ss);
        return true;
    }

    public boolean showRename(Object element) {
        return this.canRename(element);
    }

    public boolean canRename(Object element) {
        return this.canDelete(element);
    }

    public boolean doRename(Shell shell, Object element, String name, IProgressMonitor monitor) {
        ISubSystem ss = (ISubSystem)element;
        ISubSystemConfiguration parentSSFactory = ss.getSubSystemConfiguration();
        parentSSFactory.renameSubSystem(ss, name);
        return true;
    }

    public ISystemValidator getNameValidator(Object element) {
        return null;
    }

    public boolean canDrag(Object element) {
        return true;
    }

    public Object doDrag(Object element, boolean sameSystemType, IProgressMonitor monitor) {
        return element;
    }

    public String getMementoHandle(Object element) {
        ISubSystem ss = (ISubSystem)element;
        ISubSystemConfiguration ssf = ss.getSubSystemConfiguration();
        return String.valueOf(ssf.getId()) + "=" + ss.getName();
    }

    public String getInputMementoHandle(Object element) {
        Object parent = this.getParent(element);
        return String.valueOf(SystemAdapterHelpers.getViewAdapter(parent, this.getViewer()).getInputMementoHandle(parent)) + "///" + this.getMementoHandle(element);
    }

    public String getMementoHandleKey(Object element) {
        return "Subs";
    }

    public boolean isRemote(Object element) {
        return false;
    }
}

