/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.connectorservice.dstore.util;

import java.util.HashMap;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.rse.connectorservice.dstore.util.ICommunicationsDiagnosticFactory;
import org.eclipse.rse.connectorservice.dstore.util.StatusMonitor;
import org.eclipse.rse.core.subsystems.IConnectorService;

public class StatusMonitorFactory {
    protected HashMap _monitorMap = new HashMap();
    protected static StatusMonitorFactory _instance;

    public static StatusMonitorFactory getInstance() {
        if (_instance == null) {
            _instance = new StatusMonitorFactory();
        }
        return _instance;
    }

    public void removeStatusMonitorFor(IConnectorService system) {
        StatusMonitor monitor = (StatusMonitor)this._monitorMap.remove(system);
        if (monitor != null) {
            monitor.dispose();
        }
    }

    public StatusMonitor getStatusMonitorFor(IConnectorService system, DataStore dataStore) {
        return this.getStatusMonitorFor(system, dataStore, null);
    }

    public StatusMonitor getStatusMonitorFor(IConnectorService system, DataStore dataStore, ICommunicationsDiagnosticFactory diagnosticFactory) {
        DataStore mDataStore;
        StatusMonitor monitor = (StatusMonitor)this._monitorMap.get(system);
        if (monitor == null) {
            monitor = new StatusMonitor(system, dataStore, diagnosticFactory);
            this._monitorMap.put(system, monitor);
        }
        if ((mDataStore = monitor.getDataStore()) != dataStore) {
            this.removeStatusMonitorFor(system);
            monitor = new StatusMonitor(system, dataStore, diagnosticFactory);
            this._monitorMap.put(system, monitor);
        }
        return monitor;
    }
}

