/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.InputStream;
import org.eclipse.jgit.api.ApplyResult;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.patch.PatchApplier;

public class ApplyCommand
extends GitCommand<ApplyResult> {
    private InputStream in;

    ApplyCommand(Repository local) {
        super(local);
        if (local == null) {
            throw new NullPointerException(JGitText.get().repositoryIsRequired);
        }
    }

    public ApplyCommand setPatch(InputStream in) {
        this.checkCallable();
        this.in = in;
        return this;
    }

    @Override
    public ApplyResult call() throws GitAPIException {
        this.checkCallable();
        this.setCallable(false);
        ApplyResult r = new ApplyResult();
        PatchApplier patchApplier = new PatchApplier(this.repo);
        PatchApplier.Result applyResult = patchApplier.applyPatch(this.in);
        for (String p : applyResult.getPaths()) {
            r.addUpdatedFile(new File(this.repo.getWorkTree(), p));
        }
        return r;
    }
}

