/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FakeDefaultLiteral;
import org.eclipse.jdt.internal.compiler.ast.GuardedPattern;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.TypePattern;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CaseStatement
extends Statement {
    static final int CASE_CONSTANT = 1;
    static final int CASE_PATTERN = 2;
    public BranchLabel targetLabel;
    public Expression[] constantExpressions;
    public BranchLabel[] targetLabels;
    public boolean isExpr;
    int patternIndex;

    public CaseStatement(Expression constantExpression, int sourceEnd, int sourceStart) {
        Expression[] expressionArray;
        if (constantExpression != null) {
            Expression[] expressionArray2 = new Expression[1];
            expressionArray = expressionArray2;
            expressionArray2[0] = constantExpression;
        } else {
            expressionArray = null;
        }
        this(sourceEnd, sourceStart, expressionArray);
    }

    public CaseStatement(int sourceEnd, int sourceStart, Expression[] constantExpressions) {
        this.isExpr = false;
        this.patternIndex = -1;
        this.constantExpressions = constantExpressions;
        this.sourceEnd = sourceEnd;
        this.sourceStart = sourceStart;
        this.initPatterns();
    }

    private void initPatterns() {
        int l = this.constantExpressions == null ? 0 : this.constantExpressions.length;
        int i = 0;
        while (i < l) {
            Expression e = this.constantExpressions[i];
            if (e instanceof Pattern) {
                this.patternIndex = i;
                break;
            }
            ++i;
        }
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.constantExpressions != null) {
            int nullPatternCount = 0;
            int i = 0;
            while (i < this.constantExpressions.length) {
                LocalVariableBinding binding;
                Expression e;
                if (i > 0 && e instanceof Pattern && (i != (nullPatternCount += (e = this.constantExpressions[i]) instanceof NullLiteral ? 1 : 0) || !(e instanceof TypePattern))) {
                    currentScope.problemReporter().IllegalFallThroughToPattern(e);
                }
                flowInfo = this.analyseConstantExpression(currentScope, flowContext, flowInfo, e);
                if (nullPatternCount > 0 && e instanceof TypePattern && (binding = ((TypePattern)e).local.binding) != null) {
                    flowInfo.markNullStatus(binding, 16);
                }
                ++i;
            }
        }
        return flowInfo;
    }

    private FlowInfo analyseConstantExpression(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Expression e) {
        if (e.constant == Constant.NotAConstant && !e.resolvedType.isEnum()) {
            Expression switchValue;
            boolean caseNullorDefaultAllowed;
            boolean bl = caseNullorDefaultAllowed = JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(currentScope.compilerOptions()) && (e instanceof NullLiteral || e instanceof FakeDefaultLiteral);
            if (!caseNullorDefaultAllowed) {
                currentScope.problemReporter().caseExpressionMustBeConstant(e);
            }
            if (e instanceof NullLiteral && flowContext.associatedNode instanceof SwitchStatement && (switchValue = ((SwitchStatement)flowContext.associatedNode).expression) != null && switchValue.nullStatus(flowInfo, flowContext) == 4) {
                currentScope.problemReporter().unnecessaryNullCaseInSwitchOverNonNull(this);
            }
        }
        return e.analyseCode(currentScope, flowContext, flowInfo);
    }

    @Override
    public boolean containsPatternVariable() {
        return this.patternIndex != -1;
    }

    @Override
    public StringBuffer printStatement(int tab, StringBuffer output) {
        CaseStatement.printIndent(tab, output);
        if (this.constantExpressions == null) {
            output.append("default ");
            output.append(this.isExpr ? "->" : ":");
        } else {
            output.append("case ");
            int i = 0;
            int l = this.constantExpressions.length;
            while (i < l) {
                this.constantExpressions[i].printExpression(0, output);
                if (i < l - 1) {
                    output.append(',');
                }
                ++i;
            }
            output.append(this.isExpr ? " ->" : " :");
        }
        return output;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.targetLabels != null) {
            int i = 0;
            int l = this.targetLabels.length;
            while (i < l) {
                this.targetLabels[i].place();
                ++i;
            }
        }
        if (this.targetLabel != null) {
            this.targetLabel.place();
        }
        this.casePatternExpressionGenerateCode(currentScope, codeStream);
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    private void casePatternExpressionGenerateCode(BlockScope currentScope, CodeStream codeStream) {
        if (this.patternIndex != -1) {
            LocalVariableBinding local = currentScope.findVariable(SwitchStatement.SecretPatternVariableName, null);
            codeStream.load(local);
            Pattern pattern = (Pattern)this.constantExpressions[this.patternIndex];
            pattern.generateCode(currentScope, codeStream);
            if (!(pattern instanceof GuardedPattern)) {
                codeStream.goto_(pattern.thenTarget);
            }
        }
    }

    @Override
    public void resolve(BlockScope scope) {
    }

    public ResolvedCase[] resolveCase(BlockScope scope, TypeBinding switchExpressionType, SwitchStatement switchStatement) {
        if (this.containsPatternVariable()) {
            return this.resolveWithPatternVariablesInScope(this.patternVarsWhenTrue, scope, switchExpressionType, switchStatement);
        }
        return this.resolveCasePrivate(scope, switchExpressionType, switchStatement);
    }

    public ResolvedCase[] resolveWithPatternVariablesInScope(LocalVariableBinding[] patternVariablesInScope, BlockScope scope, TypeBinding switchExpressionType, SwitchStatement switchStatement) {
        if (patternVariablesInScope != null) {
            LocalVariableBinding[] localVariableBindingArray = patternVariablesInScope;
            int n = patternVariablesInScope.length;
            int n2 = 0;
            while (n2 < n) {
                LocalVariableBinding binding = localVariableBindingArray[n2];
                binding.modifiers &= 0xEFFFFFFF;
                ++n2;
            }
            ResolvedCase[] cases = this.resolveCasePrivate(scope, switchExpressionType, switchStatement);
            LocalVariableBinding[] localVariableBindingArray2 = patternVariablesInScope;
            int n3 = patternVariablesInScope.length;
            n = 0;
            while (n < n3) {
                LocalVariableBinding binding = localVariableBindingArray2[n];
                binding.modifiers |= 0x10000000;
                ++n;
            }
            return cases;
        }
        return this.resolveCasePrivate(scope, switchExpressionType, switchStatement);
    }

    private Expression getFirstValidExpression(BlockScope scope, SwitchStatement switchStatement) {
        assert (this.constantExpressions != null);
        Expression ret = null;
        int patternCaseLabelCount = 0;
        int typePatternCount = 0;
        int defaultCaseLabelCount = 0;
        int nullCaseLabelCount = 0;
        boolean patternSwitchAllowed = JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(scope.compilerOptions());
        if (patternSwitchAllowed) {
            Expression[] expressionArray = this.constantExpressions;
            int n = this.constantExpressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression e = expressionArray[n2];
                if (e instanceof FakeDefaultLiteral) {
                    scope.problemReporter().validateJavaFeatureSupport(JavaFeature.PATTERN_MATCHING_IN_SWITCH, e.sourceStart, e.sourceEnd);
                    this.flagDuplicateDefault(scope, switchStatement, this.constantExpressions.length > 1 ? e : this);
                    if (patternCaseLabelCount > 0) {
                        scope.problemReporter().switchPatternBothPatternAndDefaultCaseLabelsNotAllowed(e);
                    }
                    ++defaultCaseLabelCount;
                } else {
                    if (e instanceof Pattern) {
                        scope.problemReporter().validateJavaFeatureSupport(JavaFeature.PATTERN_MATCHING_IN_SWITCH, e.sourceStart, e.sourceEnd);
                        if (patternCaseLabelCount++ > 0) {
                            scope.problemReporter().switchPatternOnlyOnePatternCaseLabelAllowed(e);
                            return e;
                        }
                        if (defaultCaseLabelCount > 0) {
                            scope.problemReporter().switchPatternBothPatternAndDefaultCaseLabelsNotAllowed(e);
                            return e;
                        }
                        if (e instanceof TypePattern) {
                            ++typePatternCount;
                        } else if (nullCaseLabelCount > 0) {
                            scope.problemReporter().switchPatternBothNullAndNonTypePatternNotAllowed(e);
                            return e;
                        }
                    } else if (e instanceof NullLiteral) {
                        scope.problemReporter().validateJavaFeatureSupport(JavaFeature.PATTERN_MATCHING_IN_SWITCH, e.sourceStart, e.sourceEnd);
                        if (switchStatement.nullCase == null) {
                            switchStatement.nullCase = this;
                            if ((switchStatement.switchBits & 4) != 0) {
                                scope.problemReporter().patternDominatedByAnother(this.constantExpressions[0]);
                                return e;
                            }
                        }
                        ++nullCaseLabelCount;
                        if (patternCaseLabelCount - typePatternCount > 0) {
                            scope.problemReporter().switchPatternBothNullAndNonTypePatternNotAllowed(e);
                            return e;
                        }
                    }
                    if (ret == null) {
                        ret = e;
                    }
                }
                ++n2;
            }
        } else {
            Expression[] expressionArray = this.constantExpressions;
            int n = this.constantExpressions.length;
            int n3 = 0;
            while (n3 < n) {
                Expression e = expressionArray[n3];
                if (e instanceof Pattern || e instanceof NullLiteral || e instanceof FakeDefaultLiteral) {
                    scope.problemReporter().validateJavaFeatureSupport(JavaFeature.PATTERN_MATCHING_IN_SWITCH, e.sourceStart, e.sourceEnd);
                } else if (ret == null) {
                    ret = e;
                }
                ++n3;
            }
        }
        return ret;
    }

    private ResolvedCase[] resolveCasePrivate(BlockScope scope, TypeBinding switchExpressionType, SwitchStatement switchStatement) {
        TypeBinding caseType;
        scope.enclosingCase = this;
        if (this.constantExpressions == null) {
            this.flagDuplicateDefault(scope, switchStatement, this);
            return ResolvedCase.UnresolvedCase;
        }
        Expression constExpr = this.getFirstValidExpression(scope, switchStatement);
        if (constExpr == null) {
            return ResolvedCase.UnresolvedCase;
        }
        switchStatement.cases[switchStatement.caseCount++] = this;
        if (switchExpressionType != null && switchExpressionType.isEnum() && constExpr instanceof SingleNameReference) {
            ((SingleNameReference)constExpr).setActualReceiverType((ReferenceBinding)switchExpressionType);
        }
        if ((caseType = constExpr.resolveType(scope)) == null || switchExpressionType == null) {
            return ResolvedCase.UnresolvedCase;
        }
        ArrayList<ResolvedCase> cases = new ArrayList<ResolvedCase>();
        Expression[] expressionArray = this.constantExpressions;
        int n = this.constantExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            block16: {
                Constant con;
                Expression e;
                block13: {
                    block15: {
                        block14: {
                            e = expressionArray[n2];
                            if (e == constExpr) break block13;
                            if (!switchExpressionType.isEnum() || !(e instanceof SingleNameReference)) break block14;
                            ((SingleNameReference)e).setActualReceiverType((ReferenceBinding)switchExpressionType);
                            break block15;
                        }
                        if (e instanceof FakeDefaultLiteral) break block16;
                    }
                    caseType = e.resolveType(scope);
                }
                if (caseType == null) {
                    return ResolvedCase.UnresolvedCase;
                }
                if (caseType.isValidBinding() && (con = this.resolveConstantExpression(scope, caseType, switchExpressionType, switchStatement, e)) != Constant.NotAConstant) {
                    int n3;
                    if (this == switchStatement.nullCase && e instanceof NullLiteral) {
                        n3 = -1;
                    } else {
                        int n4 = switchStatement.constantIndex;
                        n3 = n4;
                        switchStatement.constantIndex = n4 + 1;
                    }
                    int index = n3;
                    cases.add(new ResolvedCase(con, e, caseType, index));
                }
            }
            ++n2;
        }
        this.resolveWithPatternVariablesInScope(this.getPatternVariablesWhenTrue(), scope);
        if (cases.size() > 0) {
            return cases.toArray(new ResolvedCase[cases.size()]);
        }
        return ResolvedCase.UnresolvedCase;
    }

    private void flagDuplicateDefault(BlockScope scope, SwitchStatement switchStatement, ASTNode node) {
        if (switchStatement.defaultCase != null) {
            scope.problemReporter().duplicateDefaultCase(node);
        }
        switchStatement.defaultCase = this;
        if ((switchStatement.switchBits & 4) != 0) {
            scope.problemReporter().illegalTotalPatternWithDefault(this);
        }
    }

    public void collectPatternVariablesToScope(LocalVariableBinding[] variables, BlockScope scope) {
        if (!this.containsPatternVariable()) {
            return;
        }
        Expression[] expressionArray = this.constantExpressions;
        int n = this.constantExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            e.collectPatternVariablesToScope(variables, scope);
            LocalVariableBinding[] patternVariables = e.getPatternVariablesWhenTrue();
            this.addPatternVariablesWhenTrue(patternVariables);
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Constant resolveConstantExpression(BlockScope scope, TypeBinding caseType, TypeBinding switchType, SwitchStatement switchStatement, Expression expression) {
        boolean boxing;
        boolean patternSwitchAllowed = JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(scope.compilerOptions());
        if (patternSwitchAllowed) {
            if (expression instanceof Pattern) {
                return this.resolveConstantExpression(scope, caseType, switchType, switchStatement, (Pattern)expression);
            }
            if (expression instanceof NullLiteral) {
                if (!(switchType instanceof ReferenceBinding)) {
                    scope.problemReporter().typeMismatchError((TypeBinding)TypeBinding.NULL, switchType, expression, null);
                }
                switchStatement.switchBits |= 2;
                return IntConstant.fromValue(-1);
            }
            if (!(expression instanceof FakeDefaultLiteral) && switchStatement.isNonTraditional && switchType.isBaseType() && !expression.isConstantValueOfTypeAssignableToType(caseType, switchType)) {
                scope.problemReporter().typeMismatchError(caseType, switchType, expression, null);
                return Constant.NotAConstant;
            }
        }
        boolean bl = boxing = !patternSwitchAllowed || switchStatement.isAllowedType(switchType);
        if (expression.isConstantValueOfTypeAssignableToType(caseType, switchType) || caseType.isCompatibleWith(switchType) && !(expression instanceof StringLiteral)) {
            if (!caseType.isEnum()) return expression.constant;
            if ((expression.bits & 0x1FE00000) >> 21 != 0) {
                scope.problemReporter().enumConstantsCannotBeSurroundedByParenthesis(expression);
            }
            if (expression instanceof NameReference && (expression.bits & 7) == 1) {
                NameReference reference = (NameReference)expression;
                FieldBinding field = reference.fieldBinding();
                if ((field.modifiers & 0x4000) == 0) {
                    scope.problemReporter().enumSwitchCannotTargetField(reference, field);
                    return IntConstant.fromValue(field.original().id + 1);
                } else {
                    if (!(reference instanceof QualifiedNameReference)) return IntConstant.fromValue(field.original().id + 1);
                    scope.problemReporter().cannotUseQualifiedEnumConstantInCaseLabel(reference, field);
                }
                return IntConstant.fromValue(field.original().id + 1);
            }
        } else if (boxing && this.isBoxingCompatible(caseType, switchType, expression, scope)) {
            return expression.constant;
        }
        scope.problemReporter().typeMismatchError(expression.resolvedType, switchType, expression, (ASTNode)switchStatement.expression);
        return Constant.NotAConstant;
    }

    private Constant resolveConstantExpression(BlockScope scope, TypeBinding caseType, TypeBinding switchExpressionType, SwitchStatement switchStatement, Pattern e) {
        Constant constant = Constant.NotAConstant;
        TypeBinding type = e.resolveType(scope);
        if (type != null) {
            constant = IntConstant.fromValue(switchStatement.constantIndex);
            switchStatement.caseLabelElements.add(e);
            if (e.resolvedType != null) {
                TypeBinding pb = e.resolveAtType(scope, switchStatement.expression.resolvedType);
                if (pb != null) {
                    switchStatement.caseLabelElementTypes.add(pb);
                }
                TypeBinding expressionType = switchStatement.expression.resolvedType;
                LocalDeclaration patternVar = e.getPatternVariable();
                if (patternVar != null && !patternVar.type.isTypeNameVar(scope)) {
                    if (!pb.isReifiable()) {
                        boolean isLegal;
                        if (!(expressionType == TypeBinding.NULL || (isLegal = e.checkCastTypesCompatibility(scope, pb, expressionType, e, false)) && (e.bits & 0x80) == 0)) {
                            scope.problemReporter().unsafeCastInInstanceof(e, pb, expressionType);
                        }
                    } else if (pb.isValidBinding()) {
                        if (pb.isPrimitiveType()) {
                            scope.problemReporter().unexpectedTypeinSwitchPattern(pb, e);
                            return Constant.NotAConstant;
                        }
                        if (pb.isBaseType() || !e.checkCastTypesCompatibility(scope, pb, expressionType, null, false)) {
                            scope.problemReporter().typeMismatchError(expressionType, pb, e, null);
                            return Constant.NotAConstant;
                        }
                    }
                }
                if (e.isTotalForType(expressionType)) {
                    if ((switchStatement.switchBits & 4) != 0) {
                        scope.problemReporter().duplicateTotalPattern(e);
                        return IntConstant.fromValue(-1);
                    }
                    switchStatement.switchBits |= 0xC;
                    if (switchStatement.defaultCase != null) {
                        scope.problemReporter().illegalTotalPatternWithDefault(this);
                    }
                    switchStatement.totalPattern = e;
                    e.isTotalTypeNode = true;
                    if (switchStatement.nullCase == null) {
                        constant = IntConstant.fromValue(-1);
                    }
                }
            }
        }
        return constant;
    }

    void patternCaseRemovePatternLocals(final CodeStream codeStream) {
        Expression[] expressionArray = this.constantExpressions;
        int n = this.constantExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            if (e instanceof Pattern) {
                e.traverse(new ASTVisitor(){

                    @Override
                    public boolean visit(TypePattern typePattern, BlockScope scope) {
                        LocalDeclaration local = typePattern.getPatternVariable();
                        if (local != null && local.binding != null) {
                            codeStream.removeVariable(local.binding);
                        }
                        return false;
                    }
                }, (BlockScope)null);
            }
            ++n2;
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope) && this.constantExpressions != null) {
            Expression[] expressionArray = this.constantExpressions;
            int n = this.constantExpressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression e = expressionArray[n2];
                e.traverse(visitor, blockScope);
                ++n2;
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public LocalDeclaration getLocalDeclaration() {
        Expression cexp = this.constantExpressions[this.patternIndex];
        LocalDeclaration patternVariableIntroduced = cexp.getPatternVariable();
        return patternVariableIntroduced;
    }

    public static class ResolvedCase {
        static final ResolvedCase[] UnresolvedCase = new ResolvedCase[0];
        public Constant c;
        public Expression e;
        public TypeBinding t;
        public int index;
        private int intValue;
        private boolean isPattern;

        ResolvedCase(Constant c, Expression e, TypeBinding t, int index) {
            this.c = c;
            this.e = e;
            this.t = t;
            this.index = index;
            if (c.typeID() == 11) {
                c.stringValue().hashCode();
            } else {
                this.intValue = c.intValue();
            }
            this.isPattern = e instanceof Pattern;
        }

        public int intValue() {
            return this.intValue;
        }

        public boolean isPattern() {
            return this.isPattern;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("case ");
            builder.append(this.e);
            builder.append(" [CONSTANT=");
            builder.append(this.c);
            builder.append("]");
            return builder.toString();
        }
    }
}

