/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IStackElement;
import org.eclipse.tm4e.core.internal.grammar.ScopeListElement;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.Rule;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

public final class StackElement
implements IStackElement {
    public static final StackElement NULL = new StackElement(null, 0, 0, 0, false, null, new ScopeListElement(null, "", 0), new ScopeListElement(null, "", 0));
    private int enterPosition;
    private int anchorPos;
    final @Nullable StackElement parent;
    final int depth;
    final int ruleId;
    final boolean beginRuleCapturedEOL;
    final @Nullable String endRule;
    final ScopeListElement nameScopesList;
    final ScopeListElement contentNameScopesList;

    StackElement(@Nullable StackElement parent, int ruleId, int enterPos, int anchorPos, boolean beginRuleCapturedEOL, @Nullable String endRule, ScopeListElement nameScopesList, ScopeListElement contentNameScopesList) {
        this.parent = parent;
        this.depth = this.parent != null ? this.parent.depth + 1 : 1;
        this.ruleId = ruleId;
        this.enterPosition = enterPos;
        this.anchorPos = anchorPos;
        this.beginRuleCapturedEOL = beginRuleCapturedEOL;
        this.endRule = endRule;
        this.nameScopesList = nameScopesList;
        this.contentNameScopesList = contentNameScopesList;
    }

    private static boolean structuralEquals(@Nullable StackElement a, @Nullable StackElement b) {
        while (a != b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.depth != b.depth || a.ruleId != b.ruleId || !Objects.equals(a.endRule, b.endRule)) {
                return false;
            }
            a = a.parent;
            b = b.parent;
        }
        return true;
    }

    private static boolean equals(@Nullable StackElement a, @Nullable StackElement b) {
        if (a == b) {
            return true;
        }
        if (!StackElement.structuralEquals(a, b)) {
            return false;
        }
        return a.contentNameScopesList.equals(b.contentNameScopesList);
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || other.getClass() != StackElement.class) {
            return false;
        }
        return StackElement.equals(this, (StackElement)other);
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.endRule, this.parent, this.contentNameScopesList);
        result = 31 * result + this.depth;
        result = 31 * result + this.ruleId;
        return result;
    }

    void reset() {
        StackElement el = this;
        while (el != null) {
            el.enterPosition = -1;
            el.anchorPos = -1;
            el = el.parent;
        }
    }

    @Nullable StackElement pop() {
        return this.parent;
    }

    StackElement safePop() {
        if (this.parent != null) {
            return this.parent;
        }
        return this;
    }

    StackElement push(int ruleId, int enterPos, int anchorPos, boolean beginRuleCapturedEOL, @Nullable String endRule, ScopeListElement nameScopesList, ScopeListElement contentNameScopesList) {
        return new StackElement(this, ruleId, enterPos, anchorPos, beginRuleCapturedEOL, endRule, nameScopesList, contentNameScopesList);
    }

    int getAnchorPos() {
        return this.anchorPos;
    }

    int getEnterPos() {
        return this.enterPosition;
    }

    Rule getRule(IRuleRegistry grammar) {
        return grammar.getRule(this.ruleId);
    }

    private void appendString(List<String> res) {
        if (this.parent != null) {
            this.parent.appendString(res);
        }
        res.add("(" + this.ruleId + ")");
    }

    public String toString() {
        ArrayList<String> r = new ArrayList<String>();
        this.appendString(r);
        return String.valueOf('[') + String.join((CharSequence)", ", r) + ']';
    }

    StackElement setContentNameScopesList(ScopeListElement contentNameScopesList) {
        if (this.contentNameScopesList.equals(contentNameScopesList)) {
            return this;
        }
        return NullSafetyHelper.castNonNull(this.parent).push(this.ruleId, this.enterPosition, this.anchorPos, this.beginRuleCapturedEOL, this.endRule, this.nameScopesList, contentNameScopesList);
    }

    StackElement setEndRule(String endRule) {
        if (this.endRule != null && this.endRule.equals(endRule)) {
            return this;
        }
        return new StackElement(this.parent, this.ruleId, this.enterPosition, this.anchorPos, this.beginRuleCapturedEOL, endRule, this.nameScopesList, this.contentNameScopesList);
    }

    boolean hasSameRuleAs(StackElement other) {
        StackElement el = this;
        while (el != null && el.enterPosition == other.enterPosition) {
            if (el.ruleId == other.ruleId) {
                return true;
            }
            el = el.parent;
        }
        return false;
    }
}

