/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wtp.releng.tools.component.api.ClassUse;
import org.eclipse.wtp.releng.tools.component.api.Source;
import org.eclipse.wtp.releng.tools.component.ui.ComponentManager;
import org.eclipse.wtp.releng.tools.component.ui.internal.JavaSourceFinder;
import org.eclipse.wtp.releng.tools.component.ui.internal.ScannableComponent;
import org.eclipse.wtp.releng.tools.component.ui.internal.job.AbstractScanJob;

public class ScanComponent
extends AbstractScanJob {
    private ScannableComponent scannableComponent;
    private boolean force;
    private List sources;

    public ScanComponent(ScannableComponent scannableComponent, boolean force) {
        super(ComponentManager.getManager().getMessage("JOB_SCAN_COMPONENT", new String[]{scannableComponent.getCompXML().getName()}));
        this.scannableComponent = scannableComponent;
        this.force = force;
        this.sources = null;
    }

    public ScannableComponent getScannableComponent() {
        return this.scannableComponent;
    }

    public List getSources() {
        return this.sources;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus run(IProgressMonitor monitor) {
        IJobManager jobManager = Platform.getJobManager();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            jobManager.beginRule((ISchedulingRule)root, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            jobManager.endRule((ISchedulingRule)root);
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        jobManager.endRule((ISchedulingRule)root);
        {
            this.sources = this.scannableComponent.scan(this.force);
        }
        if (this.sources != null) {
            Source source;
            Iterator it;
            ArrayList<Source> innerClasses = new ArrayList<Source>();
            Iterator sourcesIt = this.sources.iterator();
            while (true) {
                if (!sourcesIt.hasNext()) {
                    it = innerClasses.iterator();
                    break;
                }
                source = (Source)sourcesIt.next();
                String sourceName = source.getName();
                if (sourceName.indexOf(36) == -1) {
                    this.createMarker(sourceName, source.getClassUses(), false);
                    continue;
                }
                innerClasses.add(source);
            }
            while (it.hasNext()) {
                source = (Source)it.next();
                this.createMarker(source.getName(), source.getClassUses(), true);
            }
        }
        return new Status(0, "org.eclipse.wtp.releng.tools.component.ui", 0, "", null);
    }

    private void createMarker(String sourceName, Collection classUses, boolean isInnerClass) {
        List projects = this.scannableComponent.getProjects();
        Iterator projectsIt = projects.iterator();
        while (projectsIt.hasNext()) {
            JavaSourceFinder finder = new JavaSourceFinder(sourceName);
            try {
                ((IProject)projectsIt.next()).accept((IResourceProxyVisitor)finder, 2);
                IResource javaSource = finder.getJavaSource();
                if (javaSource == null) continue;
                if (!isInnerClass) {
                    this.deleteViolationMarksers(javaSource);
                }
                Iterator it = classUses.iterator();
                while (it.hasNext()) {
                    this.createClassViolationMarker(javaSource, (ClassUse)it.next());
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

