/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wtp.releng.tools.component.ILibrary;
import org.eclipse.wtp.releng.tools.component.IPluginXML;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.Package;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.eclipse.wtp.releng.tools.component.internal.Type;
import org.eclipse.wtp.releng.tools.component.ui.ComponentManager;

public class APIDialog
extends Dialog
implements ITreeContentProvider {
    public static final int OPTION_PACKAGE = 0;
    public static final int OPTION_TYPE = 1;
    private int option;
    private ComponentXML compXML;
    private Package pkg;
    private List ignoreNames;
    private Tree tree;

    public APIDialog(Shell shell, int option, ComponentXML compXML, Package pkg, List ignoreNames) {
        super(shell);
        this.option = option;
        this.compXML = compXML;
        this.pkg = pkg;
        this.ignoreNames = ignoreNames;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.option == 0) {
            shell.setText(ComponentManager.getManager().getMessage("DIALOG_TITLE_ADD_PACKAGES"));
        } else {
            shell.setText(ComponentManager.getManager().getMessage("DIALOG_TITLE_ADD_TYPES"));
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 5;
        gl.marginHeight = 5;
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 300;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)gd);
        this.tree = new Tree(composite, 2818);
        this.tree.setLayout((Layout)gl);
        this.tree.setLayoutData((Object)new GridData(1808));
        TreeViewer apisViewer = new TreeViewer(this.tree);
        apisViewer.setContentProvider((IContentProvider)this);
        apisViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        apisViewer.setInput((Object)this.compXML);
        return composite;
    }

    protected void okPressed() {
        if (this.option == 0) {
            Collection pkgs = this.compXML.getPackages();
            TreeItem[] items = this.tree.getSelection();
            int i = 0;
            while (i < items.length) {
                Package pkg = new Package();
                pkg.setName(items[i].getText());
                pkgs.add(pkg);
                ++i;
            }
        } else {
            Collection types = this.pkg.getTypes();
            TreeItem[] items = this.tree.getSelection();
            int i = 0;
            while (i < items.length) {
                Type type = new Type();
                type.setName(items[i].getText());
                types.add(type);
                ++i;
            }
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<String> nameList = new ArrayList<String>();
        if (inputElement instanceof ComponentXML) {
            Collection plugins = ((ComponentXML)inputElement).getPlugins();
            Iterator pluginsIt = plugins.iterator();
            while (pluginsIt.hasNext()) {
                String pluginId = ((Plugin)pluginsIt.next()).getId();
                IPluginXML pluginXML = ComponentManager.getManager().getPlugin(pluginId);
                if (pluginXML == null) continue;
                List libs = pluginXML.getLibraries();
                Iterator libsIt = libs.iterator();
                while (libsIt.hasNext()) {
                    ILibrary lib = (ILibrary)libsIt.next();
                    Map types = lib.getTypes();
                    Iterator typesIt = types.keySet().iterator();
                    while (typesIt.hasNext()) {
                        String typeName = (String)typesIt.next();
                        if (typeName.lastIndexOf(36) != -1 || typeName.indexOf(".internal.") != -1) continue;
                        int dot = typeName.lastIndexOf(46);
                        String name = null;
                        if (this.option == 0 && dot != -1) {
                            name = typeName.substring(0, dot);
                        } else {
                            String pkgName = this.pkg.getName();
                            if (dot != -1 && dot == pkgName.length() && typeName.startsWith(pkgName)) {
                                name = typeName.substring(dot + 1);
                            }
                        }
                        if (name == null || this.ignoreNames.contains(name) || nameList.contains(name)) continue;
                        nameList.add(name);
                    }
                }
            }
        }
        return nameList.toArray(new String[0]);
    }
}

