/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsl.ui.internal.contentassist.CallTemplateContentAssistRequest;
import org.eclipse.wst.xsl.ui.internal.contentassist.ExcludeResultPrefixesContentAssist;
import org.eclipse.wst.xsl.ui.internal.contentassist.IContentAssistProposalRequest;
import org.eclipse.wst.xsl.ui.internal.contentassist.NullContentAssistRequest;
import org.eclipse.wst.xsl.ui.internal.contentassist.SelectAttributeContentAssist;
import org.eclipse.wst.xsl.ui.internal.contentassist.TemplateModeAttributeContentAssist;
import org.eclipse.wst.xsl.ui.internal.contentassist.TemplateNameAttributeContentAssist;
import org.eclipse.wst.xsl.ui.internal.contentassist.TestAttributeContentAssist;
import org.eclipse.wst.xsl.ui.internal.contentassist.href.HrefContentAssistRequest;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XSLContentAssistRequestFactory {
    private static final String ATTR_SELECT = "select";
    private static final String ATTR_TEST = "test";
    private static final String ATTR_MATCH = "match";
    private static final String ATTR_EXCLUDE_RESULT_PREFIXES = "exclude-result-prefixes";
    private static final String ATTR_MODE = "mode";
    private static final String ELEM_TEMPLATE = "template";
    private static final String ELEM_APPLYTEMPLATES = "apply-templates";
    private static final String ELEM_APPLY_IMPORTS = "apply-imports";
    private static final String ATTR_HREF = "href";
    private static final String ELEM_CALLTEMPLATE = "call-template";
    private static final String ATTR_NAME = "name";
    private ITextViewer textViewer;
    private int documentPosition;
    private IDOMNode xmlNode;
    private IStructuredDocumentRegion sdRegion;
    private ITextRegion completionRegion;
    private String matchString;

    public XSLContentAssistRequestFactory(ITextViewer textViewer, int documentPosition, IDOMNode xmlNode, IStructuredDocumentRegion sdRegion, ITextRegion completionRegion, String matchString) {
        this.textViewer = textViewer;
        this.documentPosition = documentPosition;
        this.xmlNode = xmlNode;
        this.sdRegion = sdRegion;
        this.completionRegion = completionRegion;
        this.matchString = matchString;
    }

    public IContentAssistProposalRequest getContentAssistRequest() {
        NamedNodeMap nodeMap = this.xmlNode.getAttributes();
        IDOMElement element = (IDOMElement)this.xmlNode;
        IContentAssistProposalRequest proposal = this.commonAttributeProposals(nodeMap);
        if (proposal instanceof NullContentAssistRequest && this.isElementProposal(element)) {
            proposal = this.getElementProposals(nodeMap, element);
        }
        return proposal;
    }

    private boolean isElementProposal(IDOMElement element) {
        String localName = element.getLocalName();
        return localName.equals(ELEM_TEMPLATE) || localName.equals(ELEM_APPLYTEMPLATES) || localName.equals(ELEM_CALLTEMPLATE);
    }

    private IContentAssistProposalRequest getElementProposals(NamedNodeMap nodeMap, IDOMElement element) {
        if (element.getLocalName().equals(ELEM_TEMPLATE)) {
            return this.getTemplateProposals(nodeMap);
        }
        if ((element.getLocalName().equals(ELEM_APPLYTEMPLATES) || element.getLocalName().equals(ELEM_APPLY_IMPORTS)) && this.hasAttributeAtTextRegion(ATTR_MODE, nodeMap, this.completionRegion)) {
            return new TemplateModeAttributeContentAssist((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.documentPosition, 0, this.matchString, this.textViewer);
        }
        if (element.getLocalName().equals(ELEM_CALLTEMPLATE) && this.hasAttributeAtTextRegion(ATTR_NAME, nodeMap, this.completionRegion)) {
            return new CallTemplateContentAssistRequest((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.documentPosition, 0, this.matchString, this.textViewer);
        }
        return new NullContentAssistRequest((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.documentPosition, 0, this.matchString, this.textViewer);
    }

    private IContentAssistProposalRequest getTemplateProposals(NamedNodeMap nodeMap) {
        if (this.hasAttributeAtTextRegion(ATTR_MODE, nodeMap, this.completionRegion)) {
            return new TemplateModeAttributeContentAssist((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.documentPosition, 0, this.matchString, this.textViewer);
        }
        if (this.hasAttributeAtTextRegion(ATTR_NAME, nodeMap, this.completionRegion)) {
            return new TemplateNameAttributeContentAssist((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.documentPosition, 0, this.matchString, this.textViewer);
        }
        return new NullContentAssistRequest((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.documentPosition, 0, this.matchString, this.textViewer);
    }

    private IContentAssistProposalRequest commonAttributeProposals(NamedNodeMap nodeMap) {
        if (this.hasAttributeAtTextRegion(ATTR_SELECT, nodeMap, this.completionRegion)) {
            return new SelectAttributeContentAssist((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.documentPosition, 0, this.matchString, this.textViewer);
        }
        if (this.hasAttributeAtTextRegion(ATTR_MATCH, nodeMap, this.completionRegion)) {
            return new SelectAttributeContentAssist((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.documentPosition, 0, this.matchString, this.textViewer);
        }
        if (this.hasAttributeAtTextRegion(ATTR_TEST, nodeMap, this.completionRegion)) {
            return new TestAttributeContentAssist((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.documentPosition, 0, this.matchString, this.textViewer);
        }
        if (this.hasAttributeAtTextRegion(ATTR_EXCLUDE_RESULT_PREFIXES, nodeMap, this.completionRegion)) {
            return new ExcludeResultPrefixesContentAssist((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.documentPosition, 0, this.matchString, this.textViewer);
        }
        if (this.hasAttributeAtTextRegion(ATTR_HREF, nodeMap, this.completionRegion)) {
            return new HrefContentAssistRequest((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.documentPosition, 0, this.matchString, this.textViewer);
        }
        return new NullContentAssistRequest((Node)this.xmlNode, this.sdRegion, this.completionRegion, this.documentPosition, 0, this.matchString, this.textViewer);
    }

    protected boolean hasAttributeAtTextRegion(String attrName, NamedNodeMap nodeMap, ITextRegion aRegion) {
        IDOMAttr attrNode = (IDOMAttr)nodeMap.getNamedItem(attrName);
        return attrNode != null && attrNode.getValueRegion() != null && attrNode.getValueRegion().getStart() == aRegion.getStart();
    }
}

