/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.single;

import java.util.Map;
import org.eclipse.jst.pagedesigner.commands.CommandResources;
import org.eclipse.jst.pagedesigner.commands.single.SingleNodeCommand;
import org.eclipse.jst.pagedesigner.dom.DOMStyleUtil;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.css.ElementCSSInlineStyle;

public class ChangeStyleCommand
extends SingleNodeCommand {
    private Map _styleProperties = null;
    private CSSPropertyContext _context = null;

    public ChangeStyleCommand(IDOMElement node, Map map) {
        super(CommandResources.getString("ChangeStyleCommand.Label.ChangeStyle"), node);
        this._styleProperties = map;
    }

    public ChangeStyleCommand(IDOMElement node, CSSPropertyContext context) {
        super(CommandResources.getString("ChangeStyleCommand.Label.ChangeStyle"), node);
        this._context = context;
    }

    protected void doExecute() {
        this.getOriginalElement().getModel().beginRecording((Object)this);
        try {
            if (this._styleProperties != null) {
                IDOMElement original = this.getOriginalElement();
                DOMStyleUtil.insertStyle((Element)original, this._styleProperties);
            } else if (this._context != null) {
                ICSSStyleDeclaration styleDeclaration = (ICSSStyleDeclaration)((ElementCSSInlineStyle)this.getOriginalElement()).getStyle();
                if (styleDeclaration == null) {
                    this.getOriginalElement().setAttribute("style", "");
                    styleDeclaration = (ICSSStyleDeclaration)((ElementCSSInlineStyle)this.getOriginalElement()).getStyle();
                }
                this._context.applyModified(styleDeclaration);
            }
        }
        finally {
            this.getOriginalElement().getModel().endRecording((Object)this);
        }
    }
}

