/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.EditValidateUtil;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.utils.SelectionHelper;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DesignerCommand
extends Command {
    private final IDOMModel _model;
    protected IHTMLGraphicalViewer _viewer;
    private static final Logger _log = PDPlugin.getLogger(DesignerCommand.class);

    public DesignerCommand(String label, IHTMLGraphicalViewer viewer) {
        super(label);
        this._viewer = viewer;
        this._model = viewer.getModel();
    }

    public DesignerCommand(String label, IDOMNode node) {
        this(label, (IDOMDocument)node.getOwnerDocument());
    }

    public DesignerCommand(String label, IDOMDocument document) {
        super(label);
        this._model = document.getModel();
        EditPart part = (EditPart)document.getAdapterFor(EditPart.class);
        if (part != null) {
            this._viewer = (IHTMLGraphicalViewer)part.getViewer();
        }
    }

    public IHTMLGraphicalViewer getViewer() {
        return this._viewer;
    }

    public IDOMModel getModel() {
        return this._model;
    }

    public IDOMDocument getDocument() {
        return this.getModel().getDocument();
    }

    public final void execute() {
        boolean ok = this.prePreExecute();
        if (ok) {
            try {
                try {
                    this.preExecute();
                    this.doExecute();
                    this.postExecute();
                }
                catch (Exception ex) {
                    this.handleException(ex);
                    this.postPostExecute();
                }
            }
            finally {
                this.postPostExecute();
            }
        }
    }

    protected void handleException(Exception ex) {
        ex.printStackTrace();
    }

    protected boolean prePreExecute() {
        int position = -1;
        int length = -1;
        ISelection selection = this.getViewer().getSelection();
        if (selection != null) {
            if (this.getViewer().isInRangeMode()) {
                DesignRange range = (DesignRange)selection;
                if (range.isValid()) {
                    IDOMPosition domPos = DOMPositionHelper.toDOMPosition(range.getStartPosition());
                    IDOMPosition domEnd = DOMPositionHelper.toDOMPosition(range.getEndPosition());
                    if (EditValidateUtil.validPosition(domPos) && EditValidateUtil.validPosition(domEnd)) {
                        position = EditModelQuery.getIndexedRegionLocation(domPos);
                        int end = EditModelQuery.getIndexedRegionLocation(domEnd);
                        if (end < position) {
                            length = position - end;
                            position = end;
                        } else {
                            length = end - position;
                        }
                    }
                }
            } else {
                Object object = ((IStructuredSelection)selection).getFirstElement();
                if (object instanceof ElementEditPart) {
                    IDOMNode node = ((ElementEditPart)((Object)object)).getIDOMNode();
                    position = EditModelQuery.getNodeStartIndex((Node)node);
                    length = EditModelQuery.getNodeLenth((Node)node);
                }
            }
        }
        if (position >= 0 && length >= 0) {
            this.getModel().beginRecording((Object)this, this.getLabel(), position, length);
        } else {
            this.getModel().beginRecording((Object)this, this.getLabel());
        }
        this.getViewer().startSelectionChange();
        this.getModel().aboutToChangeModel();
        return true;
    }

    protected void preExecute() {
    }

    protected abstract void doExecute();

    protected void postExecute() {
    }

    protected void postPostExecute() {
        this.getModel().changedModel();
        this.getViewer().getViewport().validate();
        ISelection sel = this.getAfterCommandDesignerSelection();
        if (sel != null) {
            ITextSelection textSel = SelectionHelper.convertFromDesignSelectionToTextSelection(sel);
            if (textSel != null) {
                this.getModel().endRecording((Object)this, textSel.getOffset(), textSel.getLength());
            } else {
                this.getModel().endRecording((Object)this);
            }
        } else {
            this.getModel().endRecording((Object)this);
        }
        if (sel != null) {
            this.getViewer().setSelection(sel);
        } else {
            this.getViewer().deselectAll();
        }
        if (this.getViewer() != null) {
            this.getViewer().selectionChanged();
        }
    }

    protected abstract ISelection getAfterCommandDesignerSelection();

    protected ISelection toDesignRange(DOMRange range) {
        block4: {
            try {
                if (range != null) break block4;
                return null;
            }
            catch (Exception exception) {
                _log.error("Error.RangeModeCommand.SetSelection");
                return null;
            }
        }
        IDOMPosition startPos = range.getStartPosition();
        DesignPosition start = DOMPositionHelper.toDesignPosition(startPos);
        if (range.isEmpty()) {
            return new DesignRange(start, start);
        }
        IDOMPosition endPos = range.getEndPosition();
        return new DesignRange(start, DOMPositionHelper.toDesignPosition(endPos));
    }

    protected IStructuredSelection toDesignSelection(Node node) {
        EditPart part;
        if (node instanceof INodeNotifier && (part = (EditPart)((INodeNotifier)node).getAdapterFor(EditPart.class)) != null) {
            return new StructuredSelection((Object)part);
        }
        return null;
    }

    public void formatNode(Node node) {
        new HTMLFormatProcessorImpl().formatNode(node);
    }

    public void redo() {
        this.getModel().getUndoManager().redo();
    }

    public void undo() {
        this.getModel().getUndoManager().undo();
    }

    public IFigure getFigureInfo(Element ele) {
        EditPart part;
        if (ele instanceof IDOMElement && (part = (EditPart)((IDOMElement)ele).getAdapterFor(EditPart.class)) instanceof GraphicalEditPart) {
            return ((GraphicalEditPart)part).getFigure();
        }
        return null;
    }
}

