/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModelWrapper;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueAspectAdapter<T>
extends PropertyValueModelWrapper<T>
implements WritablePropertyValueModel<T> {
    protected T value;

    protected ValueAspectAdapter(WritablePropertyValueModel<T> valueHolder) {
        super(valueHolder);
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new ChangeSupport(this);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.valueHolder().setValue(value);
    }

    @Override
    protected void valueChanged(PropertyChangeEvent event) {
        this.disengageValue();
        this.engageValue();
        this.firePropertyChanged(event.cloneWithSource(this));
    }

    @Override
    public synchronized void addStateChangeListener(StateChangeListener listener) {
        if (this.hasNoEngagingListeners()) {
            this.engageValue();
        }
        super.addStateChangeListener(listener);
    }

    @Override
    public synchronized void removeStateChangeListener(StateChangeListener listener) {
        super.removeStateChangeListener(listener);
        if (this.hasNoEngagingListeners()) {
            this.disengageValue();
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.hasNoEngagingListeners()) {
            this.engageValue();
        }
        super.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.hasNoEngagingListeners()) {
            this.engageValue();
        }
        super.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.hasNoEngagingListeners()) {
            this.disengageValue();
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.removePropertyChangeListener(propertyName, listener);
        if (this.hasNoEngagingListeners()) {
            this.disengageValue();
        }
    }

    protected boolean hasNoEngagingListeners() {
        return this.hasNoStateChangeListeners() && this.hasNoPropertyChangeListeners("value");
    }

    protected void engageValue() {
        this.value = this.valueHolder.getValue();
        if (this.value != null) {
            this.engageValue_();
        }
    }

    protected abstract void engageValue_();

    protected void disengageValue() {
        if (this.value != null) {
            this.disengageValue_();
            this.value = null;
        }
    }

    protected abstract void disengageValue_();

    protected void valueAspectChanged() {
        this.fireStateChanged();
    }

    protected WritablePropertyValueModel<T> valueHolder() {
        return (WritablePropertyValueModel)this.valueHolder;
    }
}

