/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterables;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterable<E>
implements Iterable<E> {
    private final E[] array;
    private final int start;
    private final int length;

    public ArrayIterable(E ... array) {
        this(array, 0, array.length);
    }

    public ArrayIterable(E[] array, int start, int length) {
        if (start < 0 || start > array.length) {
            throw new IllegalArgumentException("start: " + start);
        }
        if (length < 0 || length > array.length - start) {
            throw new IllegalArgumentException("length: " + length);
        }
        this.array = array;
        this.start = start;
        this.length = length;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator<E>(this.array, this.start, this.length);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, Arrays.toString(this.array));
    }
}

