/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.GeneratorHolder;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.widgets.IntegerCombo;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratorComposite<T extends Generator>
extends Pane<GeneratorHolder> {
    private PropertyValueModel<Generator> generatorHolder;

    public GeneratorComposite(Pane<? extends GeneratorHolder> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.generatorHolder = this.buildGeneratorHolder();
    }

    private PropertyValueModel<Generator> buildGeneratorHolder() {
        return new PropertyAspectAdapter<GeneratorHolder, Generator>(this.getSubjectHolder(), new String[]{this.getPropertyName()}){

            protected Generator buildValue_() {
                return GeneratorComposite.this.getGenerator((GeneratorHolder)this.subject);
            }
        };
    }

    protected abstract T getGenerator(GeneratorHolder var1);

    protected abstract T buildGenerator(GeneratorHolder var1);

    protected final WritablePropertyValueModel<String> buildGeneratorNameHolder() {
        return new PropertyAspectAdapter<Generator, String>(this.generatorHolder, new String[]{"name"}){

            protected String buildValue_() {
                return ((Generator)this.subject).getName();
            }

            public void setValue(String value) {
                if (this.subject != null) {
                    this.setValue_(value);
                    return;
                }
                if (value.length() == 0) {
                    return;
                }
                GeneratorComposite.this.retrieveGenerator((GeneratorHolder)GeneratorComposite.this.getSubject()).setName(value);
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Generator)this.subject).setName(value);
            }
        };
    }

    protected final T getGenerator() {
        return this.getSubject() == null ? null : (T)this.getGenerator((GeneratorHolder)this.getSubject());
    }

    protected void addAllocationSizeCombo(Composite container) {
        new IntegerCombo<Generator>((Pane)this, this.generatorHolder, container){

            @Override
            protected String getLabelText() {
                return JptUiMappingsMessages.GeneratorComposite_allocationSize;
            }

            @Override
            protected String getHelpId() {
                return null;
            }

            @Override
            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<Generator, Integer>(this.getSubjectHolder(), new String[]{"defaultAllocationSize"}){

                    protected Integer buildValue_() {
                        return ((Generator)this.subject).getDefaultAllocationSize();
                    }
                };
            }

            @Override
            protected WritablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<Generator, Integer>(this.getSubjectHolder(), new String[]{"specifiedAllocationSize"}){

                    protected Integer buildValue_() {
                        return ((Generator)this.subject).getSpecifiedAllocationSize();
                    }

                    public void setValue(Integer value) {
                        GeneratorComposite.this.retrieveGenerator((GeneratorHolder)GeneratorComposite.this.getSubject()).setSpecifiedAllocationSize(value);
                    }
                };
            }
        };
    }

    protected void addInitialValueCombo(Composite container) {
        new IntegerCombo<Generator>((Pane)this, this.generatorHolder, container){

            @Override
            protected String getLabelText() {
                return JptUiMappingsMessages.GeneratorComposite_initialValue;
            }

            @Override
            protected String getHelpId() {
                return null;
            }

            @Override
            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<Generator, Integer>(this.getSubjectHolder(), new String[]{"defaultInitialValue"}){

                    protected Integer buildValue_() {
                        return ((Generator)this.subject).getDefaultInitialValue();
                    }
                };
            }

            @Override
            protected WritablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<Generator, Integer>(this.getSubjectHolder(), new String[]{"specifiedInitialValue"}){

                    protected Integer buildValue_() {
                        return ((Generator)this.subject).getSpecifiedInitialValue();
                    }

                    public void setValue(Integer value) {
                        GeneratorComposite.this.retrieveGenerator((GeneratorHolder)GeneratorComposite.this.getSubject()).setSpecifiedInitialValue(value);
                    }
                };
            }
        };
    }

    protected final JpaProject getJpaProject() {
        return this.getSubject() == null ? null : ((GeneratorHolder)this.getSubject()).getJpaProject();
    }

    protected abstract String getPropertyName();

    protected final T retrieveGenerator(GeneratorHolder subject) {
        T generator = this.getGenerator(subject);
        if (generator == null) {
            generator = this.buildGenerator(subject);
        }
        return generator;
    }
}

