/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal.driver;

import java.util.Collections;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.jpt.jpa.db.internal.driver.CatalogStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnknownCatalogStrategy
implements CatalogStrategy {
    private final Database database;

    UnknownCatalogStrategy(Database database) {
        this.database = database;
    }

    @Override
    public boolean supportsCatalogs() {
        return !this.getCatalogs().isEmpty();
    }

    @Override
    public List<Catalog> getCatalogs() {
        List<Catalog> catalogs = this.getCatalogs_();
        if (catalogs == null || catalogs.isEmpty()) {
            return Collections.emptyList();
        }
        Catalog fauxCatalog = this.selectFauxCatalog(catalogs);
        return fauxCatalog == null ? catalogs : Collections.emptyList();
    }

    @Override
    public List<Schema> getSchemas() {
        List<Catalog> catalogs = this.getCatalogs_();
        if (catalogs == null || catalogs.isEmpty()) {
            return this.getSchemas_();
        }
        Catalog fauxCatalog = this.selectFauxCatalog(catalogs);
        return fauxCatalog != null ? this.getSchemas(fauxCatalog) : Collections.emptyList();
    }

    private List<Schema> getSchemas(Catalog catalog) {
        return catalog.getSchemas();
    }

    private Catalog selectFauxCatalog(List<Catalog> catalogs) {
        Catalog catalog;
        if (catalogs.size() == 1 && (catalog = catalogs.get(0)).getName().equals("")) {
            return catalog;
        }
        return null;
    }

    private List<Catalog> getCatalogs_() {
        return this.database.getCatalogs();
    }

    private List<Schema> getSchemas_() {
        return this.database.getSchemas();
    }
}

