/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.actions.AbstractNodeActionManager;
import org.eclipse.wst.xml.ui.internal.actions.NodeAction;
import org.eclipse.wst.xml.ui.internal.dialogs.EditProcessingInstructionDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class EditProcessingInstructionAction
extends NodeAction {
    protected Node childRef;
    protected AbstractNodeActionManager manager;
    protected Node parent;
    protected ProcessingInstruction pi;
    protected String title;

    public EditProcessingInstructionAction(AbstractNodeActionManager manager, Node parent, Node childRef, String actionLabel, String title) {
        this.setText(actionLabel);
        this.manager = manager;
        this.parent = parent;
        this.childRef = childRef;
        this.title = title;
    }

    public EditProcessingInstructionAction(AbstractNodeActionManager manager, ProcessingInstruction pi, String actionLabel, String title) {
        this.setText(actionLabel);
        this.manager = manager;
        this.pi = pi;
        this.parent = pi.getParentNode();
        this.title = title;
    }

    public String getUndoDescription() {
        return this.title;
    }

    public void run() {
        Shell shell = XMLUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
        if (this.validateEdit(this.manager.getModel(), shell)) {
            this.manager.beginNodeAction(this);
            EditProcessingInstructionDialog dialog = null;
            dialog = this.pi != null ? new EditProcessingInstructionDialog(shell, this.pi) : new EditProcessingInstructionDialog(shell, XMLUIMessages._UI_PI_TARGET_VALUE, XMLUIMessages._UI_PI_DATA_VALUE);
            dialog.create();
            dialog.getShell().setText(this.title);
            dialog.setBlockOnOpen(true);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                if (this.pi != null) {
                    this.childRef = this.pi;
                }
                Document document = this.parent.getNodeType() == 9 ? (Document)this.parent : this.parent.getOwnerDocument();
                ProcessingInstruction newNode = document.createProcessingInstruction(dialog.getTarget(), dialog.getData());
                this.parent.insertBefore(newNode, this.childRef);
                if (this.pi != null) {
                    this.parent.removeChild(this.pi);
                }
                this.manager.reformat(newNode, false);
                this.manager.setViewerSelection(newNode);
            }
            this.manager.endNodeAction(this);
        }
    }
}

