/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinTable;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualJoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualRelationship;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaVirtualReferenceTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaVirtualJoinTable
extends AbstractJavaVirtualReferenceTable<JoinTable>
implements JavaVirtualJoinTable {
    protected final JoinTable overriddenTable;
    protected final Vector<JavaVirtualJoinColumn> specifiedInverseJoinColumns = new Vector();
    protected final SpecifiedInverseJoinColumnContainerAdapter specifiedInverseJoinColumnContainerAdapter = new SpecifiedInverseJoinColumnContainerAdapter();
    protected final ReadOnlyJoinColumn.Owner inverseJoinColumnOwner;
    protected JavaVirtualJoinColumn defaultInverseJoinColumn;

    public GenericJavaVirtualJoinTable(JavaVirtualJoinTableRelationshipStrategy parent, JoinTable overriddenTable) {
        super(parent);
        this.overriddenTable = overriddenTable;
        this.inverseJoinColumnOwner = this.buildInverseJoinColumnOwner();
    }

    @Override
    public void update() {
        super.update();
        this.updateSpecifiedInverseJoinColumns();
        this.updateDefaultInverseJoinColumn();
    }

    @Override
    public JoinTable getOverriddenTable() {
        return this.overriddenTable;
    }

    @Override
    public ListIterator<JavaVirtualJoinColumn> inverseJoinColumns() {
        return this.getInverseJoinColumns().iterator();
    }

    protected ListIterable<JavaVirtualJoinColumn> getInverseJoinColumns() {
        return this.hasSpecifiedInverseJoinColumns() ? this.getSpecifiedInverseJoinColumns() : this.getDefaultInverseJoinColumns();
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.hasSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumnsSize() : this.getDefaultInverseJoinColumnsSize();
    }

    @Override
    public ListIterator<JavaVirtualJoinColumn> specifiedInverseJoinColumns() {
        return this.getSpecifiedInverseJoinColumns().iterator();
    }

    protected ListIterable<JavaVirtualJoinColumn> getSpecifiedInverseJoinColumns() {
        return new LiveCloneListIterable(this.specifiedInverseJoinColumns);
    }

    @Override
    public int specifiedInverseJoinColumnsSize() {
        return this.specifiedInverseJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedInverseJoinColumns() {
        return this.specifiedInverseJoinColumns.size() != 0;
    }

    @Override
    public JavaVirtualJoinColumn getSpecifiedInverseJoinColumn(int index) {
        return this.specifiedInverseJoinColumns.get(index);
    }

    protected void updateSpecifiedInverseJoinColumns() {
        ContextContainerTools.update(this.specifiedInverseJoinColumnContainerAdapter);
    }

    protected Iterable<JoinColumn> getOverriddenInverseJoinColumns() {
        return CollectionTools.iterable(this.getOverriddenTable().specifiedInverseJoinColumns());
    }

    protected void moveSpecifiedInverseJoinColumn(int index, JavaVirtualJoinColumn joinColumn) {
        this.moveItemInList(index, joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
    }

    protected JavaVirtualJoinColumn addSpecifiedInverseJoinColumn(int index, JoinColumn joinColumn) {
        JavaVirtualJoinColumn virtualJoinColumn = this.buildInverseJoinColumn(joinColumn);
        this.addItemToList(index, virtualJoinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
        return virtualJoinColumn;
    }

    protected void removeSpecifiedInverseJoinColumn(JavaVirtualJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
    }

    @Override
    public JavaVirtualJoinColumn getDefaultInverseJoinColumn() {
        return this.defaultInverseJoinColumn;
    }

    protected void setDefaultInverseJoinColumn(JavaVirtualJoinColumn joinColumn) {
        JavaVirtualJoinColumn old = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = joinColumn;
        this.firePropertyChanged("defaultInverseJoinColumn", old, joinColumn);
    }

    protected ListIterable<JavaVirtualJoinColumn> getDefaultInverseJoinColumns() {
        return this.defaultInverseJoinColumn != null ? new SingleElementListIterable((Object)this.defaultInverseJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultInverseJoinColumnsSize() {
        return this.defaultInverseJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultInverseJoinColumn() {
        if (this.buildsDefaultInverseJoinColumn()) {
            if (this.defaultInverseJoinColumn == null) {
                this.setDefaultInverseJoinColumn(this.buildInverseJoinColumn(this.getOverriddenTable().getDefaultInverseJoinColumn()));
            } else {
                this.defaultInverseJoinColumn.update();
            }
        } else {
            this.setDefaultInverseJoinColumn(null);
        }
    }

    protected boolean buildsDefaultInverseJoinColumn() {
        return !this.hasSpecifiedInverseJoinColumns();
    }

    @Override
    public JavaVirtualJoinTableRelationshipStrategy getParent() {
        return (JavaVirtualJoinTableRelationshipStrategy)super.getParent();
    }

    protected JavaVirtualJoinTableRelationshipStrategy getJoinStrategy() {
        return this.getParent();
    }

    @Override
    protected ReadOnlyJoinColumn.Owner buildJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    protected ReadOnlyJoinColumn.Owner buildInverseJoinColumnOwner() {
        return new InverseJoinColumnOwner();
    }

    protected JavaVirtualJoinColumn buildInverseJoinColumn(JoinColumn joinColumn) {
        return this.buildJoinColumn(this.inverseJoinColumnOwner, joinColumn);
    }

    @Override
    protected String buildDefaultName() {
        return this.getJoinStrategy().getJoinTableDefaultName();
    }

    @Override
    public RelationshipMapping getRelationshipMapping() {
        return this.getJoinStrategy().getRelationship().getMapping();
    }

    @Override
    public PersistentAttribute getPersistentAttribute() {
        return this.getRelationshipMapping().getPersistentAttribute();
    }

    protected abstract class AbstractJoinColumnOwner
    implements ReadOnlyJoinColumn.Owner {
        protected AbstractJoinColumnOwner() {
        }

        public TypeMapping getTypeMapping() {
            return this.getRelationship().getTypeMapping();
        }

        public String getDefaultTableName() {
            return GenericJavaVirtualJoinTable.this.getName();
        }

        public String getDefaultColumnName() {
            throw new UnsupportedOperationException();
        }

        protected JavaVirtualRelationship getRelationship() {
            return GenericJavaVirtualJoinTable.this.getJoinStrategy().getRelationship();
        }
    }

    protected class InverseJoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected InverseJoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            RelationshipMapping relationshipMapping = GenericJavaVirtualJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            RelationshipMapping relationshipMapping = GenericJavaVirtualJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getName();
        }

        public boolean joinColumnIsDefault(ReadOnlyBaseJoinColumn joinColumn) {
            return GenericJavaVirtualJoinTable.this.defaultInverseJoinColumn == joinColumn;
        }

        public int joinColumnsSize() {
            return GenericJavaVirtualJoinTable.this.inverseJoinColumnsSize();
        }
    }

    protected class JoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected JoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            return this.getRelationship().getEntity();
        }

        public String getAttributeName() {
            return MappingTools.getTargetAttributeName(GenericJavaVirtualJoinTable.this.getRelationshipMapping());
        }

        public boolean joinColumnIsDefault(ReadOnlyBaseJoinColumn joinColumn) {
            return GenericJavaVirtualJoinTable.this.defaultJoinColumn == joinColumn;
        }

        public int joinColumnsSize() {
            return GenericJavaVirtualJoinTable.this.joinColumnsSize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedInverseJoinColumnContainerAdapter
    implements ContextContainerTools.Adapter<JavaVirtualJoinColumn, JoinColumn> {
        protected SpecifiedInverseJoinColumnContainerAdapter() {
        }

        @Override
        public Iterable<JavaVirtualJoinColumn> getContextElements() {
            return GenericJavaVirtualJoinTable.this.getSpecifiedInverseJoinColumns();
        }

        @Override
        public Iterable<JoinColumn> getResourceElements() {
            return GenericJavaVirtualJoinTable.this.getOverriddenInverseJoinColumns();
        }

        @Override
        public JoinColumn getResourceElement(JavaVirtualJoinColumn contextElement) {
            return contextElement.getOverriddenColumn();
        }

        @Override
        public void moveContextElement(int index, JavaVirtualJoinColumn element) {
            GenericJavaVirtualJoinTable.this.moveSpecifiedInverseJoinColumn(index, element);
        }

        @Override
        public void addContextElement(int index, JoinColumn element) {
            GenericJavaVirtualJoinTable.this.addSpecifiedInverseJoinColumn(index, element);
        }

        @Override
        public void removeContextElement(JavaVirtualJoinColumn element) {
            GenericJavaVirtualJoinTable.this.removeSpecifiedInverseJoinColumn(element);
        }
    }
}

