/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.NotNullFilter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.common.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.common.utility.internal.iterators.SubIteratorWrapper;
import org.eclipse.jpt.common.utility.internal.iterators.SuperIteratorWrapper;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.jpa.core.JpaPlatformVariation;
import org.eclipse.jpt.jpa.core.context.AssociationOverride;
import org.eclipse.jpt.jpa.core.context.AssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BaseColumn;
import org.eclipse.jpt.jpa.core.context.BaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.DiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.DiscriminatorType;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinTable;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.OverrideContainer;
import org.eclipse.jpt.jpa.core.context.Override_;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.Relationship;
import org.eclipse.jpt.jpa.core.context.SecondaryTable;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaBaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaIdClassReference;
import org.eclipse.jpt.jpa.core.context.java.JavaNamedColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaQueryContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaSecondaryTable;
import org.eclipse.jpt.jpa.core.context.java.JavaTable;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.BaseColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.BaseJoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.EntityTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.JoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.OverrideTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.PrimaryKeyTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.TableTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.java.GenericJavaIdClassReference;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaEntityTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AbstractNamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideInverseJoinColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideJoinColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideJoinTableValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AttributeOverrideColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AttributeOverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.DiscriminatorColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityPrimaryKeyJoinColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.GenericEntityPrimaryKeyValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.JoinTableTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.MappedSuperclassOverrideDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.OverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.SecondaryTableValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.TableValidator;
import org.eclipse.jpt.jpa.core.internal.resource.java.NullPrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.SingleRelationshipMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaCacheableHolder2_0;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorValueAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.InheritanceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.NestablePrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.NestableSecondaryTableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaEntity
extends AbstractJavaTypeMapping<EntityAnnotation>
implements JavaEntity,
JavaCacheableHolder2_0,
JavaGeneratorContainer.Owner,
JavaQueryContainer.Owner {
    protected String specifiedName;
    protected String defaultName;
    protected Entity rootEntity;
    protected final Vector<Entity> descendants = new Vector();
    protected final JavaIdClassReference idClassReference;
    protected final JavaTable table;
    protected boolean specifiedTableIsAllowed;
    protected boolean tableIsUndefined;
    protected final Vector<JavaSecondaryTable> specifiedSecondaryTables = new Vector();
    protected final SpecifiedSecondaryTableContainerAdapter specifiedSecondaryTableContainerAdapter = new SpecifiedSecondaryTableContainerAdapter();
    protected final Table.Owner specifiedSecondaryTableOwner;
    protected final PrimaryKeyJoinColumnOwner primaryKeyJoinColumnOwner;
    protected final Vector<JavaPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns = new Vector();
    protected final SpecifiedPrimaryKeyJoinColumnContainerAdapter specifiedPrimaryKeyJoinColumnContainerAdapter = new SpecifiedPrimaryKeyJoinColumnContainerAdapter();
    protected JavaPrimaryKeyJoinColumn defaultPrimaryKeyJoinColumn;
    protected InheritanceType specifiedInheritanceStrategy;
    protected InheritanceType defaultInheritanceStrategy;
    protected String specifiedDiscriminatorValue;
    protected String defaultDiscriminatorValue;
    protected boolean specifiedDiscriminatorValueIsAllowed;
    protected boolean discriminatorValueIsUndefined;
    protected final JavaDiscriminatorColumn discriminatorColumn;
    protected boolean specifiedDiscriminatorColumnIsAllowed;
    protected boolean discriminatorColumnIsUndefined;
    protected final JavaAttributeOverrideContainer attributeOverrideContainer;
    protected final JavaAssociationOverrideContainer associationOverrideContainer;
    protected final JavaGeneratorContainer generatorContainer;
    protected final JavaQueryContainer queryContainer;

    protected AbstractJavaEntity(JavaPersistentType parent, EntityAnnotation mappingAnnotation) {
        super(parent, mappingAnnotation);
        this.specifiedName = ((EntityAnnotation)this.mappingAnnotation).getName();
        this.idClassReference = this.buildIdClassReference();
        this.table = this.buildTable();
        this.specifiedSecondaryTableOwner = this.buildSpecifiedSecondaryTableOwner();
        this.initializeSpecifiedSecondaryTables();
        this.primaryKeyJoinColumnOwner = this.buildPrimaryKeyJoinColumnOwner();
        this.initializeSpecifiedPrimaryKeyJoinColumns();
        this.specifiedInheritanceStrategy = this.buildSpecifiedInheritanceStrategy();
        this.specifiedDiscriminatorValue = this.getDiscriminatorValueAnnotation().getValue();
        this.discriminatorColumn = this.buildDiscriminatorColumn();
        this.rootEntity = this;
        this.attributeOverrideContainer = this.buildAttributeOverrideContainer();
        this.associationOverrideContainer = this.buildAssociationOverrideContainer();
        this.generatorContainer = this.buildGeneratorContainer();
        this.queryContainer = this.buildQueryContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(((EntityAnnotation)this.mappingAnnotation).getName());
        this.idClassReference.synchronizeWithResourceModel();
        this.table.synchronizeWithResourceModel();
        this.syncSpecifiedSecondaryTables();
        this.syncSpecifiedPrimaryKeyJoinColumns();
        this.setSpecifiedInheritanceStrategy_(this.buildSpecifiedInheritanceStrategy());
        this.setSpecifiedDiscriminatorValue_(this.getDiscriminatorValueAnnotation().getValue());
        this.discriminatorColumn.synchronizeWithResourceModel();
        this.attributeOverrideContainer.synchronizeWithResourceModel();
        this.associationOverrideContainer.synchronizeWithResourceModel();
        this.generatorContainer.synchronizeWithResourceModel();
        this.queryContainer.synchronizeWithResourceModel();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultName(this.buildDefaultName());
        this.setRootEntity(this.buildRootEntity());
        this.updateDescendants();
        this.idClassReference.update();
        this.table.update();
        this.setSpecifiedTableIsAllowed(this.buildSpecifiedTableIsAllowed());
        this.setTableIsUndefined(this.buildTableIsUndefined());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSecondaryTables());
        this.updateDefaultPrimaryKeyJoinColumn();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getPrimaryKeyJoinColumns());
        this.setDefaultInheritanceStrategy(this.buildDefaultInheritanceStrategy());
        this.setDefaultDiscriminatorValue(this.buildDefaultDiscriminatorValue());
        this.setSpecifiedDiscriminatorValueIsAllowed(this.buildSpecifiedDiscriminatorValueIsAllowed());
        this.setDiscriminatorValueIsUndefined(this.buildDiscriminatorValueIsUndefined());
        this.discriminatorColumn.update();
        this.setSpecifiedDiscriminatorColumnIsAllowed(this.buildSpecifiedDiscriminatorColumnIsAllowed());
        this.setDiscriminatorColumnIsUndefined(this.buildDiscriminatorColumnIsUndefined());
        this.attributeOverrideContainer.update();
        this.associationOverrideContainer.update();
        this.generatorContainer.update();
        this.queryContainer.update();
    }

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        ((EntityAnnotation)this.mappingAnnotation).setName(name);
        this.setSpecifiedName_(name);
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected String buildDefaultName() {
        return this.getResourcePersistentType().getName();
    }

    @Override
    public Entity getRootEntity() {
        return this.rootEntity;
    }

    protected void setRootEntity(Entity entity) {
        Entity old = this.rootEntity;
        this.rootEntity = entity;
        this.firePropertyChanged("rootEntity", old, entity);
    }

    protected Entity buildRootEntity() {
        Entity root = this;
        for (TypeMapping typeMapping : this.getAncestors()) {
            if (!(typeMapping instanceof Entity)) continue;
            root = (Entity)typeMapping;
        }
        return root;
    }

    @Override
    public Iterable<Entity> getDescendants() {
        return new LiveCloneListIterable(this.descendants);
    }

    protected void updateDescendants() {
        this.synchronizeCollection(this.buildDescendants(), this.descendants, "descendants");
    }

    protected Iterable<Entity> buildDescendants() {
        return new FilteringIterable<Entity>(this.getPersistenceUnit().getEntities()){

            protected boolean accept(Entity entity) {
                return AbstractJavaEntity.this.entityIsDescendant(entity);
            }
        };
    }

    protected boolean entityIsDescendant(Entity entity) {
        String typeName = this.getPersistentType().getName();
        String entityTypeName = entity.getPersistentType().getName();
        String rootEntityTypeName = entity.getRootEntity().getPersistentType().getName();
        return Tools.valuesAreDifferent((Object)typeName, (Object)entityTypeName) && Tools.valuesAreEqual((Object)typeName, (Object)rootEntityTypeName);
    }

    @Override
    public JavaIdClassReference getIdClassReference() {
        return this.idClassReference;
    }

    protected JavaIdClassReference buildIdClassReference() {
        return new GenericJavaIdClassReference(this);
    }

    @Override
    public JavaPersistentType getIdClass() {
        return this.idClassReference.getIdClass();
    }

    @Override
    public JavaTable getTable() {
        return this.table;
    }

    protected JavaTable buildTable() {
        return this.getJpaFactory().buildJavaTable(this, this.buildTableOwner());
    }

    protected Table.Owner buildTableOwner() {
        return new TableOwner();
    }

    @Override
    public boolean specifiedTableIsAllowed() {
        return this.specifiedTableIsAllowed;
    }

    protected void setSpecifiedTableIsAllowed(boolean specifiedTableIsAllowed) {
        boolean old = this.specifiedTableIsAllowed;
        this.specifiedTableIsAllowed = specifiedTableIsAllowed;
        this.firePropertyChanged("specifiedTableIsAllowed", old, specifiedTableIsAllowed);
    }

    protected boolean buildSpecifiedTableIsAllowed() {
        return !this.isAbstractTablePerClass() && !this.isSingleTableDescendant();
    }

    @Override
    public boolean tableIsUndefined() {
        return this.tableIsUndefined;
    }

    protected void setTableIsUndefined(boolean tableIsUndefined) {
        boolean old = this.tableIsUndefined;
        this.tableIsUndefined = tableIsUndefined;
        this.firePropertyChanged("tableIsUndefined", old, tableIsUndefined);
    }

    protected boolean buildTableIsUndefined() {
        return this.isAbstractTablePerClass();
    }

    @Override
    public String getDefaultTableName() {
        return this.isSingleTableDescendant() ? this.rootEntity.getTable().getName() : (this.isAbstractTablePerClass() ? null : this.getName());
    }

    @Override
    public String getDefaultSchema() {
        return this.isSingleTableDescendant() ? this.rootEntity.getTable().getSchema() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultSchema());
    }

    @Override
    public String getDefaultCatalog() {
        return this.isSingleTableDescendant() ? this.rootEntity.getTable().getCatalog() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultCatalog());
    }

    @Override
    public ListIterator<JavaSecondaryTable> secondaryTables() {
        return this.specifiedSecondaryTables();
    }

    protected ListIterable<JavaSecondaryTable> getSecondaryTables() {
        return this.getSpecifiedSecondaryTables();
    }

    @Override
    public int secondaryTablesSize() {
        return this.specifiedSecondaryTablesSize();
    }

    @Override
    public ListIterator<JavaSecondaryTable> specifiedSecondaryTables() {
        return this.getSpecifiedSecondaryTables().iterator();
    }

    protected ListIterable<JavaSecondaryTable> getSpecifiedSecondaryTables() {
        return new LiveCloneListIterable(this.specifiedSecondaryTables);
    }

    @Override
    public int specifiedSecondaryTablesSize() {
        return this.specifiedSecondaryTables.size();
    }

    @Override
    public JavaSecondaryTable addSpecifiedSecondaryTable() {
        return this.addSpecifiedSecondaryTable(this.specifiedSecondaryTables.size());
    }

    @Override
    public JavaSecondaryTable addSpecifiedSecondaryTable(int index) {
        SecondaryTableAnnotation annotation = this.buildSecondaryTableAnnotation(index);
        return this.addSpecifiedSecondaryTable_(index, annotation);
    }

    protected SecondaryTableAnnotation buildSecondaryTableAnnotation(int index) {
        return (SecondaryTableAnnotation)((Object)this.getResourcePersistentType().addAnnotation(index, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"));
    }

    @Override
    public void removeSpecifiedSecondaryTable(SecondaryTable secondaryTable) {
        this.removeSpecifiedSecondaryTable(this.specifiedSecondaryTables.indexOf(secondaryTable));
    }

    @Override
    public void removeSpecifiedSecondaryTable(int index) {
        this.getResourcePersistentType().removeAnnotation(index, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        this.removeSpecifiedSecondaryTable_(index);
    }

    protected void removeSpecifiedSecondaryTable_(int index) {
        this.removeItemFromList(index, this.specifiedSecondaryTables, "specifiedSecondaryTables");
    }

    @Override
    public void moveSpecifiedSecondaryTable(int targetIndex, int sourceIndex) {
        this.getResourceAnnotatedElement().moveAnnotation(targetIndex, sourceIndex, "javax.persistence.SecondaryTables");
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedSecondaryTables, "specifiedSecondaryTables");
    }

    protected void initializeSpecifiedSecondaryTables() {
        for (SecondaryTableAnnotation annotation : this.getSecondaryTableAnnotations()) {
            this.specifiedSecondaryTables.add(this.buildSecondaryTable(annotation));
        }
    }

    protected JavaSecondaryTable buildSecondaryTable(SecondaryTableAnnotation secondaryTableAnnotation) {
        return this.getJpaFactory().buildJavaSecondaryTable(this, this.specifiedSecondaryTableOwner, secondaryTableAnnotation);
    }

    protected void syncSpecifiedSecondaryTables() {
        ContextContainerTools.synchronizeWithResourceModel(this.specifiedSecondaryTableContainerAdapter);
    }

    protected Iterable<SecondaryTableAnnotation> getSecondaryTableAnnotations() {
        return CollectionTools.iterable(this.secondaryTableAnnotations());
    }

    protected Iterator<SecondaryTableAnnotation> secondaryTableAnnotations() {
        return new SuperIteratorWrapper(this.nestableSecondaryTableAnnotations());
    }

    protected Iterator<NestableSecondaryTableAnnotation> nestableSecondaryTableAnnotations() {
        return new SubIteratorWrapper(this.nestableSecondaryTableAnnotations_());
    }

    protected Iterator<NestableAnnotation> nestableSecondaryTableAnnotations_() {
        return this.getResourceAnnotatedElement().annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
    }

    protected void moveSpecifiedSecondaryTable_(int index, JavaSecondaryTable secondaryTable) {
        this.moveItemInList(index, secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTables");
    }

    protected JavaSecondaryTable addSpecifiedSecondaryTable_(int index, SecondaryTableAnnotation secondaryTableAnnotation) {
        JavaSecondaryTable secondaryTable = this.buildSecondaryTable(secondaryTableAnnotation);
        this.addItemToList(index, secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTables");
        return secondaryTable;
    }

    protected void removeSpecifiedSecondaryTable_(JavaSecondaryTable secondaryTable) {
        this.removeSpecifiedSecondaryTable_(this.specifiedSecondaryTables.indexOf(secondaryTable));
    }

    protected Table.Owner buildSpecifiedSecondaryTableOwner() {
        return new SecondaryTableOwner();
    }

    @Override
    public ListIterator<JavaPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return this.getPrimaryKeyJoinColumns().iterator();
    }

    protected ListIterable<JavaPrimaryKeyJoinColumn> getPrimaryKeyJoinColumns() {
        return this.hasSpecifiedPrimaryKeyJoinColumns() ? this.getSpecifiedPrimaryKeyJoinColumns() : this.getDefaultPrimaryKeyJoinColumns();
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.hasSpecifiedPrimaryKeyJoinColumns() ? this.specifiedPrimaryKeyJoinColumnsSize() : this.defaultPrimaryKeyJoinColumnsSize();
    }

    @Override
    public ListIterator<JavaPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns() {
        return this.getSpecifiedPrimaryKeyJoinColumns().iterator();
    }

    protected ListIterable<JavaPrimaryKeyJoinColumn> getSpecifiedPrimaryKeyJoinColumns() {
        return new LiveCloneListIterable(this.specifiedPrimaryKeyJoinColumns);
    }

    @Override
    public int specifiedPrimaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumns.size();
    }

    protected boolean hasSpecifiedPrimaryKeyJoinColumns() {
        return this.specifiedPrimaryKeyJoinColumns.size() != 0;
    }

    @Override
    public JavaPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn() {
        return this.addSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.size());
    }

    @Override
    public JavaPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int index) {
        PrimaryKeyJoinColumnAnnotation annotation = this.buildPrimaryKeyJoinColumnAnnotation(index);
        return this.addSpecifiedPrimaryKeyJoinColumn_(index, annotation);
    }

    protected PrimaryKeyJoinColumnAnnotation buildPrimaryKeyJoinColumnAnnotation(int index) {
        return (PrimaryKeyJoinColumnAnnotation)((Object)this.getResourcePersistentType().addAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns"));
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(PrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.indexOf(primaryKeyJoinColumn));
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(int index) {
        this.getResourcePersistentType().removeAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.removeSpecifiedPrimaryKeyJoinColumn_(index);
    }

    protected void removeSpecifiedPrimaryKeyJoinColumn_(int index) {
        this.removeItemFromList(index, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    @Override
    public void moveSpecifiedPrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        this.getResourcePersistentType().moveAnnotation(targetIndex, sourceIndex, "javax.persistence.PrimaryKeyJoinColumns");
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    protected PrimaryKeyJoinColumnOwner buildPrimaryKeyJoinColumnOwner() {
        return new PrimaryKeyJoinColumnOwner();
    }

    protected void initializeSpecifiedPrimaryKeyJoinColumns() {
        for (PrimaryKeyJoinColumnAnnotation annotation : this.getPrimaryKeyJoinColumnAnnotations()) {
            this.specifiedPrimaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn(annotation));
        }
    }

    protected JavaPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(PrimaryKeyJoinColumnAnnotation primaryKeyJoinColumnAnnotation) {
        return this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.primaryKeyJoinColumnOwner, primaryKeyJoinColumnAnnotation);
    }

    protected void syncSpecifiedPrimaryKeyJoinColumns() {
        ContextContainerTools.synchronizeWithResourceModel(this.specifiedPrimaryKeyJoinColumnContainerAdapter);
    }

    protected Iterable<PrimaryKeyJoinColumnAnnotation> getPrimaryKeyJoinColumnAnnotations() {
        return CollectionTools.iterable(this.primaryKeyJoinColumnAnnotations());
    }

    protected Iterator<PrimaryKeyJoinColumnAnnotation> primaryKeyJoinColumnAnnotations() {
        return new SuperIteratorWrapper(this.nestablePrimaryKeyJoinColumnAnnotations());
    }

    protected Iterator<NestablePrimaryKeyJoinColumnAnnotation> nestablePrimaryKeyJoinColumnAnnotations() {
        return new SubIteratorWrapper(this.nestablePrimaryKeyJoinColumnAnnotations_());
    }

    protected Iterator<NestableAnnotation> nestablePrimaryKeyJoinColumnAnnotations_() {
        return this.getResourceAnnotatedElement().annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
    }

    protected void moveSpecifiedPrimaryKeyJoinColumn_(int index, JavaPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.moveItemInList(index, primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    protected JavaPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn_(int index, PrimaryKeyJoinColumnAnnotation primaryKeyJoinColumnAnnotation) {
        JavaPrimaryKeyJoinColumn primaryKeyJoinColumn = this.buildPrimaryKeyJoinColumn(primaryKeyJoinColumnAnnotation);
        this.addItemToList(index, primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
        return primaryKeyJoinColumn;
    }

    protected void removeSpecifiedPrimaryKeyJoinColumn_(JavaPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn_(this.specifiedPrimaryKeyJoinColumns.indexOf(primaryKeyJoinColumn));
    }

    @Override
    public JavaPrimaryKeyJoinColumn getDefaultPrimaryKeyJoinColumn() {
        return this.defaultPrimaryKeyJoinColumn;
    }

    protected void setDefaultPrimaryKeyJoinColumn(JavaPrimaryKeyJoinColumn pkJoinColumn) {
        JavaPrimaryKeyJoinColumn old = this.defaultPrimaryKeyJoinColumn;
        this.defaultPrimaryKeyJoinColumn = pkJoinColumn;
        this.firePropertyChanged("defaultPrimaryKeyJoinColumn", old, pkJoinColumn);
    }

    protected ListIterable<JavaPrimaryKeyJoinColumn> getDefaultPrimaryKeyJoinColumns() {
        return this.defaultPrimaryKeyJoinColumn != null ? new SingleElementListIterable((Object)this.defaultPrimaryKeyJoinColumn) : EmptyListIterable.instance();
    }

    protected int defaultPrimaryKeyJoinColumnsSize() {
        return this.defaultPrimaryKeyJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultPrimaryKeyJoinColumn() {
        if (this.buildsDefaultPrimaryKeyJoinColumn()) {
            if (this.defaultPrimaryKeyJoinColumn == null) {
                this.setDefaultPrimaryKeyJoinColumn(this.buildDefaultPrimaryKeyJoinColumn());
            } else {
                this.defaultPrimaryKeyJoinColumn.update();
            }
        } else {
            this.setDefaultPrimaryKeyJoinColumn(null);
        }
    }

    protected boolean buildsDefaultPrimaryKeyJoinColumn() {
        return !this.hasSpecifiedPrimaryKeyJoinColumns();
    }

    protected JavaPrimaryKeyJoinColumn buildDefaultPrimaryKeyJoinColumn() {
        return this.buildPrimaryKeyJoinColumn(new NullPrimaryKeyJoinColumnAnnotation(this.getResourcePersistentType()));
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return this.specifiedInheritanceStrategy != null ? this.specifiedInheritanceStrategy : this.defaultInheritanceStrategy;
    }

    @Override
    public InheritanceType getSpecifiedInheritanceStrategy() {
        return this.specifiedInheritanceStrategy;
    }

    @Override
    public void setSpecifiedInheritanceStrategy(InheritanceType inheritanceType) {
        if (this.valuesAreDifferent((Object)this.specifiedInheritanceStrategy, (Object)inheritanceType)) {
            this.getInheritanceAnnotation().setStrategy(InheritanceType.toJavaResourceModel(inheritanceType));
            this.removeInheritanceAnnotationIfUnset();
            this.setSpecifiedInheritanceStrategy_(inheritanceType);
        }
    }

    protected void setSpecifiedInheritanceStrategy_(InheritanceType inheritanceType) {
        InheritanceType old = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = inheritanceType;
        this.firePropertyChanged("specifiedInheritanceStrategy", (Object)old, (Object)inheritanceType);
    }

    protected InheritanceType buildSpecifiedInheritanceStrategy() {
        return InheritanceType.fromJavaResourceModel(this.getInheritanceAnnotation().getStrategy());
    }

    @Override
    public InheritanceType getDefaultInheritanceStrategy() {
        return this.defaultInheritanceStrategy;
    }

    protected void setDefaultInheritanceStrategy(InheritanceType inheritanceType) {
        InheritanceType old = this.defaultInheritanceStrategy;
        this.defaultInheritanceStrategy = inheritanceType;
        this.firePropertyChanged("defaultInheritanceStrategy", (Object)old, (Object)inheritanceType);
    }

    protected InheritanceType buildDefaultInheritanceStrategy() {
        return this.isRoot() ? InheritanceType.SINGLE_TABLE : this.rootEntity.getInheritanceStrategy();
    }

    protected InheritanceAnnotation getInheritanceAnnotation() {
        return (InheritanceAnnotation)this.getResourcePersistentType().getNonNullAnnotation("javax.persistence.Inheritance");
    }

    protected void removeInheritanceAnnotationIfUnset() {
        if (this.getInheritanceAnnotation().isUnset()) {
            this.removeInheritanceAnnotation();
        }
    }

    protected void removeInheritanceAnnotation() {
        this.getResourcePersistentType().removeAnnotation("javax.persistence.Inheritance");
    }

    @Override
    public String getDiscriminatorValue() {
        return this.specifiedDiscriminatorValue != null ? this.specifiedDiscriminatorValue : this.defaultDiscriminatorValue;
    }

    @Override
    public String getSpecifiedDiscriminatorValue() {
        return this.specifiedDiscriminatorValue;
    }

    @Override
    public void setSpecifiedDiscriminatorValue(String discriminatorValue) {
        if (this.valuesAreDifferent(this.specifiedDiscriminatorValue, discriminatorValue)) {
            this.getDiscriminatorValueAnnotation().setValue(discriminatorValue);
            this.removeDiscriminatorValueAnnotationIfUnset();
            this.setSpecifiedDiscriminatorValue_(discriminatorValue);
        }
    }

    protected void setSpecifiedDiscriminatorValue_(String discriminatorValue) {
        String old = this.specifiedDiscriminatorValue;
        this.specifiedDiscriminatorValue = discriminatorValue;
        this.firePropertyChanged("specifiedDiscriminatorValue", old, discriminatorValue);
    }

    @Override
    public String getDefaultDiscriminatorValue() {
        return this.defaultDiscriminatorValue;
    }

    protected void setDefaultDiscriminatorValue(String discriminatorValue) {
        String old = this.defaultDiscriminatorValue;
        this.defaultDiscriminatorValue = discriminatorValue;
        this.firePropertyChanged("defaultDiscriminatorValue", old, discriminatorValue);
    }

    protected String buildDefaultDiscriminatorValue() {
        if (this.discriminatorValueIsUndefined) {
            return null;
        }
        return this.getDiscriminatorType() == DiscriminatorType.STRING ? this.getName() : null;
    }

    protected DiscriminatorType getDiscriminatorType() {
        return this.discriminatorColumn.getDiscriminatorType();
    }

    @Override
    public boolean specifiedDiscriminatorValueIsAllowed() {
        return this.specifiedDiscriminatorValueIsAllowed;
    }

    protected void setSpecifiedDiscriminatorValueIsAllowed(boolean allowed) {
        boolean old = this.specifiedDiscriminatorValueIsAllowed;
        this.specifiedDiscriminatorValueIsAllowed = allowed;
        this.firePropertyChanged("discriminatorValueIsAllowed", old, allowed);
    }

    protected boolean buildSpecifiedDiscriminatorValueIsAllowed() {
        return !this.isTablePerClass() && !this.isAbstract();
    }

    @Override
    public boolean discriminatorValueIsUndefined() {
        return this.discriminatorValueIsUndefined;
    }

    protected void setDiscriminatorValueIsUndefined(boolean undefined) {
        boolean old = this.discriminatorValueIsUndefined;
        this.discriminatorValueIsUndefined = undefined;
        this.firePropertyChanged("discriminatorValueIsUndefined", old, undefined);
    }

    protected boolean buildDiscriminatorValueIsUndefined() {
        return this.isTablePerClass() || this.isAbstract() || this.isRootNoDescendantsNoStrategyDefined();
    }

    protected DiscriminatorValueAnnotation getDiscriminatorValueAnnotation() {
        return (DiscriminatorValueAnnotation)this.getResourcePersistentType().getNonNullAnnotation("javax.persistence.DiscriminatorValue");
    }

    protected void removeDiscriminatorValueAnnotationIfUnset() {
        if (this.getDiscriminatorValueAnnotation().isUnset()) {
            this.removeDiscriminatorValueAnnotation();
        }
    }

    protected void removeDiscriminatorValueAnnotation() {
        this.getResourcePersistentType().removeAnnotation("javax.persistence.DiscriminatorValue");
    }

    @Override
    public JavaDiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    protected JavaDiscriminatorColumn buildDiscriminatorColumn() {
        return this.getJpaFactory().buildJavaDiscriminatorColumn(this, this.buildDiscriminatorColumnOwner());
    }

    protected JavaDiscriminatorColumn.Owner buildDiscriminatorColumnOwner() {
        return new DiscriminatorColumnOwner();
    }

    @Override
    public boolean specifiedDiscriminatorColumnIsAllowed() {
        return this.specifiedDiscriminatorColumnIsAllowed;
    }

    protected void setSpecifiedDiscriminatorColumnIsAllowed(boolean allowed) {
        boolean old = this.specifiedDiscriminatorColumnIsAllowed;
        this.specifiedDiscriminatorColumnIsAllowed = allowed;
        this.firePropertyChanged("specifiedDiscriminatorColumnIsAllowed", old, allowed);
    }

    protected boolean buildSpecifiedDiscriminatorColumnIsAllowed() {
        return !this.isTablePerClass() && this.isRoot();
    }

    @Override
    public boolean discriminatorColumnIsUndefined() {
        return this.discriminatorColumnIsUndefined;
    }

    protected void setDiscriminatorColumnIsUndefined(boolean undefined) {
        boolean old = this.discriminatorColumnIsUndefined;
        this.discriminatorColumnIsUndefined = undefined;
        this.firePropertyChanged("discriminatorColumnIsUndefined", old, undefined);
    }

    protected boolean buildDiscriminatorColumnIsUndefined() {
        return this.isTablePerClass() || this.isRootNoDescendantsNoStrategyDefined();
    }

    @Override
    public JavaAttributeOverrideContainer getAttributeOverrideContainer() {
        return this.attributeOverrideContainer;
    }

    protected JavaAttributeOverrideContainer buildAttributeOverrideContainer() {
        return this.getJpaFactory().buildJavaAttributeOverrideContainer(this, new AttributeOverrideContainerOwner());
    }

    public TypeMapping getOverridableTypeMapping() {
        PersistentType superPersistentType = this.getPersistentType().getSuperPersistentType();
        return superPersistentType == null ? null : superPersistentType.getMapping();
    }

    @Override
    public JavaAssociationOverrideContainer getAssociationOverrideContainer() {
        return this.associationOverrideContainer;
    }

    protected JavaAssociationOverrideContainer buildAssociationOverrideContainer() {
        return this.getJpaFactory().buildJavaAssociationOverrideContainer(this, new AssociationOverrideContainerOwner());
    }

    @Override
    public Relationship resolveOverriddenRelationship(String attributeName) {
        JavaAssociationOverride override = this.associationOverrideContainer.getSpecifiedOverrideNamed(attributeName);
        return override != null ? override.getRelationship() : super.resolveOverriddenRelationship(attributeName);
    }

    @Override
    public JavaGeneratorContainer getGeneratorContainer() {
        return this.generatorContainer;
    }

    protected JavaGeneratorContainer buildGeneratorContainer() {
        return this.getJpaFactory().buildJavaGeneratorContainer(this, this);
    }

    @Override
    public JavaResourcePersistentMember getResourceAnnotatedElement() {
        return this.getResourcePersistentType();
    }

    @Override
    public JavaQueryContainer getQueryContainer() {
        return this.queryContainer;
    }

    protected JavaQueryContainer buildQueryContainer() {
        return this.getJpaFactory().buildJavaQueryContainer(this, this);
    }

    @Override
    public Iterator<ReadOnlyTable> associatedTables() {
        return this.getAssociatedTables().iterator();
    }

    public Iterable<ReadOnlyTable> getAssociatedTables() {
        return new CompositeIterable((Object)this.table, this.getSecondaryTables());
    }

    @Override
    public Iterator<ReadOnlyTable> allAssociatedTables() {
        return new CompositeIterator(this.allAssociatedTablesLists());
    }

    public Iterable<ReadOnlyTable> getAllAssociatedTables() {
        return CollectionTools.iterable(this.allAssociatedTables());
    }

    protected Iterator<Iterator<ReadOnlyTable>> allAssociatedTablesLists() {
        return new TransformationIterator(this.inheritanceHierarchy(), TypeMappingTools.ASSOCIATED_TABLES_TRANSFORMER);
    }

    @Override
    public Iterator<String> allAssociatedTableNames() {
        return this.getAllAssociatedTableNames().iterator();
    }

    public Iterable<String> getAllAssociatedTableNames() {
        return this.convertToNames(this.getAllAssociatedTables());
    }

    protected Iterable<String> convertToNames(Iterable<ReadOnlyTable> tables) {
        return new FilteringIterable(this.convertToNames_(tables), NotNullFilter.instance());
    }

    protected Iterable<String> convertToNames_(Iterable<ReadOnlyTable> tables) {
        return new TransformationIterable<ReadOnlyTable, String>(tables){

            protected String transform(ReadOnlyTable t) {
                return t.getName();
            }
        };
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return !this.tableNameIsValid(tableName);
    }

    protected boolean tableNameIsValid(String tableName) {
        return this.tableIsUndefined || CollectionTools.contains(this.getAllAssociatedTableNames(), (Object)tableName);
    }

    @Override
    public String getPrimaryTableName() {
        return this.table.getName();
    }

    @Override
    public org.eclipse.jpt.jpa.db.Table getPrimaryDbTable() {
        return this.table.getDbTable();
    }

    @Override
    public org.eclipse.jpt.jpa.db.Table resolveDbTable(String tableName) {
        return this.getDataSource().selectTableForIdentifier(this.getAllAssociatedDbTables(), tableName);
    }

    protected Iterable<org.eclipse.jpt.jpa.db.Table> getAllAssociatedDbTables() {
        return new FilteringIterable(this.getAllAssociatedDbTables_(), NotNullFilter.instance());
    }

    protected Iterable<org.eclipse.jpt.jpa.db.Table> getAllAssociatedDbTables_() {
        return new TransformationIterable<ReadOnlyTable, org.eclipse.jpt.jpa.db.Table>(this.getAllAssociatedTables()){

            protected org.eclipse.jpt.jpa.db.Table transform(ReadOnlyTable entityTable) {
                return entityTable.getDbTable();
            }
        };
    }

    @Override
    public Schema getDbSchema() {
        return this.table.getDbSchema();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return MappingTools.getPrimaryKeyColumnName(this);
    }

    @Override
    public PersistentAttribute getIdAttribute() {
        Iterator<AttributeMapping> idAttributeMappings = this.getAllAttributeMappings("id").iterator();
        if (idAttributeMappings.hasNext()) {
            PersistentAttribute attribute = idAttributeMappings.next().getPersistentAttribute();
            return idAttributeMappings.hasNext() ? null : attribute;
        }
        return null;
    }

    @Override
    public String getKey() {
        return "entity";
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public JavaResourcePersistentType getResourcePersistentType() {
        return super.getResourcePersistentType();
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        JavaAttributeOverride override = this.attributeOverrideContainer.getSpecifiedOverrideNamed(attributeName);
        return override != null ? override.getColumn() : super.resolveOverriddenColumn(attributeName);
    }

    @Override
    public Iterator<String> overridableAttributeNames() {
        return this.isTablePerClass() ? super.overridableAttributeNames() : EmptyIterator.instance();
    }

    @Override
    public Iterator<String> overridableAssociationNames() {
        return this.isTablePerClass() ? super.overridableAssociationNames() : EmptyIterator.instance();
    }

    @Override
    public AttributeMapping resolveAttributeMapping(String name) {
        for (AttributeMapping attributeMapping : CollectionTools.iterable(this.allAttributeMappings())) {
            AttributeMapping resolvedMapping = attributeMapping.resolveAttributeMapping(name);
            if (resolvedMapping == null) continue;
            return resolvedMapping;
        }
        return null;
    }

    @Override
    public Entity getParentEntity() {
        for (TypeMapping typeMapping : this.getAncestors()) {
            if (!(typeMapping instanceof Entity)) continue;
            return (Entity)typeMapping;
        }
        return null;
    }

    @Override
    public boolean isRoot() {
        return this == this.rootEntity;
    }

    protected boolean isDescendant() {
        return !this.isRoot();
    }

    protected boolean isSingleTableDescendant() {
        return this.isDescendant() && this.getInheritanceStrategy() == InheritanceType.SINGLE_TABLE;
    }

    protected boolean isRootNoDescendantsNoStrategyDefined() {
        return this.isRoot() && this.descendants.isEmpty() && this.specifiedInheritanceStrategy == null;
    }

    protected boolean isAbstractTablePerClass() {
        return this.isAbstract() && this.isTablePerClass();
    }

    protected boolean isTablePerClass() {
        return this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS;
    }

    protected boolean isTablePerClassDescendant() {
        return this.isTablePerClass() && this.isDescendant();
    }

    protected boolean isAbstract() {
        return this.getResourcePersistentType().isAbstract();
    }

    protected boolean isFinal() {
        return this.getResourcePersistentType().isFinal();
    }

    protected boolean isMember() {
        return this.getResourcePersistentType().isMemberType();
    }

    protected boolean isStatic() {
        return this.getResourcePersistentType().isStatic();
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.table.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaSecondaryTable secondaryTable : CollectionTools.iterable(this.secondaryTables())) {
            result = secondaryTable.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        for (JavaPrimaryKeyJoinColumn pkJoinColumn : CollectionTools.iterable(this.primaryKeyJoinColumns())) {
            result = pkJoinColumn.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        result = this.attributeOverrideContainer.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.associationOverrideContainer.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.discriminatorColumn.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.generatorContainer.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validatePrimaryKey(messages, reporter, astRoot);
        this.validateTable(messages, reporter, astRoot);
        for (JavaSecondaryTable secondaryTable : this.getSecondaryTables()) {
            secondaryTable.validate(messages, reporter, astRoot);
        }
        this.validateInheritance(messages, reporter, astRoot);
        for (JavaPrimaryKeyJoinColumn pkJoinColumn : this.getPrimaryKeyJoinColumns()) {
            pkJoinColumn.validate(messages, reporter, astRoot);
        }
        this.generatorContainer.validate(messages, reporter, astRoot);
        this.queryContainer.validate(messages, reporter, astRoot);
        this.attributeOverrideContainer.validate(messages, reporter, astRoot);
        this.associationOverrideContainer.validate(messages, reporter, astRoot);
        this.validateEntityName(messages, astRoot);
        this.validateDuplicateEntityNames(messages, astRoot);
        this.idClassReference.validate(messages, reporter, astRoot);
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return super.validatesAgainstDatabase() && !this.isAbstractTablePerClass();
    }

    protected void validateEntityName(List<IMessage> messages, CompilationUnit astRoot) {
        if (StringTools.stringIsEmpty((String)this.getName())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NAME_MISSING", new String[]{this.getPersistentType().getName()}, this, ((EntityAnnotation)this.getMappingAnnotation()).getNameTextRange(astRoot)));
        }
    }

    protected void validateDuplicateEntityNames(List<IMessage> messages, CompilationUnit astRoot) {
        HashBag javaEntityNamesExclOverridden = new HashBag();
        CollectionTools.addAll((Collection)javaEntityNamesExclOverridden, this.getPersistenceUnit().javaEntityNamesExclOverridden());
        HashBag ormEntityNames = new HashBag();
        CollectionTools.addAll((Collection)ormEntityNames, this.getPersistenceUnit().ormEntityNames());
        String javaEntityName = this.getName();
        if (javaEntityName != null && (javaEntityNamesExclOverridden.count((Object)javaEntityName) > 1 || ormEntityNames.contains((Object)javaEntityName))) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NAME_DUPLICATED", new String[]{javaEntityName}, this, ((EntityAnnotation)this.getMappingAnnotation()).getNameTextRange(astRoot)));
        }
    }

    protected void validatePrimaryKey(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.buildPrimaryKeyValidator(astRoot).validate(messages, reporter);
    }

    protected JptValidator buildPrimaryKeyValidator(CompilationUnit astRoot) {
        return new GenericEntityPrimaryKeyValidator(this, (PrimaryKeyTextRangeResolver)this.buildTextRangeResolver(astRoot));
    }

    @Override
    protected EntityTextRangeResolver buildTextRangeResolver(CompilationUnit astRoot) {
        return new JavaEntityTextRangeResolver(this, astRoot);
    }

    protected void validateTable(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.isAbstractTablePerClass()) {
            if (this.table.isSpecifiedInResource()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_ABSTRACT_TABLE_PER_CLASS_DEFINES_TABLE", new String[]{this.getName()}, this, this.table.getValidationTextRange(astRoot)));
            }
            return;
        }
        if (this.isSingleTableDescendant() && this.getDataSource().connectionProfileIsActive()) {
            if (this.specifiedTableDoesNotMatchRootTable()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_SINGLE_TABLE_DESCENDANT_DEFINES_TABLE", new String[]{this.getName()}, this, this.table.getValidationTextRange(astRoot)));
            }
            return;
        }
        this.table.validate(messages, reporter, astRoot);
    }

    protected boolean specifiedTableDoesNotMatchRootTable() {
        return this.table.isSpecifiedInResource() && this.table.getDbTable() != this.getRootEntity().getTable().getDbTable();
    }

    protected void validateInheritance(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.validateInheritanceStrategy(messages, astRoot);
        this.validateDiscriminatorColumn(messages, reporter, astRoot);
        this.validateDiscriminatorValue(messages, astRoot);
    }

    protected void validateDiscriminatorColumn(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.specifiedDiscriminatorColumnIsAllowed && !this.discriminatorColumnIsUndefined) {
            this.discriminatorColumn.validate(messages, reporter, astRoot);
        } else if (this.discriminatorColumn.isResourceSpecified()) {
            if (this.isDescendant()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NON_ROOT_DISCRIMINATOR_COLUMN_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorColumnTextRange(astRoot)));
            } else if (this.isTablePerClass()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_COLUMN_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorColumnTextRange(astRoot)));
            }
        }
    }

    protected void validateDiscriminatorValue(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.discriminatorValueIsUndefined && this.specifiedDiscriminatorValue != null) {
            if (this.isAbstract()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_ABSTRACT_DISCRIMINATOR_VALUE_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorValueTextRange(astRoot)));
            } else if (this.isTablePerClass()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_VALUE_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorValueTextRange(astRoot)));
            }
        }
    }

    protected void validateInheritanceStrategy(List<IMessage> messages, CompilationUnit astRoot) {
        JpaPlatformVariation.Supported tablePerConcreteClassInheritanceIsSupported = this.getJpaPlatformVariation().getTablePerConcreteClassInheritanceIsSupported();
        if (tablePerConcreteClassInheritanceIsSupported == JpaPlatformVariation.Supported.YES) {
            return;
        }
        if (this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS && this.isRoot()) {
            if (tablePerConcreteClassInheritanceIsSupported == JpaPlatformVariation.Supported.NO) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_TABLE_PER_CLASS_NOT_SUPPORTED_ON_PLATFORM", new String[]{this.getName()}, this, this.getInheritanceStrategyTextRange(astRoot)));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_TABLE_PER_CLASS_NOT_PORTABLE_ON_PLATFORM", new String[]{this.getName()}, this, this.getInheritanceStrategyTextRange(astRoot)));
            }
        }
    }

    protected TextRange getDiscriminatorValueTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getDiscriminatorValueAnnotation().getTextRange(astRoot), astRoot);
    }

    protected TextRange getDiscriminatorColumnTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.discriminatorColumn.getValidationTextRange(astRoot), astRoot);
    }

    protected TextRange getInheritanceStrategyTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getInheritanceAnnotation().getStrategyTextRange(astRoot), astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AssociationOverrideContainerOwner
    extends OverrideContainerOwner
    implements JavaAssociationOverrideContainer.Owner {
        protected AssociationOverrideContainerOwner() {
        }

        @Override
        protected Iterator<String> allOverridableNames_(TypeMapping typeMapping) {
            return typeMapping.allOverridableAssociationNames();
        }

        @Override
        public Relationship resolveOverriddenRelationship(String attributeName) {
            return MappingTools.resolveOverriddenRelationship(this.getOverridableTypeMapping(), attributeName);
        }

        @Override
        public JptValidator buildValidator(Override_ override, OverrideContainer container, OverrideTextRangeResolver textRangeResolver) {
            return new AssociationOverrideValidator((AssociationOverride)override, (AssociationOverrideContainer)container, textRangeResolver, (OverrideValidator.OverrideDescriptionProvider)new MappedSuperclassOverrideDescriptionProvider());
        }

        @Override
        public JptValidator buildColumnValidator(Override_ override, BaseColumn column, BaseColumn.Owner owner, BaseColumnTextRangeResolver textRangeResolver) {
            return new AssociationOverrideJoinColumnValidator((AssociationOverride)override, (JoinColumn)column, (JoinColumn.Owner)owner, (JoinColumnTextRangeResolver)textRangeResolver, (AbstractNamedColumnValidator.TableDescriptionProvider)new EntityTableDescriptionProvider());
        }

        @Override
        public JptValidator buildJoinTableJoinColumnValidator(AssociationOverride override, JoinColumn column, JoinColumn.Owner owner, JoinColumnTextRangeResolver textRangeResolver) {
            return new AssociationOverrideJoinColumnValidator(override, column, owner, textRangeResolver, (AbstractNamedColumnValidator.TableDescriptionProvider)new JoinTableTableDescriptionProvider());
        }

        @Override
        public JptValidator buildJoinTableInverseJoinColumnValidator(AssociationOverride override, JoinColumn column, JoinColumn.Owner owner, JoinColumnTextRangeResolver textRangeResolver) {
            return new AssociationOverrideInverseJoinColumnValidator(override, column, owner, textRangeResolver, (AbstractNamedColumnValidator.TableDescriptionProvider)new JoinTableTableDescriptionProvider());
        }

        @Override
        public JptValidator buildTableValidator(AssociationOverride override, Table t, TableTextRangeResolver textRangeResolver) {
            return new AssociationOverrideJoinTableValidator(override, (JoinTable)t, textRangeResolver);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AttributeOverrideContainerOwner
    extends OverrideContainerOwner
    implements JavaAttributeOverrideContainer.Owner {
        protected AttributeOverrideContainerOwner() {
        }

        @Override
        protected Iterator<String> allOverridableNames_(TypeMapping typeMapping) {
            HashBag mappedByRelationshipAttributes = CollectionTools.collection((Iterator)new TransformationIterator<SingleRelationshipMapping2_0, String>(this.getMapsIdRelationships()){

                protected String transform(SingleRelationshipMapping2_0 mapping) {
                    return mapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getValue();
                }
            });
            return new FilteringIterator<String>(typeMapping.allOverridableAttributeNames(), (Collection)mappedByRelationshipAttributes){
                private final /* synthetic */ Collection val$mappedByRelationshipAttributes;
                {
                    this.val$mappedByRelationshipAttributes = collection;
                    super($anonymous0);
                }

                protected boolean accept(String name) {
                    if (this.val$mappedByRelationshipAttributes.isEmpty()) {
                        return true;
                    }
                    int index = name.indexOf(46);
                    String qualifier = index > 0 ? name.substring(0, index) : name;
                    return !this.val$mappedByRelationshipAttributes.contains(qualifier);
                }
            };
        }

        protected Iterable<SingleRelationshipMapping2_0> getMapsIdRelationships() {
            return new FilteringIterable<SingleRelationshipMapping2_0>(this.getSingleRelationshipMappings()){

                protected boolean accept(SingleRelationshipMapping2_0 mapping) {
                    return mapping.getDerivedIdentity().usesMapsIdDerivedIdentityStrategy();
                }
            };
        }

        protected Iterable<SingleRelationshipMapping2_0> getSingleRelationshipMappings() {
            return new SubIterableWrapper(this.getSingleRelationshipMappings_());
        }

        protected Iterable<AttributeMapping> getSingleRelationshipMappings_() {
            return new CompositeIterable(new Iterable[]{this.getTypeMapping().getAllAttributeMappings("oneToOne"), this.getTypeMapping().getAllAttributeMappings("manyToOne")});
        }

        @Override
        public Column resolveOverriddenColumn(String attributeName) {
            return MappingTools.resolveOverriddenColumn(this.getOverridableTypeMapping(), attributeName);
        }

        @Override
        public JptValidator buildValidator(Override_ override, OverrideContainer container, OverrideTextRangeResolver textRangeResolver) {
            return new AttributeOverrideValidator((AttributeOverride)override, (AttributeOverrideContainer)container, textRangeResolver, (OverrideValidator.OverrideDescriptionProvider)new MappedSuperclassOverrideDescriptionProvider());
        }

        @Override
        public JptValidator buildColumnValidator(Override_ override, BaseColumn column, BaseColumn.Owner owner, BaseColumnTextRangeResolver textRangeResolver) {
            return new AttributeOverrideColumnValidator((AttributeOverride)override, column, textRangeResolver, (AbstractNamedColumnValidator.TableDescriptionProvider)new EntityTableDescriptionProvider());
        }
    }

    protected class DiscriminatorColumnOwner
    extends NamedColumnOwner
    implements JavaDiscriminatorColumn.Owner {
        protected DiscriminatorColumnOwner() {
        }

        public String getDefaultColumnName() {
            return this.isDescendant() ? this.getRootDiscriminatorColumn().getName() : (this.discriminatorColumnIsUndefined() ? null : "DTYPE");
        }

        public int getDefaultLength() {
            return this.isDescendant() ? this.getRootDiscriminatorColumn().getLength() : (this.discriminatorColumnIsUndefined() ? 0 : 31);
        }

        public DiscriminatorType getDefaultDiscriminatorType() {
            return this.isDescendant() ? this.getRootDiscriminatorColumn().getDiscriminatorType() : (this.discriminatorColumnIsUndefined() ? null : DiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE);
        }

        protected boolean isDescendant() {
            return AbstractJavaEntity.this.isDescendant();
        }

        protected DiscriminatorColumn getRootDiscriminatorColumn() {
            return AbstractJavaEntity.this.rootEntity.getDiscriminatorColumn();
        }

        protected boolean discriminatorColumnIsUndefined() {
            return AbstractJavaEntity.this.discriminatorColumnIsUndefined;
        }

        public JptValidator buildColumnValidator(NamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return new DiscriminatorColumnValidator(column, textRangeResolver);
        }
    }

    protected abstract class NamedColumnOwner
    implements JavaNamedColumn.Owner {
        protected NamedColumnOwner() {
        }

        public TypeMapping getTypeMapping() {
            return AbstractJavaEntity.this;
        }

        public String getDefaultTableName() {
            return AbstractJavaEntity.this.getPrimaryTableName();
        }

        public org.eclipse.jpt.jpa.db.Table resolveDbTable(String tableName) {
            return AbstractJavaEntity.this.resolveDbTable(tableName);
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return AbstractJavaEntity.this.getValidationTextRange(astRoot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class OverrideContainerOwner
    implements JavaOverrideContainer.Owner {
        protected OverrideContainerOwner() {
        }

        @Override
        public JavaResourcePersistentMember getResourcePersistentMember() {
            return AbstractJavaEntity.this.getResourcePersistentType();
        }

        @Override
        public JavaTypeMapping getTypeMapping() {
            return AbstractJavaEntity.this;
        }

        @Override
        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return AbstractJavaEntity.this.getValidationTextRange(astRoot);
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractJavaEntity.this.getOverridableTypeMapping();
        }

        @Override
        public Iterator<String> allOverridableNames() {
            TypeMapping typeMapping = this.getOverridableTypeMapping();
            return typeMapping != null ? this.allOverridableNames_(typeMapping) : EmptyIterator.instance();
        }

        protected abstract Iterator<String> allOverridableNames_(TypeMapping var1);

        @Override
        public String getDefaultTableName() {
            return AbstractJavaEntity.this.getPrimaryTableName();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return AbstractJavaEntity.this.tableNameIsInvalid(tableName);
        }

        @Override
        public org.eclipse.jpt.jpa.db.Table resolveDbTable(String tableName) {
            return AbstractJavaEntity.this.resolveDbTable(tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return AbstractJavaEntity.this.allAssociatedTableNames();
        }

        @Override
        public String getPossiblePrefix() {
            return null;
        }

        @Override
        public String getWritePrefix() {
            return null;
        }

        @Override
        public boolean isRelevant(String overrideName) {
            return true;
        }
    }

    protected class PrimaryKeyJoinColumnOwner
    extends NamedColumnOwner
    implements JavaBaseJoinColumn.Owner {
        protected PrimaryKeyJoinColumnOwner() {
        }

        public org.eclipse.jpt.jpa.db.Table getReferencedColumnDbTable() {
            Entity parentEntity = AbstractJavaEntity.this.getParentEntity();
            return parentEntity == null ? null : parentEntity.getPrimaryDbTable();
        }

        public int joinColumnsSize() {
            return AbstractJavaEntity.this.primaryKeyJoinColumnsSize();
        }

        public boolean joinColumnIsDefault(ReadOnlyBaseJoinColumn joinColumn) {
            return AbstractJavaEntity.this.defaultPrimaryKeyJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            if (this.joinColumnsSize() != 1) {
                return null;
            }
            Entity parentEntity = AbstractJavaEntity.this.getParentEntity();
            return parentEntity == null ? AbstractJavaEntity.this.getPrimaryKeyColumnName() : parentEntity.getPrimaryKeyColumnName();
        }

        public JptValidator buildColumnValidator(NamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return new EntityPrimaryKeyJoinColumnValidator((BaseJoinColumn)column, this, (BaseJoinColumnTextRangeResolver)textRangeResolver);
        }
    }

    protected class SecondaryTableOwner
    implements Table.Owner {
        protected SecondaryTableOwner() {
        }

        public JptValidator buildTableValidator(Table t, TableTextRangeResolver textRangeResolver) {
            return new SecondaryTableValidator((SecondaryTable)t, textRangeResolver);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedPrimaryKeyJoinColumnContainerAdapter
    implements ContextContainerTools.Adapter<JavaPrimaryKeyJoinColumn, PrimaryKeyJoinColumnAnnotation> {
        protected SpecifiedPrimaryKeyJoinColumnContainerAdapter() {
        }

        @Override
        public Iterable<JavaPrimaryKeyJoinColumn> getContextElements() {
            return AbstractJavaEntity.this.getSpecifiedPrimaryKeyJoinColumns();
        }

        @Override
        public Iterable<PrimaryKeyJoinColumnAnnotation> getResourceElements() {
            return AbstractJavaEntity.this.getPrimaryKeyJoinColumnAnnotations();
        }

        @Override
        public PrimaryKeyJoinColumnAnnotation getResourceElement(JavaPrimaryKeyJoinColumn contextElement) {
            return contextElement.getColumnAnnotation();
        }

        @Override
        public void moveContextElement(int index, JavaPrimaryKeyJoinColumn element) {
            AbstractJavaEntity.this.moveSpecifiedPrimaryKeyJoinColumn_(index, element);
        }

        @Override
        public void addContextElement(int index, PrimaryKeyJoinColumnAnnotation resourceElement) {
            AbstractJavaEntity.this.addSpecifiedPrimaryKeyJoinColumn_(index, resourceElement);
        }

        @Override
        public void removeContextElement(JavaPrimaryKeyJoinColumn element) {
            AbstractJavaEntity.this.removeSpecifiedPrimaryKeyJoinColumn_(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedSecondaryTableContainerAdapter
    implements ContextContainerTools.Adapter<JavaSecondaryTable, SecondaryTableAnnotation> {
        protected SpecifiedSecondaryTableContainerAdapter() {
        }

        @Override
        public Iterable<JavaSecondaryTable> getContextElements() {
            return AbstractJavaEntity.this.getSpecifiedSecondaryTables();
        }

        @Override
        public Iterable<SecondaryTableAnnotation> getResourceElements() {
            return AbstractJavaEntity.this.getSecondaryTableAnnotations();
        }

        @Override
        public SecondaryTableAnnotation getResourceElement(JavaSecondaryTable contextElement) {
            return contextElement.getTableAnnotation();
        }

        @Override
        public void moveContextElement(int index, JavaSecondaryTable element) {
            AbstractJavaEntity.this.moveSpecifiedSecondaryTable_(index, element);
        }

        @Override
        public void addContextElement(int index, SecondaryTableAnnotation resourceElement) {
            AbstractJavaEntity.this.addSpecifiedSecondaryTable_(index, resourceElement);
        }

        @Override
        public void removeContextElement(JavaSecondaryTable element) {
            AbstractJavaEntity.this.removeSpecifiedSecondaryTable_(element);
        }
    }

    protected class TableOwner
    implements Table.Owner {
        protected TableOwner() {
        }

        public JptValidator buildTableValidator(Table t, TableTextRangeResolver textRangeResolver) {
            return new TableValidator(t, textRangeResolver);
        }
    }
}

