/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.application.internal.operations.IUpdateModuleContextRootProperties;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class UpdateModuleContextRootInEAROp
extends AbstractDataModelOperation
implements IUpdateModuleContextRootProperties {
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            try {
                String newContextRoot = this.model.getStringProperty("IServerContextRootDataModelProperties.CONTEXT_ROOT");
                IProject project = (IProject)this.model.getProperty("IServerContextRootDataModelProperties.PROJECT");
                IDataModel nestedModel = this.model.getNestedModel("UpdateModuleContextRootModel");
                if (nestedModel != null) {
                    List earsToUpdate = (List)nestedModel.getProperty("IUpdateModuleContextRootProperties.EARS_TO_UPDATE");
                    if (newContextRoot != null && earsToUpdate != null && project != null) {
                        int i = 0;
                        while (i < earsToUpdate.size()) {
                            this.updateEARContextRoot((IProject)earsToUpdate.get(i), project, newContextRoot, monitor);
                            ++i;
                        }
                    }
                }
            }
            catch (Exception e) {
                J2EEPlugin.logError(e);
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return OK_STATUS;
    }

    private void updateEARContextRoot(IProject ear, IProject project, String newContextRoot, IProgressMonitor monitor) {
        EARArtifactEdit earEdit = null;
        try {
            earEdit = EARArtifactEdit.getEARArtifactEditForWrite(ear);
            if (earEdit != null) {
                Application application = earEdit.getApplication();
                IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
                if (comp == null) {
                    return;
                }
                String moduleURI = earEdit.getModuleURI(comp);
                Module module = application.getFirstModule(moduleURI);
                if (module != null && module instanceof WebModule) {
                    ((WebModule)module).setContextRoot(newContextRoot);
                }
                earEdit.saveIfNecessary(monitor);
            }
        }
        finally {
            if (earEdit != null) {
                earEdit.dispose();
            }
        }
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

