/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.internal.deployables;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ModuleFile;
import org.eclipse.wst.server.core.util.ModuleFolder;
import org.eclipse.wst.server.core.util.ProjectModule;

public abstract class ComponentDeployable
extends ProjectModule {
    protected IVirtualComponent component = null;
    protected List<IModuleResource> members = new ArrayList<IModuleResource>();

    public ComponentDeployable(IProject project) {
        this(project, ComponentCore.createComponent((IProject)project));
    }

    public ComponentDeployable(IProject project, IVirtualComponent aComponent) {
        super(project);
        this.component = aComponent;
    }

    public boolean isBinary() {
        if (this.component == null) {
            return false;
        }
        return this.component.isBinary();
    }

    protected void addMembersToModuleFolder(ModuleFolder mf, IModuleResource[] mr) {
        if (mf == null || mr == null || mr.length == 0) {
            return;
        }
        IModuleResource[] mf_members = mf.members();
        int mf_size = 0;
        if (mf_members != null) {
            mf_size = mf_members.length;
        }
        IModuleResource[] res = new IModuleResource[mf_size + mr.length];
        if (mf_members != null && mf_size > 0) {
            System.arraycopy(mf_members, 0, res, 0, mf_size);
        }
        System.arraycopy(mr, 0, res, mf_size, mr.length);
        mf.setMembers(res);
    }

    public IModule[] getChildModules() {
        return this.getModules();
    }

    public IModule[] getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        if (this.component != null) {
            IVirtualReference[] components = this.getReferences(this.component);
            int i = 0;
            while (i < components.length) {
                IVirtualComponent virtualComp;
                IModule module;
                IVirtualReference reference = components[i];
                if (reference != null && reference.getDependencyType() == 0 && (module = this.gatherModuleReference(this.component, virtualComp = reference.getReferencedComponent())) != null && !modules.contains(module)) {
                    modules.add(module);
                }
                ++i;
            }
        }
        return modules.toArray(new IModule[modules.size()]);
    }

    protected IVirtualReference[] getReferences(IVirtualComponent aComponent) {
        return aComponent.getReferences();
    }

    protected IModule gatherModuleReference(IVirtualComponent component, IVirtualComponent targetComponent) {
        if (targetComponent != null && targetComponent.getProject() != component.getProject() && !targetComponent.isBinary()) {
            return ServerUtil.getModule((IProject)targetComponent.getProject());
        }
        return null;
    }

    protected IModuleResource[] getMembers(IContainer cont, IPath path, IPath javaPath, IContainer[] javaCont) throws CoreException {
        IResource[] res = cont.members();
        int size2 = res.length;
        ArrayList<IModuleFile> list = new ArrayList<IModuleFile>(size2);
        int j = 0;
        while (j < size2) {
            if (res[j] instanceof IContainer) {
                IContainer cc = (IContainer)res[j];
                IPath newPath = path.append(cc.getName()).makeRelative();
                ModuleFolder mf = (ModuleFolder)this.getExistingModuleResource(this.members, newPath);
                if (mf == null) {
                    mf = new ModuleFolder(cc, cc.getName(), path);
                    ModuleFolder parent = (ModuleFolder)this.getExistingModuleResource(this.members, path);
                    if (path.isEmpty()) {
                        this.members.add((IModuleResource)mf);
                    } else {
                        if (parent == null) {
                            parent = this.ensureParentExists(path, cc);
                        }
                        this.addMembersToModuleFolder(parent, new IModuleResource[]{mf});
                    }
                }
                IModuleResource[] mr = this.getMembers(cc, newPath, javaPath, javaCont);
                if (javaPath != null && newPath.isPrefixOf(javaPath)) {
                    mr = this.handleJavaPath(path, javaPath, newPath, javaCont, mr, cc);
                }
                this.addMembersToModuleFolder(mf, mr);
            } else {
                IFile f = (IFile)res[j];
                if (path.equals((Object)javaPath)) {
                    ModuleFolder mFolder = (ModuleFolder)this.getExistingModuleResource(this.members, javaPath);
                    IModuleFile mFile = this.createModuleFile(f, javaPath);
                    if (mFolder != null) {
                        this.addMembersToModuleFolder(mFolder, new IModuleResource[]{mFile});
                    } else {
                        list.add(mFile);
                    }
                } else {
                    IModuleFile mf = this.createModuleFile(f, path);
                    list.add(mf);
                }
            }
            ++j;
        }
        IModuleResource[] mr = new IModuleResource[list.size()];
        list.toArray(mr);
        return mr;
    }

    protected IModuleFile createModuleFile(IFile file, IPath path) {
        return new ModuleFile(file, file.getName(), path);
    }

    protected IModuleResource[] getMembers(IVirtualContainer cont, IPath path) throws CoreException {
        IVirtualResource[] res = cont.members();
        int size2 = res.length;
        ArrayList<IModuleFile> list = new ArrayList<IModuleFile>(size2);
        int j = 0;
        while (j < size2) {
            IModuleFile mf;
            if (res[j] instanceof IVirtualContainer) {
                IVirtualContainer cc = (IVirtualContainer)res[j];
                mf = (ModuleFolder)this.getExistingModuleResource(this.members, path.append(new Path(cc.getName()).makeRelative()));
                if (mf == null) {
                    mf = new ModuleFolder((IContainer)cc.getUnderlyingResource(), cc.getName(), path);
                    ModuleFolder parent = (ModuleFolder)this.getExistingModuleResource(this.members, path);
                    if (path.isEmpty()) {
                        this.members.add((IModuleResource)mf);
                    } else {
                        if (parent == null) {
                            parent = this.ensureParentExists(path, (IContainer)cc.getUnderlyingResource());
                        }
                        this.addMembersToModuleFolder(parent, new IModuleResource[]{mf});
                    }
                }
                IModuleResource[] mr = this.getMembers(cc, path.append(cc.getName()));
                this.addMembersToModuleFolder((ModuleFolder)mf, mr);
            } else {
                IFile f = (IFile)res[j].getUnderlyingResource();
                mf = null;
                if (this.shouldAddComponentFile(f)) {
                    mf = this.createModuleFile(f, path);
                    list.add(mf);
                }
            }
            ++j;
        }
        IModuleResource[] mr = new IModuleResource[list.size()];
        list.toArray(mr);
        return mr;
    }

    protected ModuleFolder ensureParentExists(IPath path, IContainer cc) {
        ModuleFolder parent = (ModuleFolder)this.getExistingModuleResource(this.members, path);
        if (parent == null) {
            String folderName = path.lastSegment();
            Path folderPath = Path.EMPTY;
            if (path.segmentCount() > 1) {
                folderPath = path.removeLastSegments(1);
            }
            parent = new ModuleFolder(cc, folderName, (IPath)folderPath);
            if (path.segmentCount() > 1) {
                this.addMembersToModuleFolder(this.ensureParentExists(path.removeLastSegments(1), cc), new IModuleResource[]{parent});
            } else {
                this.members.add((IModuleResource)parent);
            }
        }
        return parent;
    }

    protected boolean shouldAddComponentFile(IFile file) {
        return true;
    }

    protected IModuleResource getExistingModuleResource(List aList, IPath path) {
        if (aList == null || aList.isEmpty() || path == null) {
            return null;
        }
        String[] pathSegments = path.segments();
        IModuleResource moduleResource2 = null;
        if (pathSegments.length == 0) {
            return null;
        }
        for (IModuleResource moduleResource2 : aList) {
            String[] moduleSegments = moduleResource2.getModuleRelativePath().segments();
            if (pathSegments[pathSegments.length - 1].equals(moduleResource2.getName()) && moduleSegments.length + 1 == pathSegments.length && this.startsWith(moduleSegments, pathSegments)) {
                return moduleResource2;
            }
            if (!(moduleResource2 instanceof IModuleFolder) || !this.startsWith(moduleSegments, pathSegments) || pathSegments.length <= moduleSegments.length || !moduleResource2.getName().equals(pathSegments[moduleSegments.length > 0 ? moduleSegments.length : 0]) || ((IModuleFolder)moduleResource2).members() == null) continue;
            return this.getExistingModuleResource(Arrays.asList(((IModuleFolder)moduleResource2).members()), path);
        }
        return null;
    }

    private boolean startsWith(String[] beginningSegments, String[] testSegments) {
        int i = 0;
        while (i < beginningSegments.length) {
            if (!beginningSegments[i].equals(testSegments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected IModuleResource[] handleJavaPath(IPath path, IPath javaPath, IPath curPath, IContainer[] javaCont, IModuleResource[] mr, IContainer cc) throws CoreException {
        return new IModuleResource[0];
    }

    public IModuleResource[] members() throws CoreException {
        this.members.clear();
        IVirtualComponent vc = ComponentCore.createComponent((IProject)this.getProject());
        if (vc != null) {
            IVirtualFolder vFolder = vc.getRootFolder();
            IModuleResource[] mr = this.getMembers((IVirtualContainer)vFolder, (IPath)Path.EMPTY);
            int size = mr.length;
            int j = 0;
            while (j < size) {
                this.members.add(mr[j]);
                ++j;
            }
            this.addUtilMembers(vc);
        }
        IModuleResource[] mr = new IModuleResource[this.members.size()];
        this.members.toArray(mr);
        return mr;
    }

    protected boolean shouldIncludeUtilityComponent(IVirtualComponent virtualComp, IVirtualReference[] components, ArtifactEdit edit) {
        return virtualComp != null && virtualComp.isBinary() && virtualComp.getProject() == this.component.getProject();
    }

    protected void addUtilMembers(IVirtualComponent vc) {
        ArtifactEdit edit = null;
        try {
            edit = this.getComponentArtifactEditForRead();
            IVirtualReference[] components = vc.getReferences();
            int i = 0;
            while (i < components.length) {
                IVirtualReference reference = components[i];
                IVirtualComponent virtualComp = reference.getReferencedComponent();
                if (this.shouldIncludeUtilityComponent(virtualComp, components, edit)) {
                    this.addUtilMember(vc, reference, reference.getRuntimePath());
                }
                ++i;
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    protected void addUtilMember(IVirtualComponent parent, IVirtualReference reference, IPath runtimePath) {
        ModuleFile mf = null;
        String archiveName2 = reference.getArchiveName();
        String archiveName = new Path(archiveName2).lastSegment();
        IVirtualComponent virtualComp = reference.getReferencedComponent();
        IFile ifile = (IFile)virtualComp.getAdapter(IFile.class);
        if (ifile != null) {
            String name = archiveName != null ? archiveName : ifile.getName();
            mf = new ModuleFile(ifile, name, runtimePath.makeRelative());
        } else {
            File extFile = (File)virtualComp.getAdapter(File.class);
            String name = archiveName != null ? archiveName : extFile.getName();
            mf = new ModuleFile(extFile, name, runtimePath.makeRelative());
        }
        IModuleResource moduleParent = this.getExistingModuleResource(this.members, mf.getModuleRelativePath());
        if (moduleParent != null && moduleParent instanceof ModuleFolder) {
            this.addMembersToModuleFolder((ModuleFolder)moduleParent, new IModuleResource[]{mf});
        } else if (mf.getModuleRelativePath().isEmpty()) {
            this.members.add((IModuleResource)mf);
        } else {
            if (moduleParent == null) {
                moduleParent = this.ensureParentExists(mf.getModuleRelativePath(), (IContainer)parent.getRootFolder().getUnderlyingResource());
            }
            this.addMembersToModuleFolder((ModuleFolder)moduleParent, new IModuleResource[]{mf});
        }
    }

    protected ArtifactEdit getComponentArtifactEditForRead() {
        return null;
    }

    protected static boolean isProjectOfType(IProject project, String typeID) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return false;
        }
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)typeID)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }

    public IContainer[] getResourceFolders() {
        IVirtualFolder vFolder;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)this.getProject());
        if (vc != null && (vFolder = vc.getRootFolder()) != null) {
            return vFolder.getUnderlyingFolders();
        }
        return new IContainer[0];
    }
}

