/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentproperties.ui;

import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.wst.css.core.internal.metamodel.CSSProfile;
import org.eclipse.wst.css.core.internal.metamodel.CSSProfileRegistry;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeEntry;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeRegistry;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.html.ui.internal.contentproperties.ui.DeviceProfileEntry;
import org.eclipse.wst.html.ui.internal.contentproperties.ui.DeviceProfileEntryProviderBuilder;
import org.eclipse.wst.sse.core.internal.encoding.CommonCharsetNames;
import org.eclipse.wst.sse.ui.internal.contentproperties.ui.ComboList;

public final class ContentSettingsRegistry {
    private static final String NONE = HTMLUIMessages.UI_none;
    public static String maxLengthStringInHTMLDocumentTypeRegistry = "";
    public static String maxLengthStringInCharacterCodeRegistry = "";

    private ContentSettingsRegistry() {
    }

    public static void setHTMLDocumentTypeRegistryInto(ComboList combo) {
        combo.add(NONE, "");
        HTMLDocumentTypeRegistry reg = HTMLDocumentTypeRegistry.getInstance();
        Enumeration e = reg.getEntries();
        while (e.hasMoreElements()) {
            HTMLDocumentTypeEntry entry = (HTMLDocumentTypeEntry)e.nextElement();
            String publicId = entry.getPublicId();
            String displayName = entry.getDisplayName();
            if (displayName != null) {
                combo.add(displayName, publicId);
                if (displayName.length() > maxLengthStringInHTMLDocumentTypeRegistry.length()) {
                    maxLengthStringInHTMLDocumentTypeRegistry = displayName;
                }
            } else {
                combo.add(publicId, publicId);
            }
            if (publicId.length() > maxLengthStringInHTMLDocumentTypeRegistry.length()) {
                maxLengthStringInHTMLDocumentTypeRegistry = publicId;
            }
            if (entry.getSystemId() == null || entry.getSystemId().length() <= maxLengthStringInHTMLDocumentTypeRegistry.length()) continue;
            maxLengthStringInHTMLDocumentTypeRegistry = entry.getSystemId();
        }
        combo.sortByKey(1);
    }

    public static void setCSSMetaModelRegistryInto(ComboList combo) {
        combo.add(NONE, "");
        CSSProfileRegistry reg = CSSProfileRegistry.getInstance();
        Iterator i = reg.getProfiles();
        while (i.hasNext()) {
            CSSProfile profile = (CSSProfile)i.next();
            String id = profile.getProfileID();
            String name = profile.getProfileName();
            combo.add(name, id);
        }
        combo.sortByKey(1);
    }

    /*
     * Unable to fully structure code
     */
    public static void setDeviceProfileRegistryInto(ComboList combo) {
        combo.add(ContentSettingsRegistry.NONE, "");
        reg = DeviceProfileEntryProviderBuilder.getEntryProvider();
        if (reg == null) {
            return;
        }
        profiles = reg.getDeviceProfileEntries();
        if (profiles != null) ** GOTO lbl12
        reg.release();
        return;
lbl-1000:
        // 1 sources

        {
            entry = (DeviceProfileEntry)profiles.next();
            combo.add(entry.getEntryName(), entry.getEntryId());
            entry.release();
lbl12:
            // 2 sources

            ** while (profiles.hasNext())
        }
lbl13:
        // 1 sources

        reg.release();
        combo.sortByKey(1);
    }

    public static String getSystemIdFrom(String publicId) {
        if (publicId == null || publicId.length() == 0) {
            return null;
        }
        HTMLDocumentTypeRegistry reg = HTMLDocumentTypeRegistry.getInstance();
        Enumeration e = reg.getEntries();
        while (e.hasMoreElements()) {
            HTMLDocumentTypeEntry entry = (HTMLDocumentTypeEntry)e.nextElement();
            if (!entry.getPublicId().equals(publicId)) continue;
            return entry.getSystemId();
        }
        return null;
    }

    public static void setContentTypeInto(ComboList combo) {
        String[] type = new String[]{"", "application/xhtml+xml", "application/xml", "text/html", "text/xml"};
        String[] displayName = new String[]{NONE, "application/xhtml+xml", "application/xml", "text/html", "text/xml"};
        int i = 0;
        while (i < type.length) {
            if (displayName[i] != null && displayName[i].length() != 0) {
                combo.add(displayName[i], type[i]);
            } else {
                combo.add(type[i], type[i]);
            }
            ++i;
        }
    }

    public static void setCharacterCodeInto(ComboList combo) {
        combo.add(NONE, "");
        String max = "";
        String[] charCode = CommonCharsetNames.getCommonCharsetNames();
        int i = 0;
        while (i < charCode.length) {
            String displayName = CommonCharsetNames.getDisplayString((String)charCode[i]);
            if (displayName != null && displayName.length() != 0) {
                combo.add(displayName, charCode[i]);
                int n_byte = displayName.getBytes().length;
                if (max.getBytes().length < n_byte) {
                    max = displayName;
                }
            } else {
                combo.add(charCode[i], charCode[i]);
            }
            ++i;
        }
        maxLengthStringInCharacterCodeRegistry = max;
    }

    public static void setLanguageInto(ComboList combo) {
        String[] lang = new String[]{"", "java", "javascript"};
        String[] displayName = new String[]{NONE, "java", "javascript"};
        int i = 0;
        while (i < lang.length) {
            if (displayName[i] != null && displayName[i].length() != 0) {
                combo.add(displayName[i], lang[i]);
            } else {
                combo.add(lang[i], lang[i]);
            }
            ++i;
        }
    }
}

