/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceBaseColumnAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.BaseJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

public abstract class SourceBaseJoinColumnAnnotation
extends SourceBaseColumnAnnotation
implements BaseJoinColumnAnnotation {
    private final DeclarationAnnotationElementAdapter<String> referencedColumnNameDeclarationAdapter = this.buildStringElementAdapter(this.getReferencedColumnNameElementName());
    private final AnnotationElementAdapter<String> referencedColumnNameAdapter = this.buildShortCircuitElementAdapter(this.referencedColumnNameDeclarationAdapter);
    private String referencedColumnName;

    protected SourceBaseJoinColumnAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    protected SourceBaseJoinColumnAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        this(parent, member, daa, (AnnotationAdapter)new MemberAnnotationAdapter(member, daa));
    }

    protected SourceBaseJoinColumnAnnotation(JavaResourceNode parent, Member member, IndexedDeclarationAnnotationAdapter idaa) {
        this(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new MemberIndexedAnnotationAdapter(member, idaa));
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.referencedColumnName = this.buildReferencedColumnName(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncReferencedColumnName(this.buildReferencedColumnName(astRoot));
    }

    protected abstract String getReferencedColumnNameElementName();

    public String getReferencedColumnName() {
        return this.referencedColumnName;
    }

    public void setReferencedColumnName(String referencedColumnName) {
        if (this.attributeValueHasChanged(this.referencedColumnName, referencedColumnName)) {
            this.referencedColumnName = referencedColumnName;
            this.referencedColumnNameAdapter.setValue(referencedColumnName);
        }
    }

    private void syncReferencedColumnName(String astReferencedColumnName) {
        String old = this.referencedColumnName;
        this.referencedColumnName = astReferencedColumnName;
        this.firePropertyChanged("referencedColumnName", old, astReferencedColumnName);
    }

    private String buildReferencedColumnName(CompilationUnit astRoot) {
        return this.referencedColumnNameAdapter.getValue(astRoot);
    }

    public TextRange getReferencedColumnNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.referencedColumnNameDeclarationAdapter, astRoot);
    }

    public boolean referencedColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.referencedColumnNameDeclarationAdapter, pos, astRoot);
    }

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        BaseJoinColumnAnnotation oldJoinColumn = (BaseJoinColumnAnnotation)((Object)oldAnnotation);
        this.setReferencedColumnName(oldJoinColumn.getReferencedColumnName());
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    protected IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }
}

