/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.jface;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.ui.JptUiPlugin;

public class XmlMappingFileViewerFilter
extends ViewerFilter {
    private final IJavaProject javaProject;
    private final JpaProject jpaProject;

    public XmlMappingFileViewerFilter(JpaProject jpaProject) {
        this.jpaProject = jpaProject;
        this.javaProject = jpaProject.getJavaProject();
    }

    private boolean isMappingFile(IFile file) {
        JpaFile jpaFile = this.jpaProject.getJpaFile(file);
        return jpaFile != null ? jpaFile.getContentType().isKindOf(JptCorePlugin.MAPPING_FILE_CONTENT_TYPE) : false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IFile) {
            return this.isMappingFile((IFile)element);
        }
        if (!(element instanceof IFolder)) return false;
        IFolder folder = (IFolder)element;
        try {
            IClasspathEntry[] iClasspathEntryArray = this.javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && entry.getPath().isPrefixOf(folder.getFullPath().makeRelative())) {
                    IResource[] iResourceArray = folder.members();
                    int n3 = iResourceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource resource = iResourceArray[n4];
                        if (this.select(viewer, folder, resource)) {
                            return true;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e.getStatus());
            return false;
        }
        catch (CoreException e) {
            JptUiPlugin.log(e.getStatus());
        }
        return false;
    }
}

