/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.gen;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.ui.internal.ImageRepository;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class TableFigure
extends Figure {
    private Color tableColor = new Color(null, 220, 232, 241);
    private Font tableFont = new Font(null, "Arial", 8, 0);
    private Color borderColor = new Color(null, 14, 66, 115);
    public static final int OUTLINE_CORNER_RADIUS = 6;
    protected final ResourceManager resourceManager;

    public TableFigure(String name, ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        GridLayout gl = new GridLayout();
        gl.marginHeight = 2;
        gl.marginWidth = 10;
        this.setLayoutManager((LayoutManager)gl);
        this.setBorder((Border)new LineBorder(this.tableColor, 0));
        this.setBackgroundColor(this.tableColor);
        this.setOpaque(true);
        this.setSize(150, 20);
        Label nameLabel = new Label("", ImageRepository.getTableObjImage(this.resourceManager));
        nameLabel.setFont(this.tableFont);
        nameLabel.setText(name);
        nameLabel.setForegroundColor(this.borderColor);
        nameLabel.setLabelAlignment(2);
        this.add((IFigure)nameLabel);
    }

    protected void paintClientArea(Graphics graphics) {
        super.paintClientArea(graphics);
        graphics.pushState();
        Rectangle r = this.getBounds().getCopy();
        graphics.drawRoundRectangle(r.expand(new Insets(-1, -1, -2, -2)), 6, 6);
        graphics.popState();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setBackgroundColor(this.tableColor);
        } else {
            this.setBackgroundColor(ColorConstants.white);
        }
    }

    public void dispose() {
        this.borderColor.dispose();
        this.tableFont.dispose();
        this.tableColor.dispose();
    }
}

