/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRootInfo;
import org.eclipse.wst.jsdt.internal.core.LibraryPackageFragment;
import org.eclipse.wst.jsdt.internal.core.LibraryPackageFragmentInfo;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class LibraryFragmentRoot
extends PackageFragmentRoot {
    protected final IPath libraryPath;
    protected boolean[] fLangeRuntime = new boolean[2];

    protected LibraryFragmentRoot(IPath jarPath, JavaProject project) {
        super(null, project);
        this.libraryPath = jarPath;
    }

    protected LibraryFragmentRoot(IResource resource, JavaProject project) {
        super(resource, project);
        this.libraryPath = resource.getFullPath();
    }

    public PackageFragment getPackageFragment(String[] pkgName) {
        return new LibraryPackageFragment(this, pkgName);
    }

    public IPath getPath() {
        if (this.isExternal()) {
            return this.libraryPath;
        }
        return super.getPath();
    }

    public IPath getLocation() {
        if (this.isExternal()) {
            return this.libraryPath;
        }
        return super.getLocation();
    }

    public IResource getUnderlyingResource() throws JavaScriptModelException {
        if (this.isExternal()) {
            if (!this.exists()) {
                throw this.newNotPresentException();
            }
            return null;
        }
        return super.getUnderlyingResource();
    }

    public IResource getResource() {
        if (this.resource == null) {
            this.resource = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.libraryPath, false);
        }
        if (this.resource instanceof IResource) {
            return super.getResource();
        }
        return null;
    }

    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws JavaScriptModelException {
        String[] name = new String[]{""};
        ArrayList<LibraryPackageFragment> vChildren = new ArrayList<LibraryPackageFragment>(5);
        if (!this.isDirectory()) {
            LibraryPackageFragment packFrag = new LibraryPackageFragment(this, name);
            LibraryPackageFragmentInfo fragInfo = new LibraryPackageFragmentInfo();
            packFrag.computeChildren(fragInfo);
            newElements.put(packFrag, fragInfo);
            vChildren.add(packFrag);
        } else {
            this.computeDirectoryChildren(this.getFile(), true, CharOperation.NO_STRINGS, vChildren);
        }
        IJavaScriptElement[] children = new IJavaScriptElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    protected void computeDirectoryChildren(File file, boolean isIncluded, String[] pkgName, ArrayList vChildren) throws JavaScriptModelException {
        if (isIncluded) {
            PackageFragment pkg = this.getPackageFragment(pkgName);
            vChildren.add(pkg);
        }
        try {
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            File[] members = file.listFiles();
            boolean hasIncluded = isIncluded;
            if (members != null && members.length > 0) {
                int i = 0;
                while (i < members.length) {
                    File member = members[i];
                    String memberName = member.getName();
                    if (member.isDirectory()) {
                        String[] newNames = Util.arrayConcat(pkgName, manager.intern(memberName));
                        this.computeDirectoryChildren(member, true, newNames, vChildren);
                    } else if (!hasIncluded && org.eclipse.wst.jsdt.internal.compiler.util.Util.isJavaFileName(memberName)) {
                        hasIncluded = true;
                        PackageFragment pkg = this.getPackageFragment(pkgName);
                        vChildren.add(pkg);
                    }
                    ++i;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new JavaScriptModelException(e, 969);
        }
        catch (CoreException e) {
            throw new JavaScriptModelException(e);
        }
    }

    protected Object createElementInfo() {
        return new LibraryFragmentRootInfo();
    }

    protected int determineKind(IResource underlyingResource) {
        return 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LibraryFragmentRoot) {
            LibraryFragmentRoot other = (LibraryFragmentRoot)o;
            return this.libraryPath.equals((Object)other.libraryPath);
        }
        return false;
    }

    public String getElementName() {
        return this.libraryPath.lastSegment();
    }

    public int hashCode() {
        return this.libraryPath.hashCode();
    }

    public boolean isExternal() {
        return this.getResource() == null;
    }

    public boolean isReadOnly() {
        return true;
    }

    protected boolean resourceExists() {
        if (this.isExternal()) {
            return JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.getPath(), true) != null;
        }
        return super.resourceExists();
    }

    protected void toStringAncestors(StringBuffer buffer) {
        if (this.isExternal()) {
            return;
        }
        super.toStringAncestors(buffer);
    }

    public boolean isResourceContainer() {
        return false;
    }

    public String getDisplayName() {
        JsGlobalScopeContainerInitializer containerInitializer = this.getContainerInitializer();
        if (containerInitializer != null) {
            return containerInitializer.getDescription(this.getPath(), this.getJavaScriptProject());
        }
        return super.getDisplayName();
    }

    public boolean isVirtual() {
        return true;
    }

    public boolean isLanguageRuntime() {
        if (this.fLangeRuntime[0]) {
            return this.fLangeRuntime[1];
        }
        JsGlobalScopeContainerInitializer init = this.getContainerInitializer();
        if (init == null) {
            this.fLangeRuntime[0] = true;
            this.fLangeRuntime[1] = false;
            return this.fLangeRuntime[1];
        }
        this.fLangeRuntime[1] = init.getKind() == 2 || init.getKind() == 3;
        this.fLangeRuntime[0] = true;
        return this.fLangeRuntime[1];
    }

    public boolean isLibrary() {
        return true;
    }

    public boolean isDirectory() {
        return !org.eclipse.wst.jsdt.internal.compiler.util.Util.isJavaFileName(this.libraryPath.lastSegment());
    }

    public File getFile() {
        return new File(this.libraryPath.toOSString());
    }
}

