/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProposal;

public class JavaTypeCompletionProposal
extends JavaCompletionProposal {
    protected final IJavaScriptUnit fCompilationUnit;
    private final String fUnqualifiedTypeName;
    private final String fFullyQualifiedTypeName;

    public JavaTypeCompletionProposal(String replacementString, IJavaScriptUnit cu, int replacementOffset, int replacementLength, Image image, String displayString, int relevance) {
        this(replacementString, cu, replacementOffset, replacementLength, image, displayString, relevance, null);
    }

    public JavaTypeCompletionProposal(String replacementString, IJavaScriptUnit cu, int replacementOffset, int replacementLength, Image image, String displayString, int relevance, String fullyQualifiedTypeName) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance);
        this.fCompilationUnit = cu;
        this.fFullyQualifiedTypeName = fullyQualifiedTypeName;
        this.fUnqualifiedTypeName = fullyQualifiedTypeName != null ? Signature.getSimpleName((String)fullyQualifiedTypeName) : null;
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset, ImportRewrite impRewrite) throws CoreException, BadLocationException {
        if (impRewrite != null && this.fFullyQualifiedTypeName != null) {
            IType[] types;
            String replacementString = this.getReplacementString();
            String qualifiedType = this.fFullyQualifiedTypeName;
            if (qualifiedType.indexOf(46) != -1 && replacementString.startsWith(qualifiedType) && !replacementString.endsWith(String.valueOf(';')) && (types = impRewrite.getCompilationUnit().getTypes()).length > 0 && types[0].getSourceRange().getOffset() <= offset) {
                this.setReplacementString(impRewrite.addImport(this.getReplacementString()));
                return true;
            }
        }
        return false;
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            boolean importAdded;
            ImportRewrite impRewrite = null;
            if (this.fCompilationUnit != null && this.allowAddingImports()) {
                impRewrite = StubUtility.createImportRewrite(this.fCompilationUnit, true);
            }
            if (importAdded = this.updateReplacementString(document, trigger, offset, impRewrite)) {
                this.setCursorPosition(this.getReplacementString().length());
            }
            super.apply(document, trigger, offset);
            if (importAdded && impRewrite != null) {
                int oldLen = document.getLength();
                impRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()).apply(document, 2);
                this.setReplacementOffset(this.getReplacementOffset() + document.getLength() - oldLen);
            }
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaScriptPlugin.log(e);
        }
    }

    private boolean allowAddingImports() {
        IPreferenceStore preferenceStore = JavaScriptPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getBoolean("content_assist_add_import");
    }

    protected boolean isValidPrefix(String prefix) {
        return super.isValidPrefix(prefix) || this.isPrefix(prefix, this.fUnqualifiedTypeName) || this.isPrefix(prefix, this.fFullyQualifiedTypeName);
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.fUnqualifiedTypeName;
    }
}

