/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ejb.ui.internal.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.ejb.ui.internal.actions.AbstractClientJARAction;
import org.eclipse.jst.ejb.ui.internal.wizard.EJBClientComponentCreationWizard;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EjbClientJarCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.ejb.provider.GroupedEJBItemProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.osgi.framework.Bundle;

public class EJBClientCreationAction
extends AbstractClientJARAction {
    public static String LABEL = Platform.getResourceString((Bundle)Platform.getBundle((String)"org.eclipse.jst.ejb.ui"), (String)"%ejb.client.jar.creation.action.description_ui_");

    public EJBClientCreationAction() {
        this.setText(LABEL);
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor("ejbclientjar_wiz"));
    }

    protected void primRun(Shell shell) {
        if (this.getSelectedProject() == null) {
            return;
        }
        if (!this.checkBinaryProject(shell) || !this.checkEARProject(shell)) {
            return;
        }
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new EjbClientJarCreationDataModelProvider());
        dm.setProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME", (Object)this.getSelectedProject().getName());
        EJBClientComponentCreationWizard wizard = new EJBClientComponentCreationWizard(dm);
        J2EEUIPlugin plugin = J2EEUIPlugin.getDefault();
        wizard.setDialogSettings(plugin.getDialogSettings());
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(500, 550);
        dialog.open();
    }

    private boolean checkEARProject(Shell shell) {
        if (!this.hasEARProject()) {
            MessageDialog.openError((Shell)shell, (String)EJBCreationResourceHandler.EJB_Client_JAR_Creation_Error_, (String)EJBCreationResourceHandler.Cannot_Be_StandAlone_Project_For_Client_);
            return false;
        }
        return true;
    }

    private boolean checkBinaryProject(Shell shell) {
        if (this.isBinaryProject()) {
            MessageDialog.openError((Shell)shell, (String)EJBCreationResourceHandler.EJB_Client_JAR_Creation_Error_, (String)EJBCreationResourceHandler.Cannot_Be_Binary_Project_For_Client_);
            return false;
        }
        return true;
    }

    private boolean hasEARProject() {
        IProject project = this.getSelectedProject();
        return !J2EEProjectUtilities.isStandaloneProject((IProject)project);
    }

    private boolean isBinaryProject() {
        IProject project = this.getSelectedProject();
        return JemProjectUtilities.isBinaryProject((IProject)project);
    }

    private IProject getSelectedProject() {
        if (this.selection.getFirstElement() instanceof EJBJar) {
            EJBJar selProject = (EJBJar)this.selection.getFirstElement();
            return ProjectUtilities.getProject((EObject)selProject);
        }
        if (this.selection.getFirstElement() instanceof IProject) {
            return (IProject)this.selection.getFirstElement();
        }
        if (this.selection.getFirstElement() instanceof IJavaProject) {
            return ((IJavaProject)this.selection.getFirstElement()).getProject();
        }
        if (this.selection.getFirstElement() instanceof GroupedEJBItemProvider && ((GroupedEJBItemProvider)this.selection.getFirstElement()).getParent() instanceof EJBJar) {
            EJBJar jar = (EJBJar)((GroupedEJBItemProvider)this.selection.getFirstElement()).getParent();
            return ProjectUtilities.getProject((EObject)jar);
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (this.hasClientJar()) {
            action.setEnabled(false);
        } else {
            action.setEnabled(true);
        }
    }
}

