/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.command;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.internal.command.J2EEClipboard;
import org.eclipse.jst.j2ee.internal.provider.J2EEUIEditingDomain;
import org.eclipse.wst.common.internal.emf.utilities.CopyGroup;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class J2EECopyFromClipboardCommand
extends AbstractCommand {
    private J2EEUIEditingDomain domain;
    private J2EEClipboard result;
    private EtoolsCopyUtility copyUtil;

    public J2EECopyFromClipboardCommand(J2EEUIEditingDomain editingDomain) {
        this.domain = editingDomain;
    }

    public void execute() {
        if (this.copyUtil != null) {
            return;
        }
        this.copyUtil = new EtoolsCopyUtility();
        J2EEClipboard clipboard = this.domain.getJ2EEClipboard();
        this.result = new J2EEClipboard((Collection)new ArrayList(0));
        int i = 0;
        while (i < clipboard.size()) {
            EObject ext;
            CopyGroup group = new CopyGroup();
            EObject o = (EObject)clipboard.get(i);
            group.add(o);
            EObject bnd = clipboard.getBinding(o);
            if (bnd != null) {
                group.add(bnd);
            }
            if ((ext = clipboard.getExtension(o)) != null) {
                group.add(ext);
            }
            this.copyUtil.copy(group);
            EObject copy = this.copyUtil.getCopy(o);
            this.result.add(copy);
            if (bnd != null) {
                this.result.addBinding(copy, this.copyUtil.getCopy(bnd));
            }
            if (ext != null) {
                this.result.addExtension(copy, this.copyUtil.getCopy(ext));
            }
            ++i;
        }
        this.copyUtil = null;
    }

    public Collection getAffectedObjects() {
        return this.result;
    }

    public Collection getResult() {
        return this.result;
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        this.result = null;
    }
}

