/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.widgets;

import org.eclipse.jpt.ui.internal.widgets.AbstractDialog;
import org.eclipse.jpt.utility.internal.node.Node;
import org.eclipse.jpt.utility.internal.node.Problem;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidatingDialog<T extends Node>
extends AbstractDialog<T> {
    public AbstractValidatingDialog(Shell parent) {
        super(parent);
    }

    public AbstractValidatingDialog(Shell parent, String title) {
        super(parent, title);
    }

    @Override
    final Node.Validator buildValidator() {
        return new Node.Validator(){

            public void pause() {
            }

            public void resume() {
            }

            public void validate() {
                AbstractValidatingDialog.this.validate();
            }
        };
    }

    protected final void clearErrorMessage() {
        this.setErrorMessage(null);
    }

    protected String description() {
        return null;
    }

    protected Image descriptionImage() {
        return null;
    }

    protected String descriptionTitle() {
        return null;
    }

    protected Point getInitialSize() {
        Point result = this.getShell().computeSize(-1, -1);
        Point paneSize = this.pane().getControl().computeSize(-1, -1);
        int width = this.convertHorizontalDLUsToPixels(400);
        result.x = Math.max(width, paneSize.x);
        return result;
    }

    @Override
    protected final boolean hasTitleArea() {
        return true;
    }

    @Override
    protected void initializeUI() {
        Image image;
        String description;
        super.initializeUI();
        String descriptionTitle = this.descriptionTitle();
        if (descriptionTitle != null) {
            this.setTitle(descriptionTitle);
        }
        if ((description = this.description()) != null) {
            this.setMessage(description);
        }
        if ((image = this.descriptionImage()) != null) {
            this.setTitleImage(image);
        }
    }

    protected final void setErrorMessage(String errorMessage, Object ... arguments) {
        this.setErrorMessage(NLS.bind((String)errorMessage, (Object[])arguments));
    }

    private void updateErrorMessage() {
        if (this.subject().hasBranchProblems()) {
            Problem problem = (Problem)this.subject().branchProblems().next();
            this.setErrorMessage(problem.messageKey(), problem.messageArguments());
        } else {
            this.clearErrorMessage();
        }
    }

    private void validate() {
        this.subject().validateBranch();
        this.updateErrorMessage();
        this.getButton(0).setEnabled(!this.subject().hasBranchProblems());
    }
}

