/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.ui.internal.navigator.AbstractDDNode;
import org.eclipse.jst.jee.ui.internal.navigator.AbstractGroupProvider;
import org.eclipse.jst.jee.ui.internal.navigator.JEE5ContentProvider;
import org.eclipse.jst.jee.ui.internal.navigator.JndiRefNode;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.ActivationConfigProperties;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.BeanInterfaceNode;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.BeanNode;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.GroupEJBProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3ContentProvider
extends JEE5ContentProvider {
    public Object[] getChildren(Object aParentElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        IProject project = null;
        if (aParentElement instanceof AbstractGroupProvider) {
            List lst = ((AbstractGroupProvider)aParentElement).getChildren();
            children.addAll(lst);
        } else if (aParentElement instanceof AbstractDDNode) {
            List lst = ((AbstractDDNode)aParentElement).getChildren();
            children.addAll(lst);
        } else if (aParentElement instanceof SessionBean) {
            SessionBean sb = (SessionBean)aParentElement;
            this.addSessionBeanSubNodes(sb, children);
        } else if (aParentElement instanceof EntityBean) {
            EntityBean eb = (EntityBean)aParentElement;
            this.addEntityBeanSubNodes(eb, children);
        } else if (aParentElement instanceof MessageDrivenBean) {
            BeanNode msgBean = new BeanNode((JavaEEObject)((MessageDrivenBean)aParentElement));
            this.addActivationConfigProperties((MessageDrivenBean)aParentElement, children);
            children.add(msgBean);
        } else if (aParentElement instanceof IAdaptable && (project = (IProject)((IAdaptable)aParentElement).getAdapter(IPROJECT_CLASS)) != null && this.isEjbModuleProject(project)) {
            GroupEJBProvider root = (GroupEJBProvider)this.getCachedContentProvider(project);
            children.add(root);
        }
        return children.toArray();
    }

    private void addActivationConfigProperties(MessageDrivenBean parentElement, List<Object> children) {
        if (parentElement.getActivationConfig() != null && parentElement.getActivationConfig().getActivationConfigProperties() != null && !parentElement.getActivationConfig().getActivationConfigProperties().isEmpty()) {
            children.add(new ActivationConfigProperties(parentElement.getActivationConfig().getActivationConfigProperties()));
        }
    }

    private void addEntityBeanSubNodes(EntityBean eb, List<Object> children) {
        if (eb.getLocal() != null) {
            children.add(new BeanInterfaceNode(eb, eb.getLocal(), 2));
        }
        if (eb.getLocalHome() != null) {
            children.add(new BeanInterfaceNode(eb, eb.getLocalHome(), 3));
        }
        if (eb.getRemote() != null) {
            children.add(new BeanInterfaceNode(eb, eb.getRemote(), 4));
        }
        if (eb.getHome() != null) {
            children.add(new BeanInterfaceNode(eb, eb.getHome(), 5));
        }
        children.add(new BeanNode((JavaEEObject)eb));
    }

    private void addSessionBeanSubNodes(SessionBean sb, List children) {
        this.addClassRelatedInfo(sb, children);
        this.addSessionJNDIRefInfo(sb, children);
    }

    private void addSessionJNDIRefInfo(SessionBean sb, List children) {
        if (sb.getEjbLocalRefs() != null && !sb.getEjbLocalRefs().isEmpty()) {
            children.add(new JndiRefNode(sb.getEjbLocalRefs(), 0));
        }
        if (sb.getEjbRefs() != null && !sb.getEjbRefs().isEmpty()) {
            children.add(new JndiRefNode(sb.getEjbRefs(), 1));
        }
        if (sb.getResourceEnvRefs() != null && !sb.getResourceEnvRefs().isEmpty()) {
            children.add(new JndiRefNode(sb.getResourceEnvRefs(), 3));
        }
        if (sb.getEnvEntries() != null && !sb.getEnvEntries().isEmpty()) {
            children.add(new JndiRefNode(sb.getEnvEntries(), 2));
        }
        if (sb.getResourceRefs() != null && !sb.getResourceRefs().isEmpty()) {
            children.add(new JndiRefNode(sb.getResourceRefs(), 4));
        }
        if (sb.getServiceRefs() != null && !sb.getServiceRefs().isEmpty()) {
            children.add(new JndiRefNode(sb.getServiceRefs(), 5));
        }
    }

    private void addSessionJNDIRefInfo(EntityBean eb, List children) {
        if (eb.getEjbLocalRefs() != null && !eb.getEjbLocalRefs().isEmpty()) {
            children.add(new JndiRefNode(eb.getEjbLocalRefs(), 0));
        }
        if (eb.getEjbRefs() != null && !eb.getEjbRefs().isEmpty()) {
            children.add(new JndiRefNode(eb.getEjbRefs(), 1));
        }
        if (eb.getResourceEnvRefs() != null && !eb.getResourceEnvRefs().isEmpty()) {
            children.add(new JndiRefNode(eb.getResourceEnvRefs(), 3));
        }
        if (eb.getEnvEntries() != null && !eb.getEnvEntries().isEmpty()) {
            children.add(new JndiRefNode(eb.getEnvEntries(), 2));
        }
        if (eb.getResourceRefs() != null && !eb.getResourceRefs().isEmpty()) {
            children.add(new JndiRefNode(eb.getResourceRefs(), 4));
        }
        if (eb.getServiceRefs() != null && !eb.getServiceRefs().isEmpty()) {
            children.add(new JndiRefNode(eb.getServiceRefs(), 5));
        }
    }

    private void addClassRelatedInfo(SessionBean sb, List children) {
        if (sb.getLocal() != null) {
            children.add(new BeanInterfaceNode(sb, sb.getLocal(), 2));
        }
        if (sb.getLocalHome() != null) {
            children.add(new BeanInterfaceNode(sb, sb.getLocalHome(), 3));
        }
        if (sb.getRemote() != null) {
            children.add(new BeanInterfaceNode(sb, sb.getRemote(), 4));
        }
        if (sb.getHome() != null) {
            children.add(new BeanInterfaceNode(sb, sb.getHome(), 5));
        }
        if (sb.getEjbClass() != null) {
            children.add(new BeanNode((JavaEEObject)sb));
        }
        List r = sb.getBusinessLocals();
        for (Object locals : r) {
            children.add(new BeanInterfaceNode(sb, (String)locals, 0));
        }
        r = sb.getBusinessRemotes();
        for (Object locals : r) {
            children.add(new BeanInterfaceNode(sb, (String)locals, 1));
        }
    }

    private boolean isEjbModuleProject(IProject project) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            IProjectFacetVersion installedVersion = facetedProject.getInstalledVersion(ProjectFacetsManager.getProjectFacet((String)"jst.ejb").getVersion(IJ2EEFacetConstants.EJB_30.getVersionString()).getProjectFacet());
            return installedVersion != null;
        }
        catch (CoreException e) {
            JEEUIPlugin.logError("Can not acces project", (Exception)((Object)e));
            return false;
        }
    }

    public boolean hasChildren(Object element) {
        if (element instanceof AbstractGroupProvider) {
            return ((AbstractGroupProvider)element).hasChildren();
        }
        if (element instanceof AbstractDDNode) {
            return ((AbstractDDNode)element).hasChildren();
        }
        if (element instanceof SessionBean) {
            return true;
        }
        if (element instanceof EntityBean) {
            return true;
        }
        return element instanceof MessageDrivenBean;
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    @Override
    protected AbstractGroupProvider getNewContentProviderInstance(IProject project) {
        IModelProvider cachedModelProvider = this.getCachedModelProvider(project);
        GroupEJBProvider root = new GroupEJBProvider((EJBJar)cachedModelProvider.getModelObject());
        root.setProjectName(project.getName());
        return root;
    }
}

