/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.ui.internal.wizards.gen;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.wizards.gen.GenerateDynamicEntitiesFromNoSqlDb;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class NoSqlConnectionConfigPage
extends WizardPage {
    private Label databaseNameLabel;
    private Text databaseNameText;
    private Label hostLabel;
    private Text hostText;
    private Label portLabel;
    private Text portText;
    private Label rowSampleSizeLabel;
    private Text rowSampleSizeText;

    public NoSqlConnectionConfigPage() {
        super("NoSqlConnectionConfigPage");
        this.setTitle("NoSQL Connection Configuration");
        this.setDescription("Configure the NoSQL database connection.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 2;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        Link populateConnectionSettingsLink = new Link(composite, 0);
        GridData data = new GridData(1, 2, false, false);
        data.horizontalSpan = 2;
        populateConnectionSettingsLink.setLayoutData((Object)data);
        populateConnectionSettingsLink.setText("<a>Populate from persistence.xml settings (if available)</a>");
        populateConnectionSettingsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NoSqlConnectionConfigPage.this.attemptPopulateConnectionInfo();
            }
        });
        this.createConnectionConfigurationGroup(composite);
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    private void createConnectionConfigurationGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        this.databaseNameLabel = new Label(composite, 16384);
        this.databaseNameLabel.setText("Database Name:");
        this.databaseNameLabel.setLayoutData((Object)new GridData(32));
        this.databaseNameText = new Text(composite, 2052);
        this.databaseNameText.setLayoutData((Object)new GridData(768));
        this.databaseNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NoSqlConnectionConfigPage.this.handleDatabaseNameTextModified();
            }
        });
        this.hostLabel = new Label(composite, 16384);
        this.hostLabel.setText("Host:");
        this.hostLabel.setLayoutData((Object)new GridData(32));
        this.hostText = new Text(composite, 2052);
        this.hostText.setLayoutData((Object)new GridData(768));
        this.hostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NoSqlConnectionConfigPage.this.handleHostTextModified();
            }
        });
        this.portLabel = new Label(composite, 16384);
        this.portLabel.setText("Port:");
        this.portLabel.setLayoutData((Object)new GridData(32));
        this.portText = new Text(composite, 2052);
        this.portText.setLayoutData((Object)new GridData(768));
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NoSqlConnectionConfigPage.this.handlePortTextModified();
            }
        });
        this.rowSampleSizeLabel = new Label(composite, 16384);
        this.rowSampleSizeLabel.setText("Collection Row Sample Size: ");
        this.rowSampleSizeLabel.setLayoutData((Object)new GridData(32));
        this.rowSampleSizeText = new Text(composite, 2052);
        this.rowSampleSizeText.setLayoutData((Object)new GridData(768));
        this.rowSampleSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NoSqlConnectionConfigPage.this.handleRowSampleSizeTextModified();
            }
        });
    }

    protected void handleRowSampleSizeTextModified() {
        this.getCustomizer().setProperty("rowSampleSizeText", this.rowSampleSizeText.getText(), null, null);
    }

    protected void handlePortTextModified() {
        this.getCustomizer().setProperty("portText", this.portText.getText(), null, null);
    }

    protected void handleHostTextModified() {
        this.getCustomizer().setProperty("hostText", this.hostText.getText(), null, null);
    }

    protected void handleDatabaseNameTextModified() {
        this.getCustomizer().setProperty("databaseNameText", this.databaseNameText.getText(), null, null);
    }

    protected ORMGenCustomizer getCustomizer() {
        return this.getWizard().getCustomizer();
    }

    public GenerateDynamicEntitiesFromNoSqlDb getWizard() {
        return (GenerateDynamicEntitiesFromNoSqlDb)super.getWizard();
    }

    void attemptPopulateConnectionInfo() {
        this.databaseNameText.setText(this.getMongoDBConnectionPropertyValue("eclipselink.nosql.property.mongo.db"));
        this.hostText.setText(this.getMongoDBConnectionPropertyValue("eclipselink.nosql.property.mongo.host"));
        this.portText.setText(this.getMongoDBConnectionPropertyValue("eclipselink.nosql.property.mongo.port"));
    }

    private String getMongoDBConnectionPropertyValue(String connectionProperty) {
        JpaProject jpaProject = this.getWizard().getJpaProject();
        PersistenceUnit.Property property = jpaProject.getRootContextNode().getPersistenceXml().getRoot().getPersistenceUnit(0).getProperty(connectionProperty);
        return property == null ? "" : property.getValue();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ORMGenCustomizer customizer = this.getCustomizer();
            String databaseName = customizer.getProperty("databaseNameText", null, null);
            this.databaseNameText.setText(databaseName == null ? "" : databaseName);
            String host = customizer.getProperty("hostText", null, null);
            this.hostText.setText(host == null ? "" : host);
            String port = customizer.getProperty("portText", null, null);
            this.portText.setText(port == null ? "" : port);
            String rowSampleSize = customizer.getProperty("rowSampleSizeText", null, null);
            this.rowSampleSizeText.setText(rowSampleSize == null ? "" : rowSampleSize);
        }
    }
}

