/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.core.internal.libval;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jpt.common.core.internal.libval.LibraryValidatorTools;
import org.eclipse.jpt.common.core.libprov.JptLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.common.core.libval.LibraryValidator;
import org.eclipse.jpt.jpa.core.internal.libprov.JpaOsgiBundlesLibraryProviderInstallOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.osgi.OsgiBundlesLibraryProviderInstallOperationConfig;
import org.eclipse.osgi.service.resolver.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkEclipseLinkBundlesLibraryValidator
implements LibraryValidator {
    private static final HashMap<String, HashMap<String, VersionRange>> PLATFORM_BUNDLE_VERSION_RANGES = EclipseLinkEclipseLinkBundlesLibraryValidator.buildPlatformBundleVersionRanges();

    public IStatus validate(JptLibraryProviderInstallOperationConfig config) {
        return this.validate((JpaOsgiBundlesLibraryProviderInstallOperationConfig)config);
    }

    private IStatus validate(JpaOsgiBundlesLibraryProviderInstallOperationConfig config) {
        String jpaPlatformID = config.getJpaPlatformConfig().getId();
        HashMap<String, VersionRange> bundleVersionRanges = PLATFORM_BUNDLE_VERSION_RANGES.get(jpaPlatformID);
        return LibraryValidatorTools.validateBundleVersions((OsgiBundlesLibraryProviderInstallOperationConfig)config, bundleVersionRanges);
    }

    private static HashMap<String, HashMap<String, VersionRange>> buildPlatformBundleVersionRanges() {
        HashMap<String, HashMap<String, VersionRange>> versionRanges = new HashMap<String, HashMap<String, VersionRange>>();
        versionRanges.put("org.eclipse.eclipselink.platform", EclipseLinkEclipseLinkBundlesLibraryValidator.buildEclipseLink1_0BundleVersionRanges());
        versionRanges.put("eclipselink1_1", EclipseLinkEclipseLinkBundlesLibraryValidator.buildEclipseLink1_1BundleVersionRanges());
        versionRanges.put("eclipselink1_2", EclipseLinkEclipseLinkBundlesLibraryValidator.buildEclipseLink1_2BundleVersionRanges());
        versionRanges.put("eclipselink2_0", EclipseLinkEclipseLinkBundlesLibraryValidator.buildEclipseLink2_0BundleVersionRanges());
        versionRanges.put("eclipselink2_1", EclipseLinkEclipseLinkBundlesLibraryValidator.buildEclipseLink2_1BundleVersionRanges());
        versionRanges.put("eclipselink2_2", EclipseLinkEclipseLinkBundlesLibraryValidator.buildEclipseLink2_2BundleVersionRanges());
        versionRanges.put("eclipselink2_3", EclipseLinkEclipseLinkBundlesLibraryValidator.buildEclipseLink2_3BundleVersionRanges());
        versionRanges.put("eclipselink2_4", EclipseLinkEclipseLinkBundlesLibraryValidator.buildEclipseLink2_4BundleVersionRanges());
        versionRanges.put("eclipselink_nosql_2_5", EclipseLinkEclipseLinkBundlesLibraryValidator.buildEclipseLink2_5BundleVersionRanges());
        return versionRanges;
    }

    private static HashMap<String, VersionRange> buildEclipseLink1_0BundleVersionRanges() {
        HashMap<String, VersionRange> versionRanges = new HashMap<String, VersionRange>();
        versionRanges.put("org.eclipse.persistence.core", new VersionRange("[1.0, 3.0)"));
        versionRanges.put("org.eclipse.persistence.jpa", new VersionRange("[1.0, 3.0)"));
        versionRanges.put("org.eclipse.persistence.asm", new VersionRange("[1.0, 3.0)"));
        versionRanges.put("org.eclipse.persistence.antlr", new VersionRange("[1.0, 3.0)"));
        return versionRanges;
    }

    private static HashMap<String, VersionRange> buildEclipseLink1_1BundleVersionRanges() {
        HashMap<String, VersionRange> versionRanges = new HashMap<String, VersionRange>();
        versionRanges.put("org.eclipse.persistence.core", new VersionRange("[1.1, 3.0)"));
        versionRanges.put("org.eclipse.persistence.jpa", new VersionRange("[1.1, 3.0)"));
        versionRanges.put("org.eclipse.persistence.asm", new VersionRange("[1.1, 3.0)"));
        versionRanges.put("org.eclipse.persistence.antlr", new VersionRange("[1.1, 3.0)"));
        return versionRanges;
    }

    private static HashMap<String, VersionRange> buildEclipseLink1_2BundleVersionRanges() {
        HashMap<String, VersionRange> versionRanges = new HashMap<String, VersionRange>();
        versionRanges.put("org.eclipse.persistence.core", new VersionRange("[1.2, 3.0)"));
        versionRanges.put("org.eclipse.persistence.jpa", new VersionRange("[1.2, 3.0)"));
        versionRanges.put("org.eclipse.persistence.asm", new VersionRange("[1.2, 3.0)"));
        versionRanges.put("org.eclipse.persistence.antlr", new VersionRange("[1.2, 3.0)"));
        return versionRanges;
    }

    private static HashMap<String, VersionRange> buildEclipseLink2_0BundleVersionRanges() {
        HashMap<String, VersionRange> versionRanges = new HashMap<String, VersionRange>();
        versionRanges.put("org.eclipse.persistence.core", new VersionRange("[2.0, 3.0)"));
        versionRanges.put("org.eclipse.persistence.jpa", new VersionRange("[2.0, 3.0)"));
        versionRanges.put("org.eclipse.persistence.asm", new VersionRange("[2.0, 3.0)"));
        versionRanges.put("org.eclipse.persistence.antlr", new VersionRange("[2.0, 3.0)"));
        return versionRanges;
    }

    private static HashMap<String, VersionRange> buildEclipseLink2_1BundleVersionRanges() {
        HashMap<String, VersionRange> versionRanges = new HashMap<String, VersionRange>();
        versionRanges.put("org.eclipse.persistence.core", new VersionRange("[2.1, 3.0)"));
        versionRanges.put("org.eclipse.persistence.jpa", new VersionRange("[2.1, 3.0)"));
        versionRanges.put("org.eclipse.persistence.asm", new VersionRange("[2.1, 3.0)"));
        versionRanges.put("org.eclipse.persistence.antlr", new VersionRange("[2.1, 3.0)"));
        return versionRanges;
    }

    private static HashMap<String, VersionRange> buildEclipseLink2_2BundleVersionRanges() {
        HashMap<String, VersionRange> versionRanges = new HashMap<String, VersionRange>();
        versionRanges.put("org.eclipse.persistence.core", new VersionRange("[2.2, 3.0)"));
        versionRanges.put("org.eclipse.persistence.jpa", new VersionRange("[2.2, 3.0)"));
        versionRanges.put("org.eclipse.persistence.asm", new VersionRange("[2.2, 3.0)"));
        versionRanges.put("org.eclipse.persistence.antlr", new VersionRange("[2.2, 3.0)"));
        return versionRanges;
    }

    private static HashMap<String, VersionRange> buildEclipseLink2_3BundleVersionRanges() {
        HashMap<String, VersionRange> versionRanges = new HashMap<String, VersionRange>();
        versionRanges.put("org.eclipse.persistence.core", new VersionRange("[2.3, 3.0)"));
        versionRanges.put("org.eclipse.persistence.jpa", new VersionRange("[2.3, 3.0)"));
        versionRanges.put("org.eclipse.persistence.asm", new VersionRange("[2.3, 3.0)"));
        versionRanges.put("org.eclipse.persistence.antlr", new VersionRange("[2.3, 3.0)"));
        return versionRanges;
    }

    private static HashMap<String, VersionRange> buildEclipseLink2_4BundleVersionRanges() {
        HashMap<String, VersionRange> versionRanges = new HashMap<String, VersionRange>();
        versionRanges.put("org.eclipse.persistence.core", new VersionRange("[2.4, 3.0)"));
        versionRanges.put("org.eclipse.persistence.jpa", new VersionRange("[2.4, 3.0)"));
        versionRanges.put("org.eclipse.persistence.asm", new VersionRange("[2.4, 3.0)"));
        versionRanges.put("org.eclipse.persistence.antlr", new VersionRange("[2.4, 3.0)"));
        return versionRanges;
    }

    private static HashMap<String, VersionRange> buildEclipseLink2_5BundleVersionRanges() {
        HashMap<String, VersionRange> versionRanges = new HashMap<String, VersionRange>();
        versionRanges.put("org.eclipse.persistence.core", new VersionRange("[2.5, 3.0)"));
        versionRanges.put("org.eclipse.persistence.jpa", new VersionRange("[2.5, 3.0)"));
        versionRanges.put("org.eclipse.persistence.asm", new VersionRange("[2.5, 3.0)"));
        versionRanges.put("org.eclipse.persistence.antlr", new VersionRange("[2.5, 3.0)"));
        return versionRanges;
    }
}

