/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextNode;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlObjectTypeConverter;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.nosql.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.java.JavaEclipseLinkConversionValue;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.java.JavaEclipseLinkObjectTypeConverter;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm.OrmEclipseLinkConversionValue;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm.OrmEclipseLinkConverter;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmEclipseLinkObjectTypeConverter
extends OrmEclipseLinkConverter<XmlObjectTypeConverter>
implements EclipseLinkObjectTypeConverter {
    private String dataType;
    private String fullyQualifiedDataType;
    private String objectType;
    private String fullyQualifiedObjectType;
    protected final AbstractJpaNode.ContextListContainer<OrmEclipseLinkConversionValue, XmlConversionValue> conversionValueContainer;
    private String defaultObjectValue;

    public OrmEclipseLinkObjectTypeConverter(JpaContextNode parent, XmlObjectTypeConverter xmlConverter) {
        super(parent, xmlConverter);
        this.dataType = xmlConverter.getDataType();
        this.objectType = xmlConverter.getObjectType();
        this.conversionValueContainer = this.buildConversionValueContainer();
        this.defaultObjectValue = xmlConverter.getDefaultObjectValue();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setDataType_(((XmlObjectTypeConverter)this.xmlConverter).getDataType());
        this.setObjectType_(((XmlObjectTypeConverter)this.xmlConverter).getObjectType());
        this.syncConversionValues();
        this.setDefaultObjectValue_(((XmlObjectTypeConverter)this.xmlConverter).getDefaultObjectValue());
    }

    @Override
    public void update() {
        super.update();
        this.setFullyQualifiedDataType(this.buildFullyQualifiedDataType());
        this.setFullyQualifiedObjectType(this.buildFullyQualifiedObjectType());
        this.updateNodes((Iterable)this.getConversionValues());
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String dataType) {
        this.setDataType_(dataType);
        ((XmlObjectTypeConverter)this.xmlConverter).setDataType(dataType);
    }

    protected void setDataType_(String dataType) {
        String old = this.dataType;
        this.dataType = dataType;
        this.firePropertyChanged("dataType", old, dataType);
    }

    @Override
    public String getFullyQualifiedDataType() {
        return this.fullyQualifiedDataType;
    }

    protected void setFullyQualifiedDataType(String dataType) {
        String old = this.fullyQualifiedDataType;
        this.fullyQualifiedDataType = dataType;
        this.firePropertyChanged("fullyQualifiedDataType", old, dataType);
    }

    protected String buildFullyQualifiedDataType() {
        return this.getMappingFileRoot().qualify(this.dataType);
    }

    protected boolean dataTypeIsFor(String typeName) {
        return this.typeIsFor(this.getDataTypeJavaResourceType(), typeName);
    }

    protected boolean dataTypeIsIn(IPackageFragment packageFragment) {
        return this.typeIsIn(this.getDataTypeJavaResourceType(), packageFragment);
    }

    protected JavaResourceAbstractType getDataTypeJavaResourceType() {
        if (this.fullyQualifiedDataType == null) {
            return null;
        }
        return this.getJpaProject().getJavaResourceType(this.fullyQualifiedDataType);
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String objectType) {
        this.setObjectType_(objectType);
        ((XmlObjectTypeConverter)this.xmlConverter).setObjectType(objectType);
    }

    protected void setObjectType_(String objectType) {
        String old = this.objectType;
        this.objectType = objectType;
        this.firePropertyChanged("objectType", old, objectType);
    }

    @Override
    public String getFullyQualifiedObjectType() {
        return this.fullyQualifiedObjectType;
    }

    protected void setFullyQualifiedObjectType(String objectType) {
        String old = this.fullyQualifiedObjectType;
        this.fullyQualifiedObjectType = objectType;
        this.firePropertyChanged("fullyQualifiedObjectType", old, objectType);
    }

    protected String buildFullyQualifiedObjectType() {
        return this.getMappingFileRoot().qualify(this.objectType);
    }

    protected boolean objectTypeIsFor(String typeName) {
        return this.typeIsFor(this.getObjectTypeJavaResourceType(), typeName);
    }

    protected boolean objectTypeIsIn(IPackageFragment packageFragment) {
        return this.typeIsIn(this.getObjectTypeJavaResourceType(), packageFragment);
    }

    protected JavaResourceAbstractType getObjectTypeJavaResourceType() {
        if (this.fullyQualifiedObjectType == null) {
            return null;
        }
        return this.getJpaProject().getJavaResourceType(this.fullyQualifiedObjectType);
    }

    public ListIterable<OrmEclipseLinkConversionValue> getConversionValues() {
        return this.conversionValueContainer.getContextElements();
    }

    @Override
    public int getConversionValuesSize() {
        return this.conversionValueContainer.getContextElementsSize();
    }

    @Override
    public EclipseLinkConversionValue getConversionValue(int index) {
        return (EclipseLinkConversionValue)this.conversionValueContainer.get(index);
    }

    @Override
    public OrmEclipseLinkConversionValue addConversionValue() {
        return this.addConversionValue(this.getConversionValuesSize());
    }

    @Override
    public OrmEclipseLinkConversionValue addConversionValue(int index) {
        XmlConversionValue xmlConversionValue = this.buildXmlConversionValue();
        OrmEclipseLinkConversionValue conversionValue = (OrmEclipseLinkConversionValue)this.conversionValueContainer.addContextElement(index, (Object)xmlConversionValue);
        ((XmlObjectTypeConverter)this.xmlConverter).getConversionValues().add(index, (Object)xmlConversionValue);
        return conversionValue;
    }

    protected XmlConversionValue buildXmlConversionValue() {
        return EclipseLinkOrmFactory.eINSTANCE.createXmlConversionValue();
    }

    @Override
    public void removeConversionValue(EclipseLinkConversionValue conversionValue) {
        this.removeConversionValue(this.conversionValueContainer.indexOfContextElement((JpaContextNode)((OrmEclipseLinkConversionValue)conversionValue)));
    }

    @Override
    public void removeConversionValue(int index) {
        this.conversionValueContainer.removeContextElement(index);
        ((XmlObjectTypeConverter)this.xmlConverter).getConversionValues().remove(index);
    }

    @Override
    public void moveConversionValue(int targetIndex, int sourceIndex) {
        this.conversionValueContainer.moveContextElement(targetIndex, sourceIndex);
        ((XmlObjectTypeConverter)this.xmlConverter).getConversionValues().move(targetIndex, sourceIndex);
    }

    protected OrmEclipseLinkConversionValue buildConversionValue(XmlConversionValue xmlConversionValue) {
        return new OrmEclipseLinkConversionValue(this, xmlConversionValue);
    }

    protected void syncConversionValues() {
        this.conversionValueContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlConversionValue> getXmlConversionValues() {
        return IterableTools.cloneLive((List)((XmlObjectTypeConverter)this.xmlConverter).getConversionValues());
    }

    protected AbstractJpaNode.ContextListContainer<OrmEclipseLinkConversionValue, XmlConversionValue> buildConversionValueContainer() {
        ConversionValueContainer container = new ConversionValueContainer();
        container.initialize();
        return container;
    }

    @Override
    public Iterable<String> getDataValues() {
        return IterableTools.transform(this.getConversionValues(), EclipseLinkConversionValue.DATA_VALUE_TRANSFORMER);
    }

    @Override
    public int getDataValuesSize() {
        return this.getConversionValuesSize();
    }

    @Override
    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    @Override
    public void setDefaultObjectValue(String value) {
        this.setDefaultObjectValue_(value);
        ((XmlObjectTypeConverter)this.xmlConverter).setDefaultObjectValue(value);
    }

    protected void setDefaultObjectValue_(String value) {
        String old = this.defaultObjectValue;
        this.defaultObjectValue = value;
        this.firePropertyChanged("defaultObjectValue", old, value);
    }

    public Class<EclipseLinkObjectTypeConverter> getType() {
        return EclipseLinkObjectTypeConverter.class;
    }

    protected boolean typeIsFor(JavaResourceAbstractType type, String typeName) {
        return type != null && type.getTypeBinding().getQualifiedName().equals(typeName);
    }

    protected boolean typeIsIn(JavaResourceAbstractType type, IPackageFragment packageFragment) {
        return type != null && type.isIn(packageFragment);
    }

    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.createRenameDataTypeEdits(originalType, newName), this.createRenameObjectTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createRenameDataTypeEdits(IType originalType, String newName) {
        return this.dataTypeIsFor(originalType.getFullyQualifiedName('.')) ? IterableTools.singletonIterable((Object)this.createRenameDataTypeEdit(originalType, newName)) : IterableTools.emptyIterable();
    }

    protected ReplaceEdit createRenameDataTypeEdit(IType originalType, String newName) {
        return ((XmlObjectTypeConverter)this.xmlConverter).createRenameDataTypeEdit(originalType, newName);
    }

    protected Iterable<ReplaceEdit> createRenameObjectTypeEdits(IType originalType, String newName) {
        return this.objectTypeIsFor(originalType.getFullyQualifiedName('.')) ? IterableTools.singletonIterable((Object)this.createRenameObjectTypeEdit(originalType, newName)) : IterableTools.emptyIterable();
    }

    protected ReplaceEdit createRenameObjectTypeEdit(IType originalType, String newName) {
        return ((XmlObjectTypeConverter)this.xmlConverter).createRenameObjectTypeEdit(originalType, newName);
    }

    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.createMoveDataTypeEdits(originalType, newPackage), this.createMoveObjectTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createMoveDataTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.dataTypeIsFor(originalType.getFullyQualifiedName('.')) ? IterableTools.singletonIterable((Object)this.createRenameDataTypePackageEdit(newPackage.getElementName())) : IterableTools.emptyIterable();
    }

    protected ReplaceEdit createRenameDataTypePackageEdit(String newName) {
        return ((XmlObjectTypeConverter)this.xmlConverter).createRenameDataTypePackageEdit(newName);
    }

    protected Iterable<ReplaceEdit> createMoveObjectTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.objectTypeIsFor(originalType.getFullyQualifiedName('.')) ? IterableTools.singletonIterable((Object)this.createRenameObjectTypePackageEdit(newPackage.getElementName())) : IterableTools.emptyIterable();
    }

    protected ReplaceEdit createRenameObjectTypePackageEdit(String newName) {
        return ((XmlObjectTypeConverter)this.xmlConverter).createRenameObjectTypePackageEdit(newName);
    }

    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.createRenameDataTypePackageEdits(originalPackage, newName), this.createRenameObjectTypePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createRenameDataTypePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.dataTypeIsIn(originalPackage) ? IterableTools.singletonIterable((Object)this.createRenameDataTypePackageEdit(newName)) : IterableTools.emptyIterable();
    }

    protected Iterable<ReplaceEdit> createRenameObjectTypePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.objectTypeIsIn(originalPackage) ? IterableTools.singletonIterable((Object)this.createRenameObjectTypePackageEdit(newName)) : IterableTools.emptyIterable();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.checkForDuplicateDataValues(messages);
        for (OrmEclipseLinkConversionValue conversionValue : this.getConversionValues()) {
            conversionValue.validate(messages, reporter);
        }
    }

    protected void checkForDuplicateDataValues(List<IMessage> messages) {
        for (ArrayList<OrmEclipseLinkConversionValue> dups : this.mapConversionValuesByDataValue().values()) {
            if (dups.size() <= 1) continue;
            for (OrmEclipseLinkConversionValue dup : dups) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "MULTIPLE_OBJECT_VALUES_FOR_DATA_VALUE", new String[]{dup.getDataValue()}, (JpaNode)this, dup.getDataValueTextRange()));
            }
        }
    }

    protected HashMap<String, ArrayList<OrmEclipseLinkConversionValue>> mapConversionValuesByDataValue() {
        HashMap<String, ArrayList<OrmEclipseLinkConversionValue>> map = new HashMap<String, ArrayList<OrmEclipseLinkConversionValue>>(this.getConversionValuesSize());
        for (OrmEclipseLinkConversionValue conversionValue : this.getConversionValues()) {
            String dataValue = conversionValue.getDataValue();
            ArrayList<OrmEclipseLinkConversionValue> list = map.get(dataValue);
            if (list == null) {
                list = new ArrayList();
                map.put(dataValue, list);
            }
            list.add(conversionValue);
        }
        return map;
    }

    @Override
    public boolean isEquivalentTo(JpaNamedContextNode node) {
        return super.isEquivalentTo(node) && this.isEquivalentTo((EclipseLinkObjectTypeConverter)node);
    }

    protected boolean isEquivalentTo(EclipseLinkObjectTypeConverter converter) {
        return ObjectTools.equals((Object)this.fullyQualifiedObjectType, (Object)converter.getFullyQualifiedObjectType()) && ObjectTools.equals((Object)this.fullyQualifiedDataType, (Object)converter.getFullyQualifiedDataType()) && ObjectTools.equals((Object)this.defaultObjectValue, (Object)converter.getDefaultObjectValue()) && this.conversionValuesAreEquivalentTo(converter);
    }

    protected boolean conversionValuesAreEquivalentTo(EclipseLinkObjectTypeConverter converter) {
        ArrayList conversionValues1 = ListTools.list(this.getConversionValues());
        ArrayList conversionValues2 = ListTools.list(converter.getConversionValues());
        if (conversionValues1.size() != conversionValues2.size()) {
            return false;
        }
        int i = 0;
        while (i < conversionValues1.size()) {
            if (!((OrmEclipseLinkConversionValue)conversionValues1.get(i)).isEquivalentTo((EclipseLinkConversionValue)conversionValues2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void convertFrom(JavaEclipseLinkObjectTypeConverter javaConverter) {
        super.convertFrom(javaConverter);
        this.setDataType(javaConverter.getFullyQualifiedDataType());
        this.setObjectType(javaConverter.getFullyQualifiedObjectType());
        this.setDefaultObjectValue(javaConverter.getDefaultObjectValue());
        for (JavaEclipseLinkConversionValue value : javaConverter.getConversionValues()) {
            this.addConversionValue().convertFrom(value);
        }
    }

    public Iterable<String> getCompletionProposals(int pos) {
        Iterable result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.objectTypeTouches(pos)) {
            return this.getCandidateTypeNames();
        }
        if (this.dataTypeTouches(pos)) {
            return this.getCandidateTypeNames();
        }
        return null;
    }

    protected boolean objectTypeTouches(int pos) {
        return ((XmlObjectTypeConverter)this.xmlConverter).objectTypeTouches(pos);
    }

    protected boolean dataTypeTouches(int pos) {
        return ((XmlObjectTypeConverter)this.xmlConverter).dataTypeTouches(pos);
    }

    protected Iterable<String> getCandidateTypeNames() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{MappingTools.getPrimaryBasicTypeNamesWithoutPrimitives(), MappingTools.getBasicArrayTypeNames(), MappingTools.getSortedJavaEnumNames((IJavaProject)this.getJavaProject())});
    }

    protected boolean defaultObjectValueTouches(int pos) {
        return ((XmlObjectTypeConverter)this.xmlConverter).defaultObjectValueTouches(pos);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConversionValueContainer
    extends AbstractJpaNode.ContextListContainer<OrmEclipseLinkConversionValue, XmlConversionValue> {
        protected ConversionValueContainer() {
            super((AbstractJpaNode)OrmEclipseLinkObjectTypeConverter.this);
        }

        protected String getContextElementsPropertyName() {
            return "conversionValues";
        }

        protected OrmEclipseLinkConversionValue buildContextElement(XmlConversionValue resourceElement) {
            return OrmEclipseLinkObjectTypeConverter.this.buildConversionValue(resourceElement);
        }

        protected ListIterable<XmlConversionValue> getResourceElements() {
            return OrmEclipseLinkObjectTypeConverter.this.getXmlConversionValues();
        }

        protected XmlConversionValue getResourceElement(OrmEclipseLinkConversionValue contextElement) {
            return contextElement.getXmlConversionValue();
        }
    }
}

