/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextNode;
import org.eclipse.jpt.jpa.core.context.TypeRefactoringParticipant;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlNamedConverter;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.nosql.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.nosql.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.nosql.eclipselink.core.internal.context.java.JavaEclipseLinkConverter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrmEclipseLinkConverter<X extends XmlNamedConverter>
extends AbstractOrmXmlContextNode
implements EclipseLinkConverter,
TypeRefactoringParticipant {
    protected final X xmlConverter;
    protected String name;

    protected OrmEclipseLinkConverter(JpaContextNode parent, X xmlConverter) {
        super(parent);
        this.xmlConverter = xmlConverter;
        this.name = xmlConverter.getName();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.xmlConverter.getName());
    }

    public void update() {
        super.update();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.setName_(name);
        this.xmlConverter.setName(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    public X getXmlConverter() {
        return this.xmlConverter;
    }

    public EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    @Override
    public char getEnclosingTypeSeparator() {
        return '$';
    }

    @Override
    public boolean supportsValidationMessages() {
        return true;
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateName(messages);
    }

    protected void validateName(List<IMessage> messages) {
        if (StringTools.isBlank((String)this.name)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_NAME_UNDEFINED", EMPTY_STRING_ARRAY, (JpaNode)this, this.getNameTextRange()));
            return;
        }
        if (ArrayTools.contains((Object[])EclipseLinkConvert.RESERVED_CONVERTER_NAMES, (Object)this.name)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "RESERVED_CONVERTER_NAME", EMPTY_STRING_ARRAY, (JpaNode)this, this.getNameTextRange()));
        }
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlConverter.getValidationTextRange();
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.xmlConverter.getNameTextRange());
    }

    public boolean isEquivalentTo(JpaNamedContextNode node) {
        return this != node && this.getType() == node.getType() && ObjectTools.equals((Object)this.name, (Object)node.getName());
    }

    public void convertFrom(JavaEclipseLinkConverter<?> javaConverter) {
        this.setName(javaConverter.getName());
    }
}

