/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.wizard.functionblock;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.ui.handler.ModelGenerationTask;
import org.eclipse.vorto.codegen.ui.tasks.ProjectFileOutputter;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.core.ui.model.ModelProjectFactory;
import org.eclipse.vorto.wizard.AbstractVortoWizard;
import org.eclipse.vorto.wizard.functionblock.FbmodelTemplateFileContent;
import org.eclipse.vorto.wizard.functionblock.FunctionBlockWizardPage;

public class FunctionBlockWizard
extends AbstractVortoWizard
implements INewWizard {
    private IModelProject modelProject;
    private static final String SUFFIX = ".fbmodel";
    private FunctionBlockWizardPage iotWizardPage;
    private String modelFolder = "functionblocks/";

    public FunctionBlockWizard(IModelProject modelProject) {
        this.modelProject = modelProject;
    }

    public void addPages() {
        this.iotWizardPage = new FunctionBlockWizardPage("Function Block Wizard", this.modelProject);
        this.iotWizardPage.setTitle("Create Function Block Model");
        this.iotWizardPage.setDescription("Please enter the details for creating function block model project.");
        this.addPage((IWizardPage)this.iotWizardPage);
    }

    public boolean performFinish() {
        new ModelGenerationTask(SUFFIX, (ITemplate)new FbmodelTemplateFileContent(), this.modelFolder).generate((Object)this.iotWizardPage, InvocationContext.simpleInvocationContext(), (IGeneratedWriter)new ProjectFileOutputter(this.modelProject.getProject()));
        this.openFBModelWithDefaultEditor();
        return true;
    }

    private void openFBModelWithDefaultEditor() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.iotWizardPage.getProjectName());
        IModelProject modelProject = ModelProjectFactory.getInstance().getProject(project);
        final IFile modelFile = modelProject.getModelElementById(this.iotWizardPage.getModelId()).getModelFile();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWindow != null && (page = activeWindow.getActivePage()) != null) {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)modelFile);
                    }
                    catch (PartInitException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }
}

