/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.ui.handler;

import java.util.Collections;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.api.SingleFileContentCodeGeneratorTask;
import org.eclipse.vorto.codegen.api.ZipContentExtractCodeGeneratorTask;
import org.eclipse.vorto.codegen.ui.tasks.CopyResourceTask;
import org.eclipse.vorto.codegen.ui.tasks.EclipseProjectGenerator;
import org.eclipse.vorto.core.api.model.model.ModelId;

public class CodeGenerationHelper {
    public static void createEclipseProject(ModelId modelId, String serviceKey, IGenerationResult generatedResult) {
        byte[] generated = generatedResult.getContent();
        SingleFileContentCodeGeneratorTask task = null;
        String name = String.valueOf(modelId.getName()) + "_" + serviceKey + "_generated";
        boolean containsEclipseProject = false;
        boolean generateMaven = false;
        if (generatedResult.getFileName().endsWith(".zip")) {
            ZipContentExtractCodeGeneratorTask tmp = new ZipContentExtractCodeGeneratorTask(generated);
            tmp.preprocess();
            if (tmp.getEclipseProjectName() != null) {
                name = tmp.getEclipseProjectName();
                containsEclipseProject = true;
            } else {
                generateMaven = tmp.isMavenContent();
            }
            task = tmp;
        } else {
            task = new SingleFileContentCodeGeneratorTask(generatedResult.getFileName(), generated);
        }
        EclipseProjectGenerator<ModelId> generator = new EclipseProjectGenerator<ModelId>(name);
        generator.addTask((ICodeGeneratorTask<ModelId>)task);
        generator.generate(modelId, containsEclipseProject ? InvocationContext.simpleInvocationContext(Collections.singletonMap("skip.project.cfg", Boolean.TRUE.toString())) : InvocationContext.simpleInvocationContext(), (IProgressMonitor)new NullProgressMonitor());
        if (generateMaven) {
            CodeGenerationHelper.createMavenProjectFromGeneratedCode(generator);
        }
    }

    private static void createMavenProjectFromGeneratedCode(EclipseProjectGenerator<ModelId> generator) {
        IProject generatedTempProject = generator.getProject();
        try {
            try {
                IResource[] iResourceArray = generatedTempProject.members(2);
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource folderResource = iResourceArray[n2];
                    if (folderResource instanceof IFolder) {
                        EclipseProjectGenerator projectGenerator = new EclipseProjectGenerator(folderResource.getName());
                        projectGenerator.addNature("org.eclipse.m2e.core.maven2Nature");
                        projectGenerator.addTask(new CopyResourceTask(folderResource.getLocationURI().toURL(), ""));
                        projectGenerator.generate(folderResource, InvocationContext.simpleInvocationContext(), (IProgressMonitor)new NullProgressMonitor());
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not postprocess downloaded generated files", e);
            }
        }
        finally {
            CodeGenerationHelper.deleteTemporaryDownloadedProject(generatedTempProject);
        }
    }

    private static void deleteTemporaryDownloadedProject(IProject generatedTempProject) {
        try {
            generatedTempProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new RuntimeException("Problem deleting temp project", e);
        }
    }
}

