/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.coap.client.templates;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.examples.coap.CoAPUtils;
import org.eclipse.vorto.codegen.utils.Utils;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Param;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CoAPClientFunctionblockInterfaceTemplate
implements ITemplate<FunctionblockModel> {
    private String classPackage;
    private String interfacePrefix;
    private String[] imports;
    private ITemplate<Property> propertyTemplate;
    private ITemplate<Param> parameterTemplate;

    public CoAPClientFunctionblockInterfaceTemplate(String classPackage, String interfacePrefix, String[] imports, ITemplate<Property> propertyTemplate, ITemplate<Param> parameterTemplate) {
        this.classPackage = classPackage;
        this.interfacePrefix = interfacePrefix;
        this.imports = imports;
        this.propertyTemplate = propertyTemplate;
        this.parameterTemplate = parameterTemplate;
    }

    public String getContent(FunctionblockModel fbm, InvocationContext invocationContext) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)"*****************************************************************************************");
        _builder.newLine();
        _builder.append((Object)"* The present code has been generated by the Eclipse Vorto Java Code Generator.");
        _builder.newLine();
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"* The basis for the generation was the Functionblock which is uniquely identified by:");
        _builder.newLine();
        _builder.append((Object)"* Name:\t\t\t");
        String _name = fbm.getName();
        _builder.append((Object)_name, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"* Namespace:\t");
        String _namespace = fbm.getNamespace();
        _builder.append((Object)_namespace, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"* Version:\t\t");
        String _version = fbm.getVersion();
        _builder.append((Object)_version, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*****************************************************************************************");
        _builder.newLine();
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"package ");
        _builder.append((Object)this.classPackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String[] stringArray = this.imports;
        int n = this.imports.length;
        int n2 = 0;
        while (n2 < n) {
            String imprt = stringArray[n2];
            _builder.append((Object)"import ");
            _builder.append((Object)imprt, "");
            _builder.append((Object)".*;");
            _builder.newLineIfNotEmpty();
            ++n2;
        }
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* ");
        String _description = fbm.getDescription();
        _builder.append((Object)_description, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public interface ");
        _builder.append((Object)this.interfacePrefix, "");
        String _name_1 = fbm.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        FunctionBlock fb = fbm.getFunctionblock();
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Status _status = fb.getStatus();
        boolean bl = _notEquals = !Objects.equal((Object)_status, null);
        if (_notEquals) {
            Status _status_1 = fb.getStatus();
            EList _properties = _status_1.getProperties();
            for (Property property : _properties) {
                boolean _isReadable = Utils.isReadable((Property)property);
                if (_isReadable) {
                    PropertyType _type = property.getType();
                    if (_type instanceof ObjectPropertyType) {
                        _builder.append((Object)"\t");
                        String _propertyTypeAsString = CoAPUtils.getPropertyTypeAsString(property);
                        _builder.append((Object)_propertyTypeAsString, "\t");
                        _builder.append((Object)" get");
                        String _name_2 = property.getName();
                        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_2);
                        _builder.append((Object)_firstUpper_1, "\t");
                        _builder.append((Object)"();");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"\t");
                        String _propertyTypeAsString_1 = CoAPUtils.getPropertyTypeAsString(property);
                        _builder.append((Object)_propertyTypeAsString_1, "\t");
                        _builder.append((Object)" get");
                        String _name_3 = property.getName();
                        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
                        _builder.append((Object)_firstUpper_2, "\t");
                        _builder.append((Object)"() throws Exception;");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.newLine();
                boolean _isWritable = Utils.isWritable((Property)property);
                if (!_isWritable) continue;
                _builder.append((Object)"\t");
                _builder.append((Object)"void set");
                String _name_4 = property.getName();
                String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_4);
                _builder.append((Object)_firstUpper_3, "\t");
                _builder.append((Object)"(");
                String _propertyTypeAsString_2 = CoAPUtils.getPropertyTypeAsString(property);
                _builder.append((Object)_propertyTypeAsString_2, "\t");
                _builder.append((Object)" ");
                String _name_5 = property.getName();
                String _firstLower = StringExtensions.toFirstLower((String)_name_5);
                _builder.append((Object)_firstLower, "\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
        }
        _builder.newLine();
        EList _operations = fb.getOperations();
        for (Operation op : _operations) {
            _builder.append((Object)"\t");
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"* ");
            String _description_1 = op.getDescription();
            _builder.append((Object)_description_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"*/");
            _builder.newLine();
            boolean _or = false;
            ReturnType _returnType = op.getReturnType();
            if (_returnType instanceof ReturnObjectType) {
                _or = true;
            } else {
                boolean _equals;
                ReturnType _returnType_1 = op.getReturnType();
                _or = _equals = Objects.equal((Object)_returnType_1, null);
            }
            if (_or) {
                _builder.append((Object)"\t");
                String _returnTypeAsString = CoAPUtils.getReturnTypeAsString(op);
                _builder.append((Object)_returnTypeAsString, "\t");
                _builder.append((Object)" ");
                String _name_6 = op.getName();
                _builder.append((Object)_name_6, "\t");
                _builder.append((Object)"(");
                String _parameterString = this.getParameterString(op, invocationContext);
                _builder.append((Object)_parameterString, "\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t");
                String _returnTypeAsString_1 = CoAPUtils.getReturnTypeAsString(op);
                _builder.append((Object)_returnTypeAsString_1, "\t");
                _builder.append((Object)" ");
                String _name_7 = op.getName();
                _builder.append((Object)_name_7, "\t");
                _builder.append((Object)"(");
                String _parameterString_1 = this.getParameterString(op, invocationContext);
                _builder.append((Object)_parameterString_1, "\t");
                _builder.append((Object)") throws Exception;");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    public String getParameterString(Operation op, InvocationContext invocationContext) {
        String result = "";
        EList _params = op.getParams();
        for (Param param : _params) {
            String _plus;
            String _content = this.parameterTemplate.getContent((Object)param, invocationContext);
            result = _plus = String.valueOf(result) + ", " + _content;
        }
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)result);
        if (_isNullOrEmpty) {
            return "";
        }
        int _length = result.length();
        String _substring = result.substring(2, _length);
        String _replaceAll = _substring.replaceAll("\n", "");
        return _replaceAll.replaceAll("\r", "");
    }
}

