/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.coap;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.vorto.codegen.examples.templates.java.utils.ValueMapper;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Param;
import org.eclipse.vorto.core.api.model.functionblock.PrimitiveParam;
import org.eclipse.vorto.core.api.model.functionblock.RefParam;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CoAPUtils {
    public static String getParameterTypeAsString(Param parameter) {
        if (parameter instanceof PrimitiveParam) {
            PrimitiveType _type = ((PrimitiveParam)parameter).getType();
            return ValueMapper.mapSimpleDatatype((PrimitiveType)_type);
        }
        if (parameter instanceof RefParam) {
            RefParam object = (RefParam)parameter;
            Type _type_1 = object.getType();
            if (_type_1 instanceof Entity) {
                Type _type_2 = object.getType();
                String _name = ((Entity)_type_2).getName();
                return StringExtensions.toFirstUpper((String)_name);
            }
            Type _type_3 = object.getType();
            if (_type_3 instanceof Enum) {
                Type _type_4 = object.getType();
                String _name_1 = ((Enum)_type_4).getName();
                return StringExtensions.toFirstUpper((String)_name_1);
            }
        }
        return null;
    }

    public static String getPropertyTypeAsString(Property property) {
        PropertyType _type = property.getType();
        if (_type instanceof PrimitivePropertyType) {
            PropertyType _type_1 = property.getType();
            PrimitiveType _type_2 = ((PrimitivePropertyType)_type_1).getType();
            return ValueMapper.mapSimpleDatatype((PrimitiveType)_type_2);
        }
        PropertyType _type_3 = property.getType();
        if (_type_3 instanceof ObjectPropertyType) {
            PropertyType _type_4 = property.getType();
            ObjectPropertyType object = (ObjectPropertyType)_type_4;
            Type _type_5 = object.getType();
            if (_type_5 instanceof Entity) {
                Type _type_6 = object.getType();
                String _name = ((Entity)_type_6).getName();
                return StringExtensions.toFirstUpper((String)_name);
            }
            Type _type_7 = object.getType();
            if (_type_7 instanceof Enum) {
                Type _type_8 = object.getType();
                String _name_1 = ((Enum)_type_8).getName();
                return StringExtensions.toFirstUpper((String)_name_1);
            }
        }
        return null;
    }

    public static String getReturnTypeAsString(Operation op) {
        boolean _notEquals;
        ReturnType _returnType = op.getReturnType();
        boolean bl = _notEquals = !Objects.equal((Object)_returnType, null);
        if (_notEquals) {
            ReturnType returnType = op.getReturnType();
            if (returnType instanceof ReturnObjectType) {
                Type _returnType_1 = ((ReturnObjectType)returnType).getReturnType();
                return _returnType_1.getName();
            }
            if (returnType instanceof ReturnPrimitiveType) {
                PrimitiveType _returnType_2 = ((ReturnPrimitiveType)returnType).getReturnType();
                return _returnType_2.getName();
            }
        } else {
            return "void";
        }
        return null;
    }

    public static String getReturnNameAsString(ReturnType returnType) {
        if (returnType instanceof ReturnObjectType) {
            Type _returnType = ((ReturnObjectType)returnType).getReturnType();
            String _name = _returnType.getName();
            return StringExtensions.toFirstLower((String)_name);
        }
        if (returnType instanceof ReturnPrimitiveType) {
            return "returnValue";
        }
        return null;
    }

    public static EMap<FunctionblockModel, EList<FunctionblockProperty>> sortByPropertyType(EList<FunctionblockProperty> properties) {
        BasicEMap map = new BasicEMap();
        for (FunctionblockProperty property : properties) {
            FunctionblockModel _type = property.getType();
            boolean _containsKey = map.containsKey((Object)_type);
            if (_containsKey) {
                FunctionblockModel _type_1 = property.getType();
                EList eList = (EList)map.get((Object)_type_1);
                eList.add((Object)property);
                FunctionblockModel _type_2 = property.getType();
                map.put((Object)_type_2, (Object)eList);
                continue;
            }
            BasicEList eList_1 = new BasicEList();
            eList_1.add((Object)property);
            FunctionblockModel _type_3 = property.getType();
            map.put((Object)_type_3, (Object)eList_1);
        }
        return map;
    }
}

