/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ServiceManagerProxy {
    static Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, ServiceManagerProxy.class);
    private final Object serviceManager;
    private final Class serviceManagerClass;

    public ServiceManagerProxy() throws AlreadyStartedException {
        this(true);
    }

    public ServiceManagerProxy(boolean checkAlreadyStarted) throws AlreadyStartedException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.serviceManagerClass = classLoader.loadClass("org.apache.openejb.server.ServiceManager");
        }
        catch (ClassNotFoundException e) {
            String msg = "Enabling option 'openejb.embedded.remotable' requires class 'org.apache.openejb.server.ServiceManager' to be available.  Make sure you have the openejb-server-*.jar in your classpath and at least one protocol implementation such as openejb-ejbd-*.jar.";
            throw new IllegalStateException(msg, e);
        }
        Method get = this.getMethod("get", new Class[0]);
        Method getManager = this.getMethod("getManager", new Class[0]);
        if (checkAlreadyStarted && this.invoke(get, null, new Object[0]) != null) {
            throw new AlreadyStartedException("Server services already started");
        }
        this.serviceManager = this.invoke(getManager, null, new Object[0]);
        logger.info("Initializing network services");
        Method init = this.getMethod("init", new Class[0]);
        this.invoke(init, this.serviceManager, new Object[0]);
    }

    private Method getMethod(String name, Class ... parameterTypes) {
        try {
            return this.serviceManagerClass.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot load the ServiceManager", e);
        }
    }

    private Object invoke(Method method, Object obj, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Failed executing ServiceManager." + method.getName(), e.getCause());
        }
    }

    public void start() {
        logger.info("Initializing network services");
        Method start = this.getMethod("start", Boolean.TYPE);
        this.invoke(start, this.serviceManager, false);
    }

    public void stop() {
        logger.info("Stopping network services");
        Method stop = this.getMethod("stop", new Class[0]);
        this.invoke(stop, this.serviceManager, new Object[0]);
    }

    public class AlreadyStartedException
    extends Exception {
        public AlreadyStartedException(String s) {
            super(s);
        }
    }
}

