/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TypedListener;

public class CoolItem
extends Item {
    Control control;
    CoolBar parent;
    boolean ideal;
    int preferredWidth;
    int preferredHeight;
    int minimumWidth;
    int minimumHeight;
    int requestedWidth;
    Rectangle itemBounds = new Rectangle(0, 0, 0, 0);
    static final int MARGIN_WIDTH = 4;
    static final int GRABBER_WIDTH = 2;
    static final int MINIMUM_WIDTH = 10;
    private String CHEVRON_IMAGE = "resource/widget/rap/coolitem/chevron.gif";
    private int CHEVRON_HORIZONTAL_TRIM = -1;
    private int CHEVRON_VERTICAL_TRIM = -1;
    private static final int CHEVRON_LEFT_MARGIN = 2;
    private static final int CHEVRON_IMAGE_WIDTH = 8;
    ToolBar chevron;
    boolean wrap;
    Image arrowImage = null;

    public CoolItem(CoolBar parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
        this.calculateChevronTrim();
    }

    public CoolItem(CoolBar parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, index);
        this.calculateChevronTrim();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
    }

    void calculateChevronTrim() {
        ToolBar tb = new ToolBar(this.parent, 0x800000);
        ToolItem ti = new ToolItem(tb, 8);
        Point size = tb.computeSize(-1, -1);
        size = this.parent.fixPoint(size.x, size.y);
        this.CHEVRON_HORIZONTAL_TRIM = size.x - 1;
        this.CHEVRON_VERTICAL_TRIM = size.y - 1;
        tb.dispose();
        ti.dispose();
    }

    public Point computeSize(int wHint, int hHint) {
        this.checkWidget();
        int width = wHint;
        int height = hHint;
        if (wHint == -1) {
            width = 32;
        }
        if (hHint == -1) {
            height = 32;
        }
        if ((this.parent.style & 0x200) != 0) {
            height += 10;
        } else {
            width += 10;
        }
        return new Point(width, height);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.parent.destroyItem(this);
        super.dispose();
        this.parent = null;
        this.control = null;
        if (this.chevron != null && !this.chevron.isDisposed()) {
            this.chevron.dispose();
        }
        this.chevron = null;
        if (this.arrowImage != null && !this.arrowImage.isDisposed()) {
            this.arrowImage.dispose();
        }
        this.arrowImage = null;
    }

    private Image createArrowImage() {
        Image result;
        ClassLoader classLoader = CoolItem.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this.CHEVRON_IMAGE);
        try {
            result = new Image((Device)this.display, inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException unexpected) {
                throw new RuntimeException("Failed to close image input stream", unexpected);
            }
        }
        return result;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.parent.fixRectangle(this.itemBounds.x, this.itemBounds.y, this.itemBounds.width, this.itemBounds.height);
    }

    Rectangle internalGetBounds() {
        return new Rectangle(this.itemBounds.x, this.itemBounds.y, this.itemBounds.width, this.itemBounds.height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Point getMinimumSize() {
        this.checkWidget();
        return this.parent.fixPoint(this.minimumWidth, this.minimumHeight);
    }

    public CoolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getPreferredSize() {
        this.checkWidget();
        return this.parent.fixPoint(this.preferredWidth, this.preferredHeight);
    }

    public Point getSize() {
        this.checkWidget();
        return this.parent.fixPoint(this.itemBounds.width, this.itemBounds.height);
    }

    int internalGetMinimumWidth() {
        int width = this.minimumWidth + 10;
        if ((this.style & 4) != 0 && width < this.preferredWidth) {
            width += 8 + this.CHEVRON_HORIZONTAL_TRIM + 2;
        }
        return width;
    }

    void onSelection(Event ev) {
        Rectangle bounds = this.chevron.getBounds();
        Event event = new Event();
        event.detail = 4;
        if ((this.parent.style & 0x200) != 0) {
            event.x = bounds.x + bounds.width;
            event.y = bounds.y;
        } else {
            event.x = bounds.x;
            event.y = bounds.y + bounds.height;
        }
        event.widget = this;
        this.notifyListeners(13, event);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    void setBounds(int x, int y, int width, int height) {
        this.itemBounds.x = x;
        this.itemBounds.y = y;
        this.itemBounds.width = width;
        this.itemBounds.height = height;
        if (this.control != null) {
            int controlWidth = width - 10;
            if ((this.style & 4) != 0 && width < this.preferredWidth) {
                controlWidth -= 8 + this.CHEVRON_HORIZONTAL_TRIM + 2;
            }
            this.control.setBounds(this.parent.fixRectangle(x + 10, y, controlWidth, height));
        }
        this.updateChevron();
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        this.control = control;
        if (control != null) {
            int controlWidth = this.itemBounds.width - 10;
            if ((this.style & 4) != 0 && this.itemBounds.width < this.preferredWidth) {
                controlWidth -= 8 + this.CHEVRON_HORIZONTAL_TRIM + 2;
            }
            control.setBounds(this.parent.fixRectangle(this.itemBounds.x + 10, this.itemBounds.y, controlWidth, this.itemBounds.height));
        }
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        Point point = this.parent.fixPoint(width, height);
        this.minimumWidth = point.x;
        this.minimumHeight = point.y;
    }

    public void setMinimumSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setMinimumSize(size.x, size.y);
    }

    public void setPreferredSize(int width, int height) {
        this.checkWidget();
        this.ideal = true;
        Point point = this.parent.fixPoint(width, height);
        this.preferredWidth = Math.max(point.x, 10);
        this.preferredHeight = point.y;
    }

    public void setPreferredSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setPreferredSize(size.x, size.y);
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        int newHeight = height;
        int newWidth = width;
        Point point = this.parent.fixPoint(newWidth, newHeight);
        newWidth = Math.max(point.x, this.minimumWidth + 10);
        newHeight = Math.max(point.y, 0);
        if (!this.ideal) {
            this.preferredWidth = newWidth;
            this.preferredHeight = newHeight;
        }
        this.itemBounds.width = this.requestedWidth = newWidth;
        this.itemBounds.height = newHeight;
        if (this.control != null) {
            int controlWidth = newWidth - 10;
            if ((this.style & 4) != 0 && newWidth < this.preferredWidth) {
                controlWidth -= 8 + this.CHEVRON_HORIZONTAL_TRIM + 2;
            }
            this.control.setSize(this.parent.fixPoint(controlWidth, newHeight));
        }
        this.parent.relayout();
        this.updateChevron();
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setSize(size.x, size.y);
    }

    void updateChevron() {
        if (this.control != null) {
            int width = this.itemBounds.width;
            if ((this.style & 4) != 0 && width < this.preferredWidth) {
                int height;
                int imageHeight;
                int controlHeight;
                if (this.chevron == null) {
                    this.chevron = new ToolBar(this.parent, 0x880000);
                    this.chevron.setBackground(new Color(this.display, 255, 0, 0));
                    ToolItem toolItem = new ToolItem(this.chevron, 8);
                    toolItem.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            CoolItem.this.onSelection(event);
                        }
                    });
                }
                int currentImageHeight = 0;
                if ((this.parent.style & 0x200) != 0) {
                    controlHeight = this.control.getSize().x;
                    if (this.arrowImage != null) {
                        currentImageHeight = this.arrowImage.getBounds().width;
                    }
                } else {
                    controlHeight = this.control.getSize().y;
                    if (this.arrowImage != null) {
                        currentImageHeight = this.arrowImage.getBounds().height;
                    }
                }
                if (currentImageHeight != (imageHeight = Math.max(1, (height = Math.min(controlHeight, this.itemBounds.height)) - this.CHEVRON_VERTICAL_TRIM))) {
                    Image image = this.createArrowImage();
                    this.chevron.getItem(0).setImage(image);
                    if (this.arrowImage != null) {
                        this.arrowImage.dispose();
                    }
                    this.arrowImage = image;
                }
                this.chevron.setBackground(this.parent.getBackground());
                this.chevron.setBounds(this.parent.fixRectangle(this.itemBounds.x + width - 2 - 8 - this.CHEVRON_HORIZONTAL_TRIM, this.itemBounds.y, 8 + this.CHEVRON_HORIZONTAL_TRIM + 10, height));
                this.chevron.setVisible(true);
            } else if (this.chevron != null) {
                this.chevron.setVisible(false);
            }
        }
    }
}

