/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.client;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.ClientFile;
import org.eclipse.rap.rwt.client.service.ClientFileUploader;
import org.eclipse.rap.rwt.internal.client.ClientFileImpl;
import org.eclipse.rap.rwt.internal.remote.ConnectionImpl;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.remote.RemoteObject;

public class ClientFileUploaderImpl
implements ClientFileUploader {
    private static final String REMOTE_ID = "rwt.client.FileUploader";
    private final RemoteObject remoteObject;

    public ClientFileUploaderImpl() {
        ConnectionImpl connection = (ConnectionImpl)RWT.getUISession().getConnection();
        this.remoteObject = connection.createServiceObject(REMOTE_ID);
    }

    public void submit(String url, ClientFile[] clientFiles) {
        ParamCheck.notNullOrEmpty(url, "url");
        ParamCheck.notNull(clientFiles, "clientFiles");
        JsonArray fileIds = new JsonArray();
        ClientFile[] clientFileArray = clientFiles;
        int n = clientFiles.length;
        int n2 = 0;
        while (n2 < n) {
            ClientFile file = clientFileArray[n2];
            fileIds.add(((ClientFileImpl)file).getFileId());
            ++n2;
        }
        if (!fileIds.isEmpty()) {
            JsonObject parameters = new JsonObject().add("url", url).add("fileIds", fileIds);
            this.remoteObject.call("submit", parameters);
        }
    }
}

