/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;

public class ServletInputStreamImpl
extends ServletInputStream {
    private InputStream in;
    private ServletInputStream servletInputStream = null;

    protected ServletInputStreamImpl(InputStream in) {
        this.in = in;
    }

    private void checkOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("ServletInputStream closed");
        }
    }

    public int available() throws IOException {
        this.checkOpen();
        return this.in.available();
    }

    public void close() throws IOException {
        this.in = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServletInputStream getServletInputStream(int len) {
        if (this.servletInputStream == null) {
            ServletInputStreamImpl servletInputStreamImpl = this;
            synchronized (servletInputStreamImpl) {
                if (this.servletInputStream == null) {
                    this.servletInputStream = len > 0 ? new ContentLength(this, len) : this;
                }
            }
        }
        return this.servletInputStream;
    }

    public void mark(int readLimit) {
        this.in.mark(readLimit);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        this.checkOpen();
        return this.in.read();
    }

    public int read(byte[] b) throws IOException {
        this.checkOpen();
        return this.in.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkOpen();
        return this.in.read(b, off, len);
    }

    public void reset() throws IOException {
        this.checkOpen();
        this.in.reset();
    }

    public long skip(long len) throws IOException {
        this.checkOpen();
        return this.in.skip(len);
    }

    static class ContentLength
    extends ServletInputStream {
        private int contentLength;
        private int mark;
        private ServletInputStream in;

        ContentLength(ServletInputStream in, int len) {
            this.in = in;
            this.contentLength = len;
            this.mark = len;
        }

        public int available() throws IOException {
            int avail = this.in.available();
            if (this.contentLength < avail) {
                return this.contentLength;
            }
            return avail;
        }

        public void close() throws IOException {
            this.in.close();
        }

        public void mark(int readLimit) {
            this.in.mark(readLimit);
            this.mark = this.contentLength;
        }

        public boolean markSupported() {
            return this.in.markSupported();
        }

        public int read() throws IOException {
            if (this.contentLength <= 0) {
                return -1;
            }
            int read = this.in.read();
            --this.contentLength;
            return read;
        }

        public int read(byte[] b) throws IOException {
            if (this.contentLength <= 0) {
                return -1;
            }
            int len = b.length;
            if (this.contentLength < len) {
                len = this.contentLength;
            }
            int read = this.in.read(b, 0, len);
            this.contentLength -= read;
            return read;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.contentLength <= 0) {
                return -1;
            }
            if (this.contentLength < len) {
                len = this.contentLength;
            }
            int read = this.in.read(b, off, len);
            this.contentLength -= read;
            return read;
        }

        public void reset() throws IOException {
            this.in.reset();
            this.contentLength = this.mark;
        }

        public long skip(long len) throws IOException {
            if (this.contentLength <= 0) {
                return 0L;
            }
            if ((long)this.contentLength < len) {
                len = this.contentLength;
            }
            long skipped = this.in.skip(len);
            this.contentLength = (int)((long)this.contentLength - skipped);
            return skipped;
        }
    }
}

