/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.Http;
import org.eclipse.equinox.http.Registration;
import org.eclipse.equinox.http.ResourceUnavailableException;
import org.eclipse.equinox.http.SecureAction;
import org.eclipse.equinox.http.servlet.HttpServletRequestImpl;
import org.eclipse.equinox.http.servlet.HttpServletResponseImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class ResourceRegistration
extends HttpServlet
implements Registration {
    private static final long serialVersionUID = -8732464938673729607L;
    protected Bundle bundle;
    protected HttpContext httpContext;
    protected String alias;
    protected String path;
    protected Http http;
    protected SecureAction secureAction;

    protected ResourceRegistration(Bundle bundle, String alias, String path, HttpContext httpContext, Http http) {
        this.bundle = bundle;
        this.alias = alias;
        this.path = path;
        this.httpContext = httpContext;
        this.http = http;
        this.secureAction = new SecureAction();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    private String computeMimeType(String name, URLConnection conn) {
        String mimeType = this.httpContext.getMimeType(name);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = conn.getContentType();
        if (mimeType != null) {
            return mimeType;
        }
        return this.http.getMimeType(name);
    }

    public void destroy() {
        this.alias = null;
        this.path = null;
    }

    public String getAlias() {
        return this.alias;
    }

    public void service(HttpServletRequestImpl request, HttpServletResponseImpl response) throws ServletException, IOException {
        request.init(this.alias, null);
        super.service((HttpServletRequest)request, (HttpServletResponse)response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        InputStream in;
        long modified;
        String filename = this.getFilename(request.getRequestURI());
        URL url = this.httpContext.getResource(filename);
        if (url == null) {
            throw new ResourceUnavailableException();
        }
        URLConnection conn = this.secureAction.openURL(url);
        long modifiedSince = request.getDateHeader("If-Modified-Since");
        if (modifiedSince >= 0L && (modified = conn.getLastModified()) > 0L && modifiedSince >= modified) {
            response.setStatus(304);
            return;
        }
        try {
            in = conn.getInputStream();
        }
        catch (IOException iOException) {
            response.sendError(404);
            return;
        }
        try {
            int contentlength = conn.getContentLength();
            if (contentlength >= 0) {
                response.setContentLength(contentlength);
            }
            String mimeType = this.computeMimeType(filename, conn);
            response.setContentType(mimeType);
            if (mimeType.startsWith("text/")) {
                int read;
                PrintWriter writer = response.getWriter();
                writer.flush();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                char[] buffer = new char[4096];
                while ((read = reader.read(buffer, 0, buffer.length)) != -1) {
                    writer.write(buffer, 0, read);
                }
            } else {
                int read;
                ServletOutputStream out = response.getOutputStream();
                out.flush();
                byte[] buffer = new byte[4096];
                while ((read = in.read(buffer, 0, buffer.length)) != -1) {
                    out.write(buffer, 0, read);
                }
            }
        }
        finally {
            in.close();
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String filename = this.getFilename(request.getRequestURI());
        URL url = this.httpContext.getResource(filename);
        if (url == null) {
            throw new ResourceUnavailableException();
        }
        URLConnection conn = this.secureAction.openURL(url);
        int contentlength = conn.getContentLength();
        if (contentlength >= 0) {
            response.setContentLength(contentlength);
            String mimeType = this.computeMimeType(filename, conn);
            response.setContentType(mimeType);
        } else {
            super.doHead(request, response);
        }
    }

    protected String getFilename(String filename) {
        if (filename.equals(this.alias)) {
            filename = this.path;
        } else {
            int aliaslen = this.alias.length();
            int pathlen = this.path.length();
            if (pathlen == 1) {
                if (aliaslen > 1) {
                    filename = filename.substring(aliaslen);
                }
            } else {
                StringBuffer buf = new StringBuffer(aliaslen + pathlen);
                buf.append(this.path);
                if (aliaslen == 1) {
                    buf.append(filename);
                } else {
                    buf.append(filename.substring(aliaslen));
                }
                filename = buf.toString();
            }
        }
        return filename;
    }
}

