/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.context.request.SessionScope;
import org.springframework.web.portlet.context.PortletContextScope;
import org.springframework.web.portlet.context.PortletRequestAttributes;

public abstract class PortletApplicationContextUtils {
    public static ApplicationContext getWebApplicationContext(PortletContext pc) {
        Assert.notNull((Object)pc, (String)"PortletContext must not be null");
        Object attr = pc.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (attr == null) {
            return null;
        }
        if (attr instanceof RuntimeException) {
            throw (RuntimeException)attr;
        }
        if (attr instanceof Error) {
            throw (Error)attr;
        }
        if (!(attr instanceof ApplicationContext)) {
            throw new IllegalStateException("Root context attribute is not of type WebApplicationContext: " + attr);
        }
        return (ApplicationContext)attr;
    }

    public static ApplicationContext getRequiredWebApplicationContext(PortletContext pc) throws IllegalStateException {
        ApplicationContext wac = PortletApplicationContextUtils.getWebApplicationContext(pc);
        if (wac == null) {
            throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
        }
        return wac;
    }

    static void registerPortletApplicationScopes(ConfigurableListableBeanFactory beanFactory, PortletContext pc) {
        beanFactory.registerScope("request", (Scope)new RequestScope());
        beanFactory.registerScope("session", (Scope)new SessionScope(false));
        beanFactory.registerScope("globalSession", (Scope)new SessionScope(true));
        if (pc != null) {
            PortletContextScope appScope = new PortletContextScope(pc);
            beanFactory.registerScope("application", (Scope)appScope);
            pc.setAttribute(PortletContextScope.class.getName(), (Object)appScope);
        }
        beanFactory.registerResolvableDependency(PortletRequest.class, (Object)new RequestObjectFactory());
        beanFactory.registerResolvableDependency(PortletSession.class, (Object)new SessionObjectFactory());
    }

    static void registerEnvironmentBeans(ConfigurableListableBeanFactory bf, ServletContext sc, PortletContext pc, PortletConfig config) {
        if (sc != null && !bf.containsBean("servletContext")) {
            bf.registerSingleton("servletContext", (Object)sc);
        }
        if (pc != null && !bf.containsBean("portletContext")) {
            bf.registerSingleton("portletContext", (Object)pc);
        }
        if (config != null && !bf.containsBean("portletConfig")) {
            bf.registerSingleton("portletConfig", (Object)config);
        }
        if (!bf.containsBean("contextParameters")) {
            String paramName;
            Enumeration paramNameEnum;
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            if (pc != null) {
                paramNameEnum = pc.getInitParameterNames();
                while (paramNameEnum.hasMoreElements()) {
                    paramName = (String)paramNameEnum.nextElement();
                    parameterMap.put(paramName, pc.getInitParameter(paramName));
                }
            }
            if (config != null) {
                paramNameEnum = config.getInitParameterNames();
                while (paramNameEnum.hasMoreElements()) {
                    paramName = (String)paramNameEnum.nextElement();
                    parameterMap.put(paramName, config.getInitParameter(paramName));
                }
            }
            bf.registerSingleton("contextParameters", Collections.unmodifiableMap(parameterMap));
        }
        if (!bf.containsBean("contextAttributes")) {
            HashMap<String, Object> attributeMap = new HashMap<String, Object>();
            if (pc != null) {
                Enumeration attrNameEnum = pc.getAttributeNames();
                while (attrNameEnum.hasMoreElements()) {
                    String attrName = (String)attrNameEnum.nextElement();
                    attributeMap.put(attrName, pc.getAttribute(attrName));
                }
            }
            bf.registerSingleton("contextAttributes", Collections.unmodifiableMap(attributeMap));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestObjectFactory
    implements ObjectFactory<PortletRequest>,
    Serializable {
        private RequestObjectFactory() {
        }

        public PortletRequest getObject() {
            RequestAttributes requestAttr = RequestContextHolder.currentRequestAttributes();
            if (!(requestAttr instanceof PortletRequestAttributes)) {
                throw new IllegalStateException("Current request is not a portlet request");
            }
            return ((PortletRequestAttributes)requestAttr).getRequest();
        }

        public String toString() {
            return "Current PortletRequest";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SessionObjectFactory
    implements ObjectFactory<PortletSession>,
    Serializable {
        private SessionObjectFactory() {
        }

        public PortletSession getObject() {
            RequestAttributes requestAttr = RequestContextHolder.currentRequestAttributes();
            if (!(requestAttr instanceof PortletRequestAttributes)) {
                throw new IllegalStateException("Current request is not a portlet request");
            }
            return ((PortletRequestAttributes)requestAttr).getRequest().getPortletSession();
        }

        public String toString() {
            return "Current PortletSession";
        }
    }
}

