/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.admin.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.virgo.apps.admin.core.BundleHolder;
import org.eclipse.virgo.apps.admin.core.FailedResolutionHolder;
import org.eclipse.virgo.apps.admin.core.PackagesCollection;
import org.eclipse.virgo.apps.admin.core.StateHolder;
import org.eclipse.virgo.apps.admin.web.internal.DumpListFormatterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public final class StateController {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateController.class);
    private static final String BUNDLE_ID_NAME = "id";
    private static final String STATE_NAME = "state";
    private static final String FORMATTED_STATE_NAME = "fState";
    private static final String LIVE_STATE_NAME = "Live";
    private static final String BUNDLE_NAME = "name";
    private static final String VERSION_NAME = "version";
    private static final String REGION_NAME = "region";
    private final StateHolder stateHolder;
    private final DumpListFormatterUtil dumpListFormatterUtil;

    @Autowired
    public StateController(StateHolder stateHolder, DumpListFormatterUtil dumpListFormatterUtil) {
        this.stateHolder = stateHolder;
        this.dumpListFormatterUtil = dumpListFormatterUtil;
    }

    @RequestMapping(value={"/state/bundles.htm"})
    public ModelAndView bundles(HttpServletRequest request) throws ServletRequestBindingException {
        String newState = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)STATE_NAME);
        List bundleHolders = this.stateHolder.getAllBundles(newState);
        Collections.sort(bundleHolders);
        HashMap<String, List> model = new HashMap<String, List>();
        model.put("bundles", bundleHolders);
        return this.createStateModelAndView("state-bundles", request, model);
    }

    @RequestMapping(value={"/state/services.htm"})
    public ModelAndView services(HttpServletRequest request) throws ServletRequestBindingException {
        String newState = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)STATE_NAME);
        List serviceHolders = this.stateHolder.getAllServices(newState);
        Collections.sort(serviceHolders);
        HashMap<String, List> model = new HashMap<String, List>();
        model.put("services", serviceHolders);
        return this.createStateModelAndView("state-services", request, model);
    }

    @RequestMapping(value={"/state/bundle.htm"})
    public ModelAndView bundle(HttpServletRequest request) throws ServletRequestBindingException {
        Long bundleId = ServletRequestUtils.getLongParameter((ServletRequest)request, (String)BUNDLE_ID_NAME);
        String name = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)BUNDLE_NAME);
        String version = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)VERSION_NAME);
        String region = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)REGION_NAME);
        String newState = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)STATE_NAME);
        HashMap<String, String> model = new HashMap<String, String>();
        BundleHolder bundleHolder = null;
        try {
            if (bundleId != null) {
                bundleHolder = this.stateHolder.getBundle(newState, bundleId.longValue());
            } else if (name != null && version != null && region != null) {
                bundleHolder = this.stateHolder.getBundle(newState, name, version, region);
            }
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Error while retrieving bundle '%d%s'", bundleId, name), (Throwable)e);
        }
        if (bundleHolder != null) {
            model.put("title", String.format("Viewing bundle '%s: %s'", bundleHolder.getSymbolicName(), bundleHolder.getVersion()));
            model.put("bundle", (String)bundleHolder);
        } else {
            model.put("title", "No bundle has been requested");
        }
        return this.createStateModelAndView("state-bundle", request, model);
    }

    @RequestMapping(value={"/state/packages.htm"})
    public ModelAndView packages(HttpServletRequest request) throws ServletRequestBindingException {
        String packageName = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)BUNDLE_NAME);
        String newState = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)STATE_NAME);
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (packageName != null) {
            PackagesCollection packages = this.stateHolder.getPackages(newState, packageName);
            model.put("importers", packages.getImported());
            model.put("exporters", packages.getExported());
            model.put("title", String.format("Viewing package '%s'", packages.getPackageName()));
        } else {
            model.put("title", "No package name has been provided");
        }
        return this.createStateModelAndView("state-packages", request, model);
    }

    @RequestMapping(value={"/state/resolve.htm"})
    public ModelAndView resolve(HttpServletRequest request) throws ServletRequestBindingException {
        Long bundleId = ServletRequestUtils.getLongParameter((ServletRequest)request, (String)BUNDLE_ID_NAME);
        String newState = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)STATE_NAME);
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (bundleId != null) {
            List failedResolutions = this.stateHolder.getResolverReport(newState, bundleId.longValue());
            if (failedResolutions.size() == 0) {
                model.put("title", String.format("No resolution faliures found for bundle '%s'", bundleId));
            } else {
                FailedResolutionHolder quasiResolutionFailure = (FailedResolutionHolder)failedResolutions.get(0);
                model.put("title", String.format("State resolver report for '%s - %s'", quasiResolutionFailure.getUnresolvedBundle().getSymbolicName(), quasiResolutionFailure.getUnresolvedBundle().getVersion()));
                model.put("failure", failedResolutions);
            }
        } else {
            model.put("title", "No bundle has been requested");
        }
        return this.createStateModelAndView("state-resolve", request, model);
    }

    @RequestMapping(value={"/state/search.htm"})
    public ModelAndView search(HttpServletRequest request) throws ServletRequestBindingException {
        String term = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"term");
        String newState = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)STATE_NAME);
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (term != null) {
            List matchingBundles = this.stateHolder.search(newState, term);
            model.put("title", String.format("Search results for '%s'", term));
            model.put("bundles", matchingBundles);
        } else {
            model.put("title", "No search term given");
        }
        return this.createStateModelAndView("state-search", request, model);
    }

    private ModelAndView createStateModelAndView(String viewName, HttpServletRequest request, Map<String, Object> model) throws ServletRequestBindingException {
        Map dumps = this.dumpListFormatterUtil.getAvaliableDumps();
        model.put("stateSources", dumps);
        String newState = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)STATE_NAME);
        if (newState == null || LIVE_STATE_NAME.equals(newState)) {
            model.put(STATE_NAME, LIVE_STATE_NAME);
            model.put(FORMATTED_STATE_NAME, LIVE_STATE_NAME);
        } else {
            model.put(STATE_NAME, newState);
            model.put(FORMATTED_STATE_NAME, dumps.get(newState));
        }
        return new ModelAndView(viewName, model);
    }
}

