/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.eclipse.gemini.web.core.spi.ServletContainerException;
import org.eclipse.gemini.web.tomcat.internal.BundleDependenciesJarScanner;
import org.eclipse.gemini.web.tomcat.internal.ChainingJarScanner;
import org.eclipse.gemini.web.tomcat.internal.TomcatConfigLocator;
import org.eclipse.gemini.web.tomcat.internal.WebappConfigLocator;
import org.eclipse.gemini.web.tomcat.internal.loading.ChainedClassLoader;
import org.eclipse.gemini.web.tomcat.internal.support.BundleFileResolverFactory;
import org.eclipse.gemini.web.tomcat.internal.support.PackageAdminBundleDependencyDeterminer;
import org.eclipse.virgo.util.io.FatalIOException;
import org.eclipse.virgo.util.io.PathReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class OsgiAwareEmbeddedTomcat
extends Tomcat {
    private static final String ROOT_CONTEXT_PATH = "";
    private static final String ROOT_PATH = "/";
    private static final Logger LOGGER = LoggerFactory.getLogger(OsgiAwareEmbeddedTomcat.class);
    private final ExtendCatalina catalina = new ExtendCatalina();
    private final JarScanner jarScanner;
    private final BundleContext bundleContext;
    private File configDir;
    private String defaultContextXml;
    private String defaultWeb;
    private String oldCatalinaBaseDir;
    private String oldCatalinaHomeDir;
    protected volatile HashMap<String, Authenticator> authenticators;
    private final Object monitor = new Object();

    OsgiAwareEmbeddedTomcat(BundleContext context, PackageAdmin packageAdmin) {
        this.bundleContext = context;
        BundleDependenciesJarScanner bundleDependenciesJarScanner = new BundleDependenciesJarScanner(new PackageAdminBundleDependencyDeterminer(context, packageAdmin), BundleFileResolverFactory.createBundleFileResolver());
        StandardJarScanner defaultJarScanner = new StandardJarScanner();
        this.jarScanner = new ChainingJarScanner(new JarScanner[]{bundleDependenciesJarScanner, defaultJarScanner});
    }

    public void start() throws LifecycleException {
        this.getServer();
        this.server.start();
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Service getService() {
        Server server = this.getServer();
        Service[] findServices = server.findServices();
        if (findServices != null && findServices.length > 0) {
            return findServices[0];
        }
        throw new IllegalStateException("Unable to locate Service.");
    }

    public Host getHost() {
        return this.findHost();
    }

    public Engine getEngine() {
        return this.findEngine();
    }

    private Engine findEngine() {
        Service[] findServices;
        Server server = this.getServer();
        Service[] serviceArray = findServices = server.findServices();
        int n = findServices.length;
        int n2 = 0;
        while (n2 < n) {
            Service service = serviceArray[n2];
            Container container = service.getContainer();
            if (container instanceof Engine) {
                return (Engine)container;
            }
            ++n2;
        }
        throw new IllegalStateException("Unable to locate Engine.");
    }

    private Host findHost() {
        Container[] children;
        Engine engine = this.findEngine();
        Container[] containerArray = children = engine.findChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Container container = containerArray[n2];
            if (container instanceof Host) {
                return (Host)container;
            }
            ++n2;
        }
        throw new IllegalStateException("Unable to locate Host.");
    }

    public void init() throws LifecycleException {
        this.getServer();
        this.enableNaming();
        this.server.init();
    }

    public void destroy() throws LifecycleException {
        super.destroy();
        if (this.oldCatalinaBaseDir != null) {
            System.setProperty("catalina.base", this.oldCatalinaBaseDir);
        }
        if (this.oldCatalinaHomeDir != null) {
            System.setProperty("catalina.home", this.oldCatalinaHomeDir);
        }
    }

    public Context addWebapp(String path, String docBase) {
        return this.addWebapp(path, docBase, null);
    }

    public Context addWebapp(String path, String docBase, Bundle bundle) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating context '" + path + "' with docBase '" + docBase + "'");
        }
        ExtendedStandardContext context = new ExtendedStandardContext();
        ExtendedContextConfig config = new ExtendedContextConfig();
        if (this.configDir == null) {
            this.configDir = TomcatConfigLocator.resolveConfigDir(this.bundleContext);
        }
        config.setConfigBase(this.configDir);
        if (this.defaultWeb == null) {
            this.defaultWeb = WebappConfigLocator.resolveDefaultWebXml(this.configDir);
        }
        config.setDefaultWebXml(this.defaultWeb);
        if (this.defaultContextXml == null) {
            this.defaultContextXml = WebappConfigLocator.resolveDefaultContextXml(this.configDir);
        }
        config.setDefaultContextXml(this.defaultContextXml);
        Host host = this.getHost();
        File configLocation = WebappConfigLocator.resolveWebappConfigDir(this.configDir, host);
        try {
            context.setConfigFile(WebappConfigLocator.resolveWebappContextXml(path, docBase, configLocation, bundle));
        }
        catch (MalformedURLException e) {
            throw new ServletContainerException("Cannot resolve web application's context.xml " + docBase, (Throwable)e);
        }
        context.setDocBase(docBase);
        context.setPath(path.equals(ROOT_PATH) ? ROOT_CONTEXT_PATH : path);
        context.setJarScanner(this.jarScanner);
        context.setParent((Container)host);
        config.setCustomAuthenticators(this.authenticators);
        context.addLifecycleListener((LifecycleListener)config);
        return context;
    }

    public void configure(InputStream configuration) {
        this.initBaseDir();
        Digester digester = this.catalina.createStartDigester();
        digester.push((Object)this);
        ClassLoader[] loaders = new ClassLoader[]{Catalina.class.getClassLoader(), ((Object)((Object)this)).getClass().getClassLoader()};
        digester.setClassLoader((ClassLoader)ChainedClassLoader.create(loaders));
        try {
            digester.parse(configuration);
        }
        catch (IOException e) {
            throw new ServletContainerException("Error reading Tomcat configuration file.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new ServletContainerException("Error parsing Tomcat XML configuration.", (Throwable)e);
        }
        this.configDir = TomcatConfigLocator.resolveConfigDir(this.bundleContext);
        this.defaultContextXml = WebappConfigLocator.resolveDefaultContextXml(this.configDir);
        this.defaultWeb = WebappConfigLocator.resolveDefaultWebXml(this.configDir);
    }

    protected void initBaseDir() {
        if (this.basedir == null) {
            this.basedir = System.getProperty("catalina.base");
        }
        if (this.basedir == null) {
            this.basedir = System.getProperty("catalina.home");
        }
        if (this.basedir == null) {
            this.basedir = System.getProperty("user.dir");
            PathReference home = new PathReference(this.basedir);
            home.createDirectory();
            if (!home.isAbsolute()) {
                try {
                    this.basedir = home.getCanonicalPath();
                }
                catch (FatalIOException fatalIOException) {
                    this.basedir = home.getAbsolutePath();
                }
            }
        }
        this.oldCatalinaHomeDir = System.setProperty("catalina.home", this.basedir);
        this.oldCatalinaBaseDir = System.setProperty("catalina.base", this.basedir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthenticator(Authenticator authenticator, String loginMethod) {
        if (!(authenticator instanceof Valve)) {
            throw new IllegalArgumentException("Specified Authenticator is not a Valve");
        }
        if (this.authenticators == null) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.authenticators == null) {
                    this.authenticators = new HashMap();
                }
            }
        }
        this.authenticators.put(loginMethod, authenticator);
    }

    private static class ExtendCatalina
    extends Catalina {
        private ExtendCatalina() {
        }

        public Digester createStartDigester() {
            return super.createStartDigester();
        }
    }

    private static class ExtendedContextConfig
    extends ContextConfig {
        private File configDir;

        private ExtendedContextConfig() {
        }

        protected File getConfigBase() {
            File configBase = super.getConfigBase();
            if (configBase != null) {
                return configBase;
            }
            if (this.configDir != null) {
                return this.configDir;
            }
            return null;
        }

        protected void setConfigBase(File configDir) {
            this.configDir = configDir;
        }
    }

    private static class ExtendedStandardContext
    extends StandardContext {
        private static final long serialVersionUID = 6914580440115519171L;

        private ExtendedStandardContext() {
        }

        public boolean isFilesystemBased() {
            String docBase = this.getDocBase();
            File f = new File(docBase);
            return f.isDirectory();
        }
    }
}

