/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tomcat.util.bcel.classfile.Attribute;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.Code;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.util.bcel.classfile.ExceptionTable;
import org.apache.tomcat.util.bcel.classfile.FieldOrMethod;
import org.apache.tomcat.util.bcel.classfile.LocalVariableTable;
import org.apache.tomcat.util.bcel.classfile.Utility;
import org.apache.tomcat.util.bcel.util.BCELComparator;

public final class Method
extends FieldOrMethod {
    private static final long serialVersionUID = -7447828891136739513L;
    private static BCELComparator _cmp = new BCELComparator(){

        @Override
        public boolean equals(Object o1, Object o2) {
            Method THIS = (Method)o1;
            Method THAT = (Method)o2;
            return THIS.getName().equals(THAT.getName()) && THIS.getSignature().equals(THAT.getSignature());
        }

        @Override
        public int hashCode(Object o) {
            Method THIS = (Method)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };

    public Method() {
    }

    Method(DataInputStream file, ConstantPool constant_pool) throws IOException, ClassFormatException {
        super(file, constant_pool);
    }

    public final Code getCode() {
        for (int i = 0; i < this.attributes_count; ++i) {
            if (!(this.attributes[i] instanceof Code)) continue;
            return (Code)this.attributes[i];
        }
        return null;
    }

    public final ExceptionTable getExceptionTable() {
        for (int i = 0; i < this.attributes_count; ++i) {
            if (!(this.attributes[i] instanceof ExceptionTable)) continue;
            return (ExceptionTable)this.attributes[i];
        }
        return null;
    }

    public final LocalVariableTable getLocalVariableTable() {
        Code code = this.getCode();
        if (code == null) {
            return null;
        }
        return code.getLocalVariableTable();
    }

    public final String toString() {
        String str;
        String access = Utility.accessToString(this.access_flags);
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        String signature = c.getBytes();
        c = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        String name = c.getBytes();
        signature = Utility.methodSignatureToString(signature, name, access, true, this.getLocalVariableTable());
        StringBuffer buf = new StringBuffer(signature);
        for (int i = 0; i < this.attributes_count; ++i) {
            Attribute a = this.attributes[i];
            if (a instanceof Code || a instanceof ExceptionTable) continue;
            buf.append(" [").append(a.toString()).append("]");
        }
        ExceptionTable e = this.getExceptionTable();
        if (e != null && !(str = e.toString()).equals("")) {
            buf.append("\n\t\tthrows ").append(str);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        return _cmp.equals(this, obj);
    }

    public int hashCode() {
        return _cmp.hashCode(this);
    }
}

