/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.completers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.virgo.shell.CommandCompleter;
import org.eclipse.virgo.shell.internal.CommandDescriptor;
import org.eclipse.virgo.shell.internal.CommandRegistry;

final class HelpCommandCompleter
implements CommandCompleter {
    private final CommandRegistry commandRegistry;

    HelpCommandCompleter(CommandRegistry commandRegistry) {
        this.commandRegistry = commandRegistry;
    }

    @Override
    public List<String> getCompletionCandidates(String subCommand, String ... arguments) {
        ArrayList<String> candidates = new ArrayList<String>();
        if (arguments.length == 0) {
            List<CommandDescriptor> commandDescriptors = this.commandRegistry.getCommandDescriptors();
            for (CommandDescriptor commandDescriptor : commandDescriptors) {
                if (!commandDescriptor.getCommandName().startsWith(subCommand)) continue;
                candidates.add(commandDescriptor.getCommandName());
            }
        }
        Collections.sort(candidates);
        return candidates;
    }
}

